/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tools;

import com.direwolf20.buildinggadgets.common.items.ModItems;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.gadgets.GadgetGeneric;
import com.direwolf20.buildinggadgets.common.items.pastes.ConstructionPaste;
import com.direwolf20.buildinggadgets.common.items.pastes.GenericPasteContainer;
import com.direwolf20.buildinggadgets.common.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.common.tools.NetworkIO;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockDoubleStoneSlab;
import net.minecraft.block.BlockDoubleWoodSlab;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class InventoryManipulation {
    private static IProperty AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    private static final Set<IProperty> SAFE_PROPERTIES = ImmutableSet.of((Object)BlockSlab.field_176554_a, (Object)BlockStairs.field_176308_b, (Object)BlockLog.field_176299_a, (Object)AXIS, (Object)BlockDirectional.field_176387_N, (Object)BlockStairs.field_176309_a, (Object[])new IProperty[]{BlockTrapDoor.field_176285_M, BlockTorch.field_176596_a, BlockStairs.field_176310_M, BlockLever.field_176360_a, BlockLever.field_176359_b, BlockRedstoneRepeater.field_176410_b, BlockStoneSlab.field_176556_M, BlockWoodSlab.field_176557_b, BlockDoubleWoodSlab.field_176557_b, BlockDoubleStoneSlab.field_176556_M});
    private static final Set<IProperty> SAFE_PROPERTIES_COPY_PASTE = ImmutableSet.builder().addAll(SAFE_PROPERTIES).addAll((Iterable)ImmutableSet.of((Object)BlockDoubleWoodSlab.field_176557_b, (Object)BlockRail.field_176565_b, (Object)BlockRailPowered.field_176568_b)).build();

    public static boolean giveItem(ItemStack itemStack, EntityPlayer player, World world) {
        List<IItemHandler> invContainers;
        ItemStack giveItemStack;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (itemStack.func_77973_b() instanceof ConstructionPaste) {
            itemStack = InventoryManipulation.addPasteToContainer(player, itemStack);
        }
        if (itemStack.func_190916_E() == 0) {
            return true;
        }
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItem(itemStack.func_77973_b(), itemStack.func_77960_j(), inv);
        for (int slot : slots) {
            boolean success;
            ItemStack stackInSlot = inv.func_70301_a(slot);
            if (stackInSlot.func_190916_E() >= stackInSlot.func_77973_b().getItemStackLimit(stackInSlot) || !(success = inv.func_70441_a(giveItemStack = itemStack.func_77946_l()))) continue;
            return true;
        }
        ItemStack tool = GadgetGeneric.getGadget(player);
        IItemHandler remoteInventory = GadgetUtils.getRemoteInventory(tool, world, player, NetworkIO.Operation.INSERT);
        if (remoteInventory != null) {
            for (int i = 0; i < remoteInventory.getSlots(); ++i) {
                ItemStack containerItem = remoteInventory.getStackInSlot(i);
                ItemStack giveItemStack2 = itemStack.func_77946_l();
                if ((containerItem.func_77973_b() != itemStack.func_77973_b() || containerItem.func_77960_j() != itemStack.func_77960_j()) && !containerItem.func_190926_b()) continue;
                if ((giveItemStack2 = remoteInventory.insertItem(i, giveItemStack2, false)).func_190926_b()) {
                    return true;
                }
                itemStack = giveItemStack2.func_77946_l();
            }
        }
        if ((invContainers = InventoryManipulation.findInvContainers(inv)).size() > 0) {
            for (IItemHandler container : invContainers) {
                for (int i = 0; i < container.getSlots(); ++i) {
                    ItemStack containerItem = container.getStackInSlot(i);
                    ItemStack giveItemStack3 = itemStack.func_77946_l();
                    if (containerItem.func_77973_b() != giveItemStack3.func_77973_b() || containerItem.func_77960_j() != giveItemStack3.func_77960_j()) continue;
                    if ((giveItemStack3 = container.insertItem(i, giveItemStack3, false)).func_190926_b()) {
                        return true;
                    }
                    itemStack = giveItemStack3.func_77946_l();
                }
            }
        }
        giveItemStack = itemStack.func_77946_l();
        boolean success = inv.func_70441_a(giveItemStack);
        return success;
    }

    public static boolean useItem(ItemStack itemStack, EntityPlayer player, int count, World world) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack tool = GadgetGeneric.getGadget(player);
        IItemHandler remoteInventory = GadgetUtils.getRemoteInventory(tool, world, player);
        if (remoteInventory != null) {
            for (int i = 0; i < remoteInventory.getSlots(); ++i) {
                ItemStack containerItem = remoteInventory.getStackInSlot(i);
                if (containerItem.func_77973_b() != itemStack.func_77973_b() || containerItem.func_77960_j() != itemStack.func_77960_j() || containerItem.func_190916_E() < count) continue;
                remoteInventory.extractItem(i, count, false);
                return true;
            }
        }
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItem(itemStack.func_77973_b(), itemStack.func_77960_j(), inv);
        List<IItemHandler> invContainers = InventoryManipulation.findInvContainers(inv);
        if (invContainers.size() > 0) {
            for (IItemHandler container : invContainers) {
                for (int i = 0; i < container.getSlots(); ++i) {
                    ItemStack containerItem = container.getStackInSlot(i);
                    if (containerItem.func_77973_b() != itemStack.func_77973_b() || containerItem.func_77960_j() != itemStack.func_77960_j() || containerItem.func_190916_E() < count) continue;
                    container.extractItem(i, count, false);
                    return true;
                }
            }
        }
        if (slots.size() == 0) {
            return false;
        }
        int slot = slots.get(0);
        ItemStack stackInSlot = inv.func_70301_a(slot);
        if (stackInSlot.func_190916_E() < count) {
            return false;
        }
        stackInSlot.func_190918_g(count);
        return true;
    }

    public static int countItem(ItemStack itemStack, EntityPlayer player, World world) {
        return InventoryManipulation.countItem(itemStack, player, (ItemStack tool, ItemStack stack) -> {
            IItemHandler remoteInventory = GadgetUtils.getRemoteInventory(tool, world, player);
            return remoteInventory == null ? 0 : InventoryManipulation.countInContainer(remoteInventory, stack.func_77973_b(), stack.func_77960_j());
        });
    }

    public static int countItem(ItemStack itemStack, EntityPlayer player, IRemoteInventoryProvider remoteInventory) {
        if (player.field_71075_bZ.field_75098_d) {
            return Integer.MAX_VALUE;
        }
        long count = remoteInventory.countItem(GadgetGeneric.getGadget(player), itemStack);
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItem(itemStack.func_77973_b(), itemStack.func_77960_j(), inv);
        List<IItemHandler> invContainers = InventoryManipulation.findInvContainers(inv);
        if (slots.size() == 0 && invContainers.size() == 0 && count == 0L) {
            return 0;
        }
        if (invContainers.size() > 0) {
            for (IItemHandler container : invContainers) {
                count += (long)InventoryManipulation.countInContainer(container, itemStack.func_77973_b(), itemStack.func_77960_j());
            }
        }
        Iterator<Object> iterator = slots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            ItemStack stackInSlot = inv.func_70301_a(slot);
            count += (long)stackInSlot.func_190916_E();
        }
        return InventoryManipulation.longToInt(count);
    }

    public static int countPaste(EntityPlayer player) {
        List<Integer> containerSlots;
        if (player.field_71075_bZ.field_75098_d) {
            return Integer.MAX_VALUE;
        }
        long count = 0L;
        ConstructionPaste item = ModItems.constructionPaste;
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItem(item, 0, inv);
        if (slots.size() > 0) {
            for (int slot : slots) {
                ItemStack stackInSlot = inv.func_70301_a(slot);
                count += (long)stackInSlot.func_190916_E();
            }
        }
        if ((containerSlots = InventoryManipulation.findItemClass(GenericPasteContainer.class, inv)).size() > 0) {
            for (int slot : containerSlots) {
                ItemStack stackInSlot = inv.func_70301_a(slot);
                if (!(stackInSlot.func_77973_b() instanceof GenericPasteContainer)) continue;
                count += (long)GenericPasteContainer.getPasteAmount(stackInSlot);
            }
        }
        return InventoryManipulation.longToInt(count);
    }

    public static int longToInt(long count) {
        try {
            return Math.toIntExact(count);
        }
        catch (ArithmeticException e) {
            return Integer.MAX_VALUE;
        }
    }

    public static ItemStack addPasteToContainer(EntityPlayer player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ConstructionPaste)) {
            return itemStack;
        }
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItemClass(GenericPasteContainer.class, inv);
        if (slots.size() == 0) {
            return itemStack;
        }
        HashMap<Integer, Integer> slotMap = new HashMap<Integer, Integer>();
        for (int slot : slots) {
            slotMap.put(slot, GenericPasteContainer.getPasteAmount(inv.func_70301_a(slot)));
        }
        ArrayList list = new ArrayList(slotMap.entrySet());
        Comparator<Map.Entry> comparator = Comparator.comparing(entry -> (Integer)entry.getValue());
        comparator = comparator.reversed();
        list.sort(comparator);
        for (Map.Entry entry2 : list) {
            ItemStack containerStack = inv.func_70301_a(((Integer)entry2.getKey()).intValue());
            int maxAmount = ((GenericPasteContainer)containerStack.func_77973_b()).getMaxCapacity();
            int pasteInContainer = GenericPasteContainer.getPasteAmount(containerStack);
            int freeSpace = maxAmount - pasteInContainer;
            int stackSize = itemStack.func_190916_E();
            int remainingPaste = stackSize - freeSpace;
            if (remainingPaste < 0) {
                remainingPaste = 0;
            }
            int usedPaste = Math.abs(stackSize - remainingPaste);
            itemStack.func_190920_e(remainingPaste);
            GenericPasteContainer.setPasteAmount(containerStack, pasteInContainer + usedPaste);
        }
        return itemStack;
    }

    public static boolean usePaste(EntityPlayer player, int count) {
        List<Integer> containerSlots;
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        InventoryPlayer inv = player.field_71071_by;
        List<Integer> slots = InventoryManipulation.findItem(ModItems.constructionPaste, 0, inv);
        if (slots.size() > 0) {
            for (int slot : slots) {
                ItemStack pasteStack = inv.func_70301_a(slot);
                if (pasteStack.func_190916_E() < count) continue;
                pasteStack.func_190918_g(count);
                return true;
            }
        }
        if ((containerSlots = InventoryManipulation.findItemClass(GenericPasteContainer.class, inv)).size() > 0) {
            for (int slot : containerSlots) {
                int pasteAmt;
                ItemStack containerStack = inv.func_70301_a(slot);
                if (!(containerStack.func_77973_b() instanceof GenericPasteContainer) || (pasteAmt = GenericPasteContainer.getPasteAmount(containerStack)) < count) continue;
                GenericPasteContainer.setPasteAmount(containerStack, pasteAmt - count);
                return true;
            }
        }
        return false;
    }

    private static List<IItemHandler> findInvContainers(InventoryPlayer inv) {
        ArrayList<IItemHandler> containers = new ArrayList<IItemHandler>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) continue;
            containers.add((IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        return containers;
    }

    public static int countInContainer(IItemHandler container, Item item, int meta) {
        int count = 0;
        for (int i = 0; i < container.getSlots(); ++i) {
            ItemStack tempItem = container.getStackInSlot(i);
            if (tempItem.func_77973_b() != item || tempItem.func_77960_j() != meta) continue;
            count += tempItem.func_190916_E();
        }
        return count;
    }

    private static List<Integer> findItem(Item item, int meta, InventoryPlayer inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != item || meta != stack.func_77960_j()) continue;
            slots.add(i);
        }
        return slots;
    }

    public static List<Integer> findItemClass(Class c, InventoryPlayer inv) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !c.isInstance(stack.func_77973_b())) continue;
            slots.add(i);
        }
        return slots;
    }

    public static ItemStack getSilkTouchDrop(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        int i = 0;
        if (item.func_77614_k()) {
            i = state.func_177230_c().func_180651_a(state);
        }
        return new ItemStack(item, 1, i);
    }

    public static IBlockState getSpecificStates(IBlockState originalState, World world, EntityPlayer player, BlockPos pos, ItemStack tool) {
        IBlockState placeState = Blocks.field_150350_a.func_176223_P();
        Block block = originalState.func_177230_c();
        ItemStack item = block.getPickBlock(originalState, null, world, pos, player);
        int meta = item.func_77960_j();
        try {
            placeState = originalState.func_177230_c().getStateForPlacement(world, pos, EnumFacing.UP, 0.0f, 0.0f, 0.0f, meta, (EntityLivingBase)player, EnumHand.MAIN_HAND);
        }
        catch (Exception var8) {
            placeState = originalState.func_177230_c().func_176223_P();
        }
        for (IProperty prop : placeState.func_177227_a()) {
            if (tool.func_77973_b() instanceof GadgetCopyPaste) {
                if (!SAFE_PROPERTIES_COPY_PASTE.contains(prop)) continue;
                placeState = placeState.func_177226_a(prop, originalState.func_177229_b(prop));
                continue;
            }
            if (!SAFE_PROPERTIES.contains(prop)) continue;
            placeState = placeState.func_177226_a(prop, originalState.func_177229_b(prop));
        }
        return placeState;
    }

    public static interface IRemoteInventoryProvider {
        public int countItem(ItemStack var1, ItemStack var2);
    }
}

