/*
 * Decompiled with CFR 0.152.
 */
package tehnut.harvest;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockStack {
    private final Block block;
    private final int meta;
    private final IBlockState state;

    public BlockStack(Block block, int meta) {
        this.block = block;
        this.meta = meta;
        this.state = block.func_176203_a(meta);
    }

    public BlockStack(Block block) {
        this(block, 0);
    }

    public static BlockStack getStackFromPos(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return new BlockStack(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public IBlockState getState() {
        return this.state;
    }

    public String toString() {
        return this.getBlock().getRegistryName().toString() + ":" + this.getMeta();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockStack that = (BlockStack)o;
        if (this.getMeta() != that.getMeta()) {
            return false;
        }
        if (this.getBlock() != null ? !this.getBlock().equals(that.getBlock()) : that.getBlock() != null) {
            return false;
        }
        return this.getState() != null ? this.getState().equals(that.getState()) : that.getState() == null;
    }

    public int hashCode() {
        int result = this.getBlock() != null ? this.getBlock().hashCode() : 0;
        result = 31 * result + this.getMeta();
        result = 31 * result + (this.getState() != null ? this.getState().hashCode() : 0);
        return result;
    }
}

