/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.dave.bonsaitrees.BonsaiTrees;
import org.dave.bonsaitrees.api.IBonsaiSoil;
import org.dave.bonsaitrees.api.IBonsaiTreeType;
import org.dave.bonsaitrees.api.TreeTypeDrop;
import org.dave.bonsaitrees.base.BaseTileTicking;
import org.dave.bonsaitrees.compat.CraftTweaker2.registries.SoilStatsModificationsRegistry;
import org.dave.bonsaitrees.compat.CraftTweaker2.registries.TreeDropModificationsRegistry;
import org.dave.bonsaitrees.init.Triggerss;
import org.dave.bonsaitrees.misc.ConfigurationHandler;
import org.dave.bonsaitrees.render.PotColorizer;
import org.dave.bonsaitrees.tile.HoppingItemStackBufferHandler;
import org.dave.bonsaitrees.trees.TreeShape;
import org.dave.bonsaitrees.trees.TreeShapeRegistry;

public class TileBonsaiPot
extends BaseTileTicking {
    protected ItemStack sapling = ItemStack.field_190927_a;
    protected ItemStack soilStack = ItemStack.field_190927_a;
    private boolean hasCachedData = false;
    private double calcGrowTime;
    private boolean calcSoilCompatible;
    protected HoppingItemStackBufferHandler hoppingItemBuffer = new HoppingItemStackBufferHandler(){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileBonsaiPot.this.func_70296_d();
        }
    };
    protected String shapeFilename = null;
    protected double progress = 0.0;
    protected IBonsaiTreeType treeType = null;
    protected EnumDyeColor color = PotColorizer.DEFAULT_COLOR;

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        EnumDyeColor before = this.color;
        super.onDataPacket(net, packet);
        EnumDyeColor after = this.color;
        if (before != after) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.func_174877_v()).func_186662_g(1.0).func_72321_a(0.0, 1.0, 0.0);
    }

    @Override
    public boolean retainNbtData() {
        return false;
    }

    public boolean hasSapling() {
        return this.sapling != ItemStack.field_190927_a && this.getTreeType() != null;
    }

    public boolean hasSoil() {
        return this.soilStack != null && !this.soilStack.func_190926_b() && this.soilStack.func_77973_b() instanceof ItemBlock;
    }

    public ItemStack getSoilStack() {
        return this.soilStack.func_77946_l();
    }

    public IBonsaiSoil getBonsaiSoil() {
        return BonsaiTrees.instance.soilRegistry.getTypeByStack(this.soilStack);
    }

    public IBlockState getSoilBlockState() {
        if (!this.hasSoil()) {
            return null;
        }
        ItemBlock soilBlock = (ItemBlock)this.soilStack.func_77973_b();
        return soilBlock.func_179223_d().func_176203_a(this.soilStack.func_77960_j());
    }

    public boolean isHarvestable() {
        return this.hasSapling() && this.progress >= this.calcGrowTime;
    }

    public boolean isGrowing() {
        return this.hasSapling() && this.progress < this.calcGrowTime;
    }

    public ItemStack getSapling() {
        return this.sapling;
    }

    public EnumDyeColor getColor() {
        return this.color;
    }

    public void setColor(EnumDyeColor color) {
        this.color = color;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    private void updateCachedData() {
        if (!this.hasSapling() || !this.hasSoil()) {
            this.calcGrowTime = 0.0;
            this.calcSoilCompatible = false;
            this.hasCachedData = false;
        } else {
            this.calcGrowTime = BonsaiTrees.instance.typeRegistry.getFinalGrowTime(this.getTreeType(), this.getBonsaiSoil());
            this.calcSoilCompatible = BonsaiTrees.instance.soilCompatibility.canTreeGrowOnSoil(this.getTreeType(), this.getBonsaiSoil());
            this.hasCachedData = true;
        }
    }

    public void boostProgress() {
        if (!this.isGrowing()) {
            return;
        }
        this.progress += this.calcGrowTime / 4.0;
        if (this.progress >= this.calcGrowTime) {
            this.progress = this.calcGrowTime;
        }
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void dropSapling() {
        if (this.sapling.func_190926_b()) {
            return;
        }
        this.spawnItem(this.sapling.func_77946_l());
        this.setSapling(ItemStack.field_190927_a);
    }

    public void dropSoil() {
        if (this.soilStack.func_190926_b()) {
            return;
        }
        this.spawnItem(this.soilStack.func_77946_l());
        this.setSoil(ItemStack.field_190927_a);
    }

    private void spawnItem(ItemStack stack) {
        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.7f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), stack);
        entityItem.lifespan = 1200;
        entityItem.func_174867_a(5);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70181_x = 0.1f;
        entityItem.field_70179_y = 0.0;
        this.field_145850_b.func_72838_d((Entity)entityItem);
    }

    public List<ItemStack> getRandomizedDrops() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        List<TreeTypeDrop> drops = TreeDropModificationsRegistry.getModifiedDropList(this.treeType);
        for (TreeTypeDrop drop : drops) {
            int tries = drop.stack.func_190916_E();
            float dropChance = drop.chance * SoilStatsModificationsRegistry.getModifiedDropChanceModifier(this.getBonsaiSoil());
            int count = 0;
            for (int tryNum = 0; tryNum < tries; ++tryNum) {
                if (this.field_145850_b.field_73012_v.nextFloat() >= dropChance) continue;
                ++count;
            }
            if (count == 0) continue;
            if (count > drop.stack.func_77976_d()) {
                count = drop.stack.func_77976_d();
            }
            ItemStack dropCopy = drop.stack.func_77946_l();
            dropCopy.func_190920_e(count);
            result.add(dropCopy);
        }
        return result;
    }

    public int dropLoot() {
        List<ItemStack> drops = this.getRandomizedDrops();
        drops.forEach(this::spawnItem);
        return drops.size();
    }

    public String getBonsaiShapeName() {
        return this.shapeFilename;
    }

    public TreeShape getShapeFilename() {
        return TreeShapeRegistry.getTreeShapeByFilename(this.shapeFilename);
    }

    public IBonsaiTreeType getTreeType() {
        return this.treeType;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.shapeFilename = compound.func_74764_b("shapeFilename") ? compound.func_74779_i("shapeFilename") : null;
        if (compound.func_74764_b("sapling")) {
            this.sapling = new ItemStack(compound.func_74775_l("sapling"));
            this.treeType = BonsaiTrees.instance.typeRegistry.getTypeByStack(this.sapling);
        } else {
            this.sapling = ItemStack.field_190927_a;
            this.treeType = null;
        }
        this.soilStack = compound.func_74764_b("soil") ? new ItemStack(compound.func_74775_l("soil")) : new ItemStack(Blocks.field_150346_d, 1, 0);
        if (this.treeType == null || this.sapling.func_190926_b()) {
            this.sapling = ItemStack.field_190927_a;
            this.shapeFilename = null;
        }
        this.color = compound.func_74764_b("color") ? EnumDyeColor.func_176764_b((int)compound.func_74762_e("color")) : PotColorizer.DEFAULT_COLOR;
        if (compound.func_74764_b("hoppingBuffer")) {
            this.hoppingItemBuffer.deserializeNBT((NBTTagCompound)compound.func_74781_a("hoppingBuffer"));
        }
        this.progress = compound.func_74769_h("progress");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        if (this.shapeFilename != null) {
            compound.func_74778_a("shapeFilename", this.shapeFilename);
        }
        if (this.sapling != ItemStack.field_190927_a) {
            compound.func_74782_a("sapling", (NBTBase)this.sapling.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74780_a("progress", this.progress);
        compound.func_74768_a("color", this.color.func_176765_a());
        compound.func_74782_a("soil", (NBTBase)this.soilStack.func_77955_b(new NBTTagCompound()));
        if (this.isHoppingPot()) {
            compound.func_74782_a("hoppingBuffer", (NBTBase)this.hoppingItemBuffer.serializeNBT());
        }
        return compound;
    }

    public boolean isHoppingPot() {
        return this.func_145832_p() == 1;
    }

    private void updateHoppingExport() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isHoppingPot()) {
            return;
        }
        if (this.hoppingItemBuffer.isEmpty()) {
            return;
        }
        if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b()) == null) {
            return;
        }
        TileEntity below = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
        if (!below.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
            return;
        }
        IItemHandler targetHandler = (IItemHandler)below.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        for (int srcSlot = 0; srcSlot < this.hoppingItemBuffer.getSlots(); ++srcSlot) {
            ItemStack simResult;
            ItemStack stack = this.hoppingItemBuffer.getStackInSlot(srcSlot);
            if (stack.func_190926_b() || !(simResult = ItemHandlerHelper.insertItemStacked((IItemHandler)targetHandler, (ItemStack)stack, (boolean)true)).func_190926_b() && simResult.func_190916_E() >= stack.func_190916_E()) continue;
            ItemStack insertResult = ItemHandlerHelper.insertItemStacked((IItemHandler)targetHandler, (ItemStack)stack, (boolean)false);
            this.hoppingItemBuffer.setStackInSlotInternal(srcSlot, insertResult);
        }
    }

    public HoppingItemStackBufferHandler getHoppingItemBuffer() {
        return this.hoppingItemBuffer;
    }

    private void updateProgress() {
        if (!this.hasSoil() || !this.hasSapling()) {
            this.progress = 0.0;
            return;
        }
        if (!this.calcSoilCompatible) {
            return;
        }
        if (!this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a())) {
            if (this.progress > this.calcGrowTime / 3.0) {
                this.progress = this.calcGrowTime / 3.0;
            }
        } else if (this.progress < this.calcGrowTime) {
            this.progress += 1.0;
        }
        this.func_70296_d();
    }

    private void tryToCutAndExport() {
        if (ConfigurationHandler.GeneralSettings.disableHoppingBonsaiPot) {
            return;
        }
        if (!this.isHoppingPot()) {
            return;
        }
        if (this.func_145831_w().func_175640_z(this.func_174877_v())) {
            return;
        }
        if (!this.hoppingItemBuffer.isEmpty()) {
            if (ConfigurationHandler.GeneralSettings.waitForEmptyItemBuffers) {
                return;
            }
            this.hoppingItemBuffer.clear();
        }
        List<ItemStack> drops = this.getRandomizedDrops();
        int slot = 0;
        for (ItemStack drop : drops) {
            this.hoppingItemBuffer.setStackInSlotInternal(slot, drop);
            ++slot;
        }
        this.progress = 0.0;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    private void checkProgress() {
        PlayerList list;
        EntityPlayerMP player;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.hasSoil() || !this.hasSapling()) {
            return;
        }
        if (this.progress < this.calcGrowTime) {
            return;
        }
        if (this.hasOwner() && (player = (list = this.field_145850_b.func_73046_m().func_184103_al()).func_177451_a(this.getOwner())) != null) {
            Triggerss.GROW_TREE.trigger(player);
        }
        this.tryToCutAndExport();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.hasCachedData) {
            this.updateCachedData();
        }
        this.updateHoppingExport();
        this.updateProgress();
        this.checkProgress();
    }

    public double getProgressPercent() {
        return this.getProgress() / this.calcGrowTime;
    }

    public double getProgress() {
        return this.progress;
    }

    public void setSapling(ItemStack sapling) {
        this.sapling = sapling;
        if (sapling.func_190926_b()) {
            this.treeType = null;
            this.shapeFilename = null;
        } else {
            this.treeType = BonsaiTrees.instance.typeRegistry.getTypeByStack(sapling);
            TreeShape shape = TreeShapeRegistry.getRandomShapeForStack(sapling);
            this.shapeFilename = shape != null ? shape.getFileName() : null;
        }
        this.progress = 0.0;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.updateCachedData();
    }

    public void setSoil(ItemStack soilStack) {
        this.soilStack = soilStack;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
        this.updateCachedData();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)((Object)this.hoppingItemBuffer);
        }
        return null;
    }
}

