/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.tiles;

import QuantumStorage.init.ModBlocks;
import QuantumStorage.tiles.AdvancedTileEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileController
extends AdvancedTileEntity
implements ITickable {
    List<IItemHandler> l = new ArrayList<IItemHandler>();

    public void addInv(IItemHandler handler) {
        if (!this.l.contains(handler)) {
            this.l.add(handler);
        }
    }

    public List<IItemHandler> getItemHandlers() {
        return this.l;
    }

    public void func_73660_a() {
        TileController controller;
        if (!this.field_145850_b.field_72995_K && (controller = (TileController)this.field_145850_b.func_175625_s(this.field_174879_c)) != null) {
            for (IItemHandler invs : TileController.getConnectedCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.field_145850_b, this.field_174879_c)) {
                this.addInv(invs);
            }
        }
    }

    public static <T> List<T> getConnectedCapabilities(Capability<T> capability, World world, BlockPos pos) {
        ArrayList<Object> capabilities = new ArrayList<Object>();
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity tile = world.func_175625_s(pos.func_177972_a(side));
            if (tile == null || tile.func_145837_r() || !tile.hasCapability(capability, side.func_176734_d())) continue;
            capabilities.add(tile.getCapability(capability, side.func_176734_d()));
        }
        return capabilities;
    }

    @Override
    public String getName() {
        return "controller";
    }

    @Override
    public List<Slot> getSlots() {
        return null;
    }

    @Override
    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileController();
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.getItemHandlers() != null) {
            TileController te = (TileController)worldIn.func_175625_s(pos);
            playerIn.func_145747_a((ITextComponent)new TextComponentString(te.getItemHandlers().toString()));
        }
        return true;
    }

    @Override
    public Block getBlock() {
        return ModBlocks.CONTROLLER;
    }

    @Override
    public void addRecipe() {
    }
}

