/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.trials;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityHusk;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import xt9.deepmoblearning.common.trials.Trial;

public class ZombieTrial
extends Trial {
    public ZombieTrial(String mobKey, int[] mobsPerWave) {
        super(mobKey, mobsPerWave);
    }

    @Override
    public EntityLiving getTrialPrimaryEntity(World world) {
        EntityMob e = this.getRandomZombie(world);
        int rand = ThreadLocalRandom.current().nextInt(0, 3);
        for (int i = 0; i < rand; ++i) {
            this.setRandomArmorPiece(e);
        }
        if (!(e instanceof EntityHusk)) {
            this.setRandomHeadArmor(e);
            this.setRandomWeapon(e);
        }
        return e;
    }

    @Override
    public NonNullList<ItemStack> getTrialRewards(int tier) {
        NonNullList rewards = NonNullList.func_191196_a();
        ItemStack pristine = this.data.getPristineMatterStack(1);
        switch (tier) {
            case 0: {
                pristine.func_190920_e(2);
                break;
            }
            case 1: {
                pristine.func_190920_e(3);
                break;
            }
            case 2: {
                pristine.func_190920_e(5);
                break;
            }
            case 3: {
                pristine.func_190920_e(12);
                break;
            }
            case 4: {
                pristine.func_190920_e(18);
            }
        }
        rewards.add((Object)pristine);
        return rewards;
    }

    private EntityMob getRandomZombie(World world) {
        int rand = ThreadLocalRandom.current().nextInt(1, 100);
        if (rand < 25) {
            return new EntityZombieVillager(world);
        }
        if (rand < 55) {
            return new EntityHusk(world);
        }
        if (rand < 95) {
            return new EntityZombie(world);
        }
        EntityZombie e = new EntityZombie(world);
        e.func_82227_f(true);
        return e;
    }

    private void setRandomWeapon(EntityMob e) {
        int rand = ThreadLocalRandom.current().nextInt(1, 100);
        if (rand < 2) {
            e.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151056_x));
        } else if (rand < 12) {
            e.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151010_B));
        } else if (rand < 33) {
            e.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151049_t));
        } else if (rand < 67) {
            e.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(Items.field_151037_a));
        }
    }

    private void setRandomArmorPiece(EntityMob e) {
        int rand = ThreadLocalRandom.current().nextInt(0, 2);
        switch (rand) {
            case 0: {
                this.setRandomChestArmor(e);
                break;
            }
            case 1: {
                this.setRandomLegArmor(e);
                break;
            }
            case 2: {
                this.setRandomFeetArmor(e);
            }
        }
    }

    private void setRandomHeadArmor(EntityMob e) {
        int rand = ThreadLocalRandom.current().nextInt(1, 100);
        if (rand < 2) {
            e.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151161_ac));
        } else if (rand < 12) {
            e.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151028_Y));
        } else if (rand < 42) {
            e.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
        } else {
            e.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151024_Q));
        }
    }

    private void setRandomChestArmor(EntityMob e) {
        int rand = ThreadLocalRandom.current().nextInt(1, 100);
        if (rand < 1) {
            e.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151163_ad));
        } else if (rand < 10) {
            e.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151023_V));
        } else if (rand < 30) {
            e.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151027_R));
        }
    }

    private void setRandomLegArmor(EntityMob e) {
        int rand = ThreadLocalRandom.current().nextInt(1, 100);
        if (rand < 2) {
            e.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151173_ae));
        } else if (rand < 12) {
            e.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151165_aa));
        } else if (rand < 22) {
            e.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W));
        } else if (rand < 36) {
            e.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151026_S));
        }
    }

    private void setRandomFeetArmor(EntityMob e) {
        int rand = ThreadLocalRandom.current().nextInt(1, 100);
        if (rand < 3) {
            e.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151175_af));
        } else if (rand < 16) {
            e.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151151_aj));
        } else if (rand < 53) {
            e.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151021_T));
        }
    }
}

