/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.common.items;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.common.items.ItemGlitchIngot;
import xt9.deepmoblearning.common.mobmetas.MobMetaData;
import xt9.deepmoblearning.common.util.DataModel;

public class ItemGlitchArmor
extends ItemArmor {
    private static final int PRISTINE_SET_CHANCE = 18;
    private static final int PRISTINE_SET_NUMBER_OF_DROPS = 2;
    private static ItemArmor.ArmorMaterial material = EnumHelper.addArmorMaterial((String)"GLITCH_INFUSED_MATERIAL", (String)"deepmoblearning:glitch_infused", (int)120, (int[])new int[]{3, 8, 6, 3}, (int)15, null, (float)3.0f);

    public ItemGlitchArmor(String itemName, EntityEquipmentSlot slot) {
        super(material, 0, slot);
        this.func_77655_b("deepmoblearning." + itemName);
        this.func_77637_a(DeepMobLearning.creativeTab);
        this.setRegistryName(itemName);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.add("\u00a7rBonus while full set is equipped\u00a7r");
        list.add("\u00a7r(Bonuses are disabled during Trials)\u00a7r");
        list.add("\u00a76  1. 18% chance to drop 2 Pristine Matter\u00a7r");
        list.add("\u00a76     when a Data Model gains Data.\u00a7r");
        list.add("\u00a76  2. Flight & Immunity against fall damage\u00a7r");
    }

    public static boolean isSetEquippedByPlayer(EntityPlayer player) {
        return player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() instanceof ItemGlitchArmor && player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() instanceof ItemGlitchArmor && player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() instanceof ItemGlitchArmor && player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() instanceof ItemGlitchArmor;
    }

    public static void dropPristineMatter(World world, BlockPos position, ItemStack stack, EntityPlayer player) {
        if (ThreadLocalRandom.current().nextInt(1, 100) <= 18) {
            MobMetaData meta = DataModel.getMobMetaData(stack);
            EntityItem drop = new EntityItem(world, (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), meta.getPristineMatterStack(2));
            drop.func_174869_p();
            world.func_72838_d((Entity)drop);
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() instanceof ItemGlitchIngot;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public static class ItemGlitchBoots
    extends ItemGlitchArmor {
        public ItemGlitchBoots() {
            super("glitch_infused_boots", EntityEquipmentSlot.FEET);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class ItemGlitchLeggings
    extends ItemGlitchArmor {
        public ItemGlitchLeggings() {
            super("glitch_infused_leggings", EntityEquipmentSlot.LEGS);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class ItemGlitchChestplate
    extends ItemGlitchArmor {
        public ItemGlitchChestplate() {
            super("glitch_infused_chestplate", EntityEquipmentSlot.CHEST);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }

    public static class ItemGlitchHelmet
    extends ItemGlitchArmor {
        public ItemGlitchHelmet() {
            super("glitch_infused_helmet", EntityEquipmentSlot.HEAD);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
            super.func_77624_a(stack, worldIn, list, flagIn);
        }
    }
}

