/*
 * Decompiled with CFR 0.152.
 */
package xt9.deepmoblearning.client.gui;

import java.io.IOException;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import xt9.deepmoblearning.DeepMobLearning;
import xt9.deepmoblearning.client.gui.button.TransparentButton;
import xt9.deepmoblearning.common.Registry;
import xt9.deepmoblearning.common.inventory.ContainerTrialKeystone;
import xt9.deepmoblearning.common.network.TrialStartMessage;
import xt9.deepmoblearning.common.tiles.TileEntityTrialKeystone;
import xt9.deepmoblearning.common.trials.TrialFactory;
import xt9.deepmoblearning.common.trials.TrialRuleset;
import xt9.deepmoblearning.common.trials.affix.ITrialAffix;
import xt9.deepmoblearning.common.util.Tier;
import xt9.deepmoblearning.common.util.TrialKey;

public class TrialKeystoneGui
extends GuiContainer {
    private static final ResourceLocation base = new ResourceLocation("deepmoblearning", "textures/gui/trial_keystone_gui.png");
    private static final ResourceLocation base_blank = new ResourceLocation("deepmoblearning", "textures/gui/trial_keystone_gui_blank.png");
    private static final ResourceLocation defaultGui = new ResourceLocation("deepmoblearning", "textures/gui/default_gui.png");
    private TileEntityTrialKeystone tile;
    private static final int WIDTH = 200;
    private static final int HEIGHT = 178;
    private ItemStack trialKey;
    private GuiButton startButton;
    private HashMap<GuiButton, ItemStack> rewardButtons = new HashMap();

    public TrialKeystoneGui(TileEntityTrialKeystone tile, InventoryPlayer inventory, World world) {
        super((Container)new ContainerTrialKeystone(tile, inventory, world));
        this.tile = tile;
        this.field_146999_f = 200;
        this.field_147000_g = 178;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.trialKey = this.tile.getTrialKey();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.trialKey = this.tile.getTrialKey();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.startButton.func_146116_c(this.field_146297_k, mouseX, mouseY)) {
            this.func_146284_a(this.startButton);
        }
    }

    protected void func_146284_a(GuiButton pressedButton) {
        DeepMobLearning.network.sendToServer((IMessage)new TrialStartMessage());
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        this.startButton = new GuiButton(13, left + 114, top + 76, 82, 20, "Start trial");
        this.startButton.field_146124_l = false;
        this.startButton.field_146125_m = false;
        if (this.tile.hasTrialKey() && TrialKey.isAttuned(this.tile.getTrialKey()) && !this.tile.isTrialActive() && this.tile.areaIsClear()) {
            this.startButton.field_146125_m = true;
            this.startButton.field_146124_l = true;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawStartButton(mouseX, mouseY);
        this.func_191948_b(mouseX, mouseY);
        this.drawButtonHoverText(mouseX, mouseY);
    }

    private void drawButtonHoverText(int mouseX, int mouseY) {
        this.rewardButtons.forEach((btn, stack) -> {
            if (btn.func_146115_a()) {
                this.func_146285_a((ItemStack)stack, mouseX, mouseY);
            }
        });
    }

    private void drawStartButton(int mouseX, int mouseY) {
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.startButton.func_191745_a(this.field_146297_k, mouseX, mouseY, 0.0f);
        this.rewardButtons.forEach((button, stack) -> button.func_191745_a(this.field_146297_k, mouseX, mouseY, 0.0f));
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        RenderHelper.func_74519_b();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(base_blank);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(left, top, 0, 0, 200, 100);
        this.func_73729_b(left - 20, top, 0, 100, 18, 18);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(defaultGui);
        this.func_73729_b(left + 12, top + 106, 0, 0, 176, 90);
        if (this.tile.isTrialActive()) {
            this.func_73732_a(this.field_146289_q, "Trial is currently active", left + 100, top + 34, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "\u00a76Rewards\u00a7r will drop upon completion.", left + 100, top + 46, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "Current wave: (" + (this.tile.getCurrentWave() + 1) + "/" + this.tile.getLastWave() + ")", left + 100, top + 58, 0xFFFFFF);
            return;
        }
        if (!this.tile.areaIsClear()) {
            this.func_73732_a(this.field_146289_q, "Something is blocking the \u00a7bTrial Area\u00a7r", left + 100, top + 22, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "Make sure a 15x15x10 area is clear", left + 100, top + 34, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "and the layer beneath the", left + 100, top + 46, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, " \u00a7bTrial Keystone\u00a7r is made up", left + 100, top + 58, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "of full blocks (also 15x15)", left + 100, top + 70, 0xFFFFFF);
            return;
        }
        if (!this.tile.hasTrialKey()) {
            this.func_73732_a(this.field_146289_q, "Please insert a attuned Trial Key", left + 100, top + 42, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "to start a trial", left + 100, top + 54, 0xFFFFFF);
            return;
        }
        if (this.tile.hasTrialKey() && !TrialKey.isAttuned(this.tile.getTrialKey())) {
            this.func_73732_a(this.field_146289_q, "Current key is not attuned", left + 100, top + 34, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "learn more about attunement in the", left + 100, top + 46, 0xFFFFFF);
            this.func_73732_a(this.field_146289_q, "guide entry for the " + new ItemStack((Item)Registry.trialKey).func_82833_r(), left + 100, top + 58, 0xFFFFFF);
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(base);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(left, top, 0, 0, 200, 100);
        if (this.tile.hasTrialKey() && TrialKey.isAttuned(this.tile.getTrialKey()) && !this.tile.isTrialActive()) {
            this.drawKeyInfo(left, top);
        }
    }

    private void drawKeyInfo(int x, int y) {
        NonNullList<ITrialAffix> affixes = TrialKey.getAffixes(this.trialKey, this.tile.func_174877_v(), this.tile.func_145831_w());
        this.func_73731_b(this.field_146289_q, "Trial type", x + 6, y + 6, 6478079);
        this.func_73731_b(this.field_146289_q, TrialKey.getMobMetaData(this.trialKey).getName(), x + 6, y + 18, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Tier:", x + 115, y + 6, 6478079);
        this.func_73731_b(this.field_146289_q, Tier.getTierName(TrialKey.getTier(this.trialKey), false) + "", x + 140, y + 6, 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, "Waves:", x + 115, y + 18, 6478079);
        this.func_73731_b(this.field_146289_q, TrialRuleset.getMaxWaveFromTier(TrialKey.getTier(this.trialKey)) + "", x + 150, y + 18, 0xFFFFFF);
        int i = 0;
        this.rewardButtons.clear();
        this.func_73731_b(this.field_146289_q, "Rewards", x + 115, y + 38, 6478079);
        for (ItemStack itemStack : TrialFactory.getRewards(this.trialKey)) {
            TransparentButton btn = new TransparentButton(i, x + 115 + 18 * i, y + 48, 18, 18);
            this.rewardButtons.put(btn, itemStack);
            this.drawItemStackWithCount(x + 118 + 18 * i, y + 48, itemStack);
            ++i;
        }
        if (affixes.size() > 0) {
            this.func_73731_b(this.field_146289_q, "Affixes", x + 6, y + 38, 6478079);
            i = 0;
            for (ITrialAffix affix : affixes) {
                this.func_73731_b(this.field_146289_q, affix.getAffixNameWithFormatting(), x + 6, y + 50 + 12 * i, 0xFFFFFF);
                ++i;
            }
        }
    }

    private void drawItemStackWithCount(int x, int y, ItemStack stack) {
        RenderHelper.func_74520_c();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        this.field_146296_j.field_77023_b = 200.0f;
        this.field_146296_j.func_180450_b(stack, x, y);
        this.field_146296_j.func_180453_a(this.field_146289_q, stack, x - 1, y - 1, stack.func_190916_E() != 1 ? stack.func_190916_E() + "" : "");
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }
}

