/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.power;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.util.NullHelper;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector4f;
import crazypants.enderio.base.conduit.ConduitUtil;
import crazypants.enderio.base.conduit.ConnectionMode;
import crazypants.enderio.base.conduit.IClientConduit;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.IConduitBundle;
import crazypants.enderio.base.conduit.IConduitNetwork;
import crazypants.enderio.base.conduit.IConduitTexture;
import crazypants.enderio.base.conduit.IGuiExternalConnection;
import crazypants.enderio.base.conduit.RaytraceResult;
import crazypants.enderio.base.conduit.geom.CollidableCache;
import crazypants.enderio.base.conduit.geom.CollidableComponent;
import crazypants.enderio.base.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.base.lang.LangPower;
import crazypants.enderio.base.machine.modes.RedstoneControlMode;
import crazypants.enderio.base.power.IPowerInterface;
import crazypants.enderio.base.power.PowerHandlerUtil;
import crazypants.enderio.base.render.registry.TextureRegistry;
import crazypants.enderio.base.tool.ToolUtil;
import crazypants.enderio.conduits.conduit.AbstractConduit;
import crazypants.enderio.conduits.conduit.power.IPowerConduit;
import crazypants.enderio.conduits.conduit.power.IPowerConduitData;
import crazypants.enderio.conduits.conduit.power.NetworkPowerManager;
import crazypants.enderio.conduits.conduit.power.PowerConduitNetwork;
import crazypants.enderio.conduits.conduit.power.PowerTracker;
import crazypants.enderio.conduits.config.ConduitConfig;
import crazypants.enderio.conduits.gui.PowerSettings;
import crazypants.enderio.conduits.render.BlockStateWrapperConduitBundle;
import crazypants.enderio.conduits.render.ConduitTexture;
import crazypants.enderio.powertools.lang.Lang;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PowerConduit
extends AbstractConduit
implements IPowerConduit {
    static final Map<String, IConduitTexture> ICONS = new HashMap<String, IConduitTexture>();
    static final String[] POSTFIX = new String[]{"", "_enhanced", "_ender"};
    public static final float WIDTH = 0.075f;
    public static final float HEIGHT = 0.075f;
    @Nonnull
    public static final Vector3d MIN;
    @Nonnull
    public static final Vector3d MAX;
    @Nonnull
    public static final BoundingBox BOUNDS;
    protected PowerConduitNetwork network;
    private int energyStoredRF;
    @Nonnull
    private IPowerConduitData subtype = IPowerConduitData.Registry.fromID(0);
    protected final EnumMap<EnumFacing, RedstoneControlMode> rsModes = new EnumMap(EnumFacing.class);
    protected final EnumMap<EnumFacing, DyeColor> rsColors = new EnumMap(EnumFacing.class);
    protected EnumMap<EnumFacing, Long> recievedTicks;

    public PowerConduit() {
    }

    public PowerConduit(@Nonnull IPowerConduitData subtype) {
        this.subtype = subtype;
    }

    @Override
    public boolean getConnectionsDirty() {
        return this.connectionsDirty;
    }

    @Override
    @Nonnull
    public String getConduitProbeInfo(@Nonnull EntityPlayer player) {
        PowerConduitNetwork pcn = (PowerConduitNetwork)this.getNetwork();
        if (pcn == null) {
            return super.getConduitProbeInfo(player);
        }
        NetworkPowerManager pm = pcn.getPowerManager();
        PowerTracker tracker = pm.getTracker(this);
        if (tracker != null) {
            String color = "\u00a7a ";
            StringBuilder sb = new StringBuilder(super.getConduitProbeInfo(player));
            sb.append(color);
            sb.append(Lang.GUI_ENERGY_CONDUIT.get());
            color = "\u00a79 ";
            sb.append(color);
            sb.append(Lang.GUI_CONDUIT_PROBE_CONDUIT_BUFFER.get());
            sb.append(" ");
            sb.append(LangPower.RF(this.getEnergyStored()));
            sb.append(" ");
            sb.append(Lang.GUI_POWER_MONITOR_OF.get());
            sb.append(" ");
            sb.append(LangPower.RF(this.getMaxEnergyStored()));
            sb.append("\n");
            sb.append(Lang.GUI_POWER_MONITOR_AVERAGE_OUTPUT.get());
            sb.append(" ");
            sb.append(LangPower.RF(tracker.getAverageRfTickSent()));
            sb.append("\n");
            sb.append(Lang.GUI_POWER_MONITOR_AVERAGE_INPUT.get());
            sb.append(" ");
            sb.append(LangPower.RF(tracker.getAverageRfTickRecieved()));
            return sb.toString();
        }
        tracker = pm.getNetworkPowerTracker();
        String color = "\u00a7a ";
        StringBuilder sb = new StringBuilder(super.getConduitProbeInfo(player));
        sb.append(color);
        sb.append(Lang.GUI_CONDUIT_PROBE_NETWORK_HEADING.get());
        sb.append("\n");
        color = "\u00a79 ";
        sb.append(color);
        sb.append(Lang.GUI_POWER_MONITOR_CONDUIT_STORAGE.get());
        sb.append(" ");
        sb.append(LangPower.RF(pm.getPowerInConduits()));
        sb.append(" ");
        sb.append(Lang.GUI_POWER_MONITOR_OF.get());
        sb.append(" ");
        sb.append(LangPower.RF(pm.getMaxPowerInConduits()));
        sb.append("\n");
        sb.append(Lang.GUI_POWER_MONITOR_CAPBANK_STORAGE.get());
        sb.append(" ");
        sb.append(LangPower.RF(pm.getPowerInCapacitorBanks()));
        sb.append(" ");
        sb.append(Lang.GUI_POWER_MONITOR_OF.get());
        sb.append(" ");
        sb.append(LangPower.RF(pm.getMaxPowerInCapacitorBanks()));
        sb.append("\n");
        sb.append(Lang.GUI_POWER_MONITOR_MACHINE_BUFFER.get());
        sb.append(" ");
        sb.append(LangPower.RF(pm.getPowerInReceptors()));
        sb.append(" ");
        sb.append(Lang.GUI_POWER_MONITOR_OF.get());
        sb.append(" ");
        sb.append(LangPower.RF(pm.getMaxPowerInReceptors()));
        sb.append("\n");
        sb.append(Lang.GUI_POWER_MONITOR_AVERAGE_OUTPUT.get());
        sb.append(" ");
        sb.append(LangPower.RF(tracker.getAverageRfTickSent()));
        sb.append("\n");
        sb.append(Lang.GUI_POWER_MONITOR_AVERAGE_INPUT.get());
        sb.append(" ");
        sb.append(LangPower.RF(tracker.getAverageRfTickRecieved()));
        return sb.toString();
    }

    @Override
    public boolean onBlockActivated(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull RaytraceResult res, @Nonnull List<RaytraceResult> all) {
        if (ConduitUtil.isProbeEquipped(player, hand)) {
            return false;
        }
        CollidableComponent component = res.component;
        DyeColor col = DyeColor.getColorFromDye((ItemStack)player.func_184614_ca());
        if (col != null && component != null && component.isDirectional() && this.isColorBandRendered(component.getDirection())) {
            this.setExtractionSignalColor(component.getDirection(), col);
            return true;
        }
        if (ToolUtil.isToolEquipped(player, hand)) {
            if (!this.getBundle().getEntity().func_145831_w().field_72995_K && component != null) {
                EnumFacing faceHit = res.movingObjectPosition.field_178784_b;
                if (component.isCore()) {
                    if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                        this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                        return true;
                    }
                    return ConduitUtil.connectConduits(this, faceHit);
                }
                EnumFacing connDir = component.getDirection();
                if (this.externalConnections.contains(connDir)) {
                    this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                } else if (this.containsConduitConnection(connDir)) {
                    ConduitUtil.disconnectConduits(this, connDir);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isColorBandRendered(@Nonnull EnumFacing dir) {
        return this.getConnectionMode(dir) != ConnectionMode.DISABLED && this.getExtractionRedstoneMode(dir) != RedstoneControlMode.IGNORE;
    }

    @Override
    public void setExtractionRedstoneMode(@Nonnull RedstoneControlMode mode, @Nonnull EnumFacing dir) {
        this.rsModes.put(dir, mode);
        this.setClientStateDirty();
    }

    @Override
    @Nonnull
    public RedstoneControlMode getExtractionRedstoneMode(@Nonnull EnumFacing dir) {
        RedstoneControlMode res = this.rsModes.get(dir);
        if (res == null) {
            res = RedstoneControlMode.IGNORE;
        }
        return res;
    }

    @Override
    public void setExtractionSignalColor(@Nonnull EnumFacing dir, @Nonnull DyeColor col) {
        this.rsColors.put(dir, col);
        this.setClientStateDirty();
    }

    @Override
    @Nonnull
    public DyeColor getExtractionSignalColor(@Nonnull EnumFacing dir) {
        DyeColor res = this.rsColors.get(dir);
        if (res == null) {
            res = DyeColor.RED;
        }
        return res;
    }

    @Override
    protected void readTypeSettings(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        this.setConnectionMode(dir, (ConnectionMode)((Object)NullHelper.first((Object[])new ConnectionMode[]{ConnectionMode.values()[dataRoot.func_74765_d("connectionMode")], ConnectionMode.NOT_SET})));
        this.setExtractionSignalColor(dir, (DyeColor)NullHelper.first((Object[])new DyeColor[]{DyeColor.values()[dataRoot.func_74765_d("extractionSignalColor")], DyeColor.RED}));
        this.setExtractionRedstoneMode(RedstoneControlMode.fromOrdinal(dataRoot.func_74765_d("extractionRedstoneMode")), dir);
    }

    @Override
    protected void writeTypeSettingsToNbt(@Nonnull EnumFacing dir, @Nonnull NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("connectionMode", (short)this.getConnectionMode(dir).ordinal());
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
    }

    @Override
    public void writeToNBT(@Nonnull NBTTagCompound nbtRoot) {
        short ord;
        super.writeToNBT(nbtRoot);
        nbtRoot.func_74777_a("subtype", (short)this.subtype.getID());
        nbtRoot.func_74768_a("energyStoredRF", this.energyStoredRF);
        for (Map.Entry<EnumFacing, RedstoneControlMode> entry : this.rsModes.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)entry.getValue().ordinal();
            nbtRoot.func_74777_a("pRsMode." + entry.getKey().name(), ord);
        }
        for (Map.Entry<EnumFacing, RedstoneControlMode> entry : this.rsColors.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("pRsCol." + entry.getKey().name(), ord);
        }
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound nbtRoot) {
        super.readFromNBT(nbtRoot);
        this.subtype = IPowerConduitData.Registry.fromID(nbtRoot.func_74765_d("subtype"));
        if (nbtRoot.func_74764_b("energyStored")) {
            nbtRoot.func_74768_a("energyStoredRF", (int)(nbtRoot.func_74760_g("energyStored") * 10.0f));
        }
        this.setEnergyStored(nbtRoot.func_74762_e("energyStoredRF"));
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            short ord;
            String key = "pRsMode." + dir.name();
            if (nbtRoot.func_74764_b(key) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < RedstoneControlMode.values().length) {
                this.rsModes.put(dir, RedstoneControlMode.values()[ord]);
            }
            if (!nbtRoot.func_74764_b(key = "pRsCol." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.rsColors.put(dir, DyeColor.values()[ord]);
        }
    }

    @Override
    public void onTick() {
    }

    public static int getMaxEnergyIO(IPowerConduitData subtype) {
        return subtype.getMaxEnergyIO();
    }

    public int getMaxEnergyStored() {
        return PowerConduit.getMaxEnergyIO(this.subtype);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (PowerConduit.getMaxEnergyIO(this.subtype) == 0 || maxReceive <= 0) {
            return 0;
        }
        int freeSpace = this.getMaxEnergyStored() - this.getEnergyStored();
        int result = Math.min(maxReceive, freeSpace);
        if (!simulate && result > 0) {
            this.setEnergyStored(this.getEnergyStored() + result);
        }
        return result;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public int getEnergyStored() {
        return this.energyStoredRF;
    }

    @Override
    public void setEnergyStored(int energyStored) {
        this.energyStoredRF = MathHelper.func_76125_a((int)energyStored, (int)0, (int)this.getMaxEnergyStored());
    }

    @Nullable
    private IEnergyStorage getEnergyDir(EnumFacing dir) {
        if (dir != null) {
            return new ConnectionSide(dir);
        }
        return null;
    }

    private boolean isRedstoneEnabled(@Nonnull EnumFacing dir) {
        RedstoneControlMode mode = this.getExtractionRedstoneMode(dir);
        return ConduitUtil.isRedstoneControlModeMet(this, mode, this.getExtractionSignalColor(dir));
    }

    @Override
    public int getMaxEnergyRecieved(@Nonnull EnumFacing dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        if (mode == ConnectionMode.OUTPUT || mode == ConnectionMode.DISABLED || !this.isRedstoneEnabled(dir)) {
            return 0;
        }
        return PowerConduit.getMaxEnergyIO(this.subtype);
    }

    @Override
    public int getMaxEnergyExtracted(@Nonnull EnumFacing dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        if (mode == ConnectionMode.INPUT || mode == ConnectionMode.DISABLED || !this.isRedstoneEnabled(dir)) {
            return 0;
        }
        return PowerConduit.getMaxEnergyIO(this.subtype);
    }

    @Override
    public boolean onNeighborBlockChange(@Nonnull Block blockId) {
        if (this.network != null && this.network.powerManager != null) {
            this.network.powerManager.receptorsChanged();
        }
        return super.onNeighborBlockChange(blockId);
    }

    @Override
    public void setConnectionMode(@Nonnull EnumFacing dir, @Nonnull ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.recievedTicks = null;
    }

    @Override
    @Nullable
    public IConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(@Nonnull IConduitNetwork<?, ?> network) {
        this.network = (PowerConduitNetwork)network;
        return super.setNetwork(network);
    }

    @Override
    public void clearNetwork() {
        this.network = null;
    }

    @Override
    public boolean canConnectToExternal(@Nonnull EnumFacing direction, boolean ignoreDisabled) {
        IPowerInterface rec = this.getExternalPowerReceptor(direction);
        return rec != null;
    }

    @Override
    public boolean canConnectToConduit(@Nonnull EnumFacing direction, @Nonnull IConduit conduit) {
        boolean res = super.canConnectToConduit(direction, conduit);
        if (!res) {
            return false;
        }
        if (((Boolean)ConduitConfig.canDifferentTiersConnect.get()).booleanValue()) {
            return res;
        }
        if (!(conduit instanceof IPowerConduit)) {
            return false;
        }
        IPowerConduit pc = (IPowerConduit)conduit;
        return pc.getMaxEnergyStored() == this.getMaxEnergyStored();
    }

    @Override
    public void externalConnectionAdded(@Nonnull EnumFacing direction) {
        super.externalConnectionAdded(direction);
        if (this.network != null) {
            TileEntity te = this.getBundle().getEntity();
            BlockPos p = te.func_174877_v().func_177972_a(direction);
            this.network.powerReceptorAdded(this, direction, p);
        }
    }

    @Override
    public void externalConnectionRemoved(@Nonnull EnumFacing direction) {
        super.externalConnectionRemoved(direction);
        if (this.network != null) {
            TileEntity te = this.getBundle().getEntity();
            BlockPos p = te.func_174877_v().func_177972_a(direction);
            this.network.powerReceptorRemoved(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
        }
    }

    @Override
    public IPowerInterface getExternalPowerReceptor(@Nonnull EnumFacing direction) {
        TileEntity te = this.getBundle().getEntity();
        World world = te.func_145831_w();
        TileEntity test = world.func_175625_s(te.func_174877_v().func_177972_a(direction));
        if (test == null) {
            return null;
        }
        if (test instanceof IConduitBundle) {
            return null;
        }
        return PowerHandlerUtil.getPowerInterface((ICapabilityProvider)test, direction.func_176734_d());
    }

    @Override
    @Nonnull
    public ItemStack createItem() {
        return this.subtype.createItemStackForSubtype();
    }

    @Override
    @Nonnull
    public Class<? extends IConduit> getBaseConduitType() {
        return IPowerConduit.class;
    }

    @Override
    @Nonnull
    public IConduitTexture getTextureForState(@Nonnull CollidableComponent component) {
        return this.subtype.getTextureForState(component);
    }

    @Override
    @Nullable
    public IConduitTexture getTransmitionTextureForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nullable
    public Vector4f getTransmitionTextureColorForState(@Nonnull CollidableComponent component) {
        return null;
    }

    @Override
    @Nonnull
    public Collection<CollidableComponent> createCollidables(@Nonnull CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        EnumFacing key_dir = key.dir;
        if (key_dir == null) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.getInstance().createBoundsForConnectionController(key_dir, key.offset);
        CollidableComponent cc = new CollidableComponent(IPowerConduit.class, bb, key_dir, "ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        result.add(cc);
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void hashCodeForModelCaching(BlockStateWrapperConduitBundle.ConduitCacheKey hashCodes) {
        super.hashCodeForModelCaching(hashCodes);
        if (this.subtype.getID() != 1) {
            hashCodes.add(this.subtype.getID());
        }
        hashCodes.addEnum(this.rsModes);
        hashCodes.addEnum(this.rsColors);
    }

    @Nonnull
    public PowerConduitNetwork createNetworkForType() {
        return new PowerConduitNetwork();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ITabPanel createGuiPanel(@Nonnull IGuiExternalConnection gui, @Nonnull IClientConduit con) {
        return new PowerSettings(gui, con);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean updateGuiPanel(@Nonnull ITabPanel panel) {
        if (panel instanceof PowerSettings) {
            return ((PowerSettings)panel).updateConduit(this);
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getGuiPanelTabOrder() {
        return 3;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.getExternalConnections().contains(facing);
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.getEnergyDir(facing);
        }
        return null;
    }

    @Override
    public void setConnectionsDirty() {
        this.connectionsDirty = true;
    }

    static {
        int i = 0;
        for (String pf : POSTFIX) {
            ICONS.put("blocks/power_conduit" + pf, new ConduitTexture(TextureRegistry.registerTexture("blocks/power_conduit"), ConduitTexture.arm(i)));
            ICONS.put("blocks/power_conduit_core" + pf, new ConduitTexture(TextureRegistry.registerTexture("blocks/conduit_core_0"), ConduitTexture.core(i++)));
        }
        MIN = new Vector3d((double)0.425f, 0.42499999701976776, 0.42499999701976776);
        MAX = new Vector3d(PowerConduit.MIN.x + (double)0.075f, PowerConduit.MIN.y + (double)0.075f, PowerConduit.MIN.z + (double)0.075f);
        BOUNDS = new BoundingBox(MIN, MAX);
    }

    public class ConnectionSide
    implements IEnergyStorage {
        @Nonnull
        private final EnumFacing side;

        public ConnectionSide(EnumFacing side) {
            this.side = side;
        }

        private boolean recievedRfThisTick() {
            long recT;
            if (PowerConduit.this.recievedTicks == null || PowerConduit.this.recievedTicks.get(this.side) == null || PowerConduit.this.bundle == null) {
                return false;
            }
            long curTick = PowerConduit.this.getBundle().getBundleworld().func_82737_E();
            return curTick - (recT = PowerConduit.this.recievedTicks.get(this.side).longValue()) <= 5L;
        }

        private boolean isEnabled() {
            return PowerConduit.this.getConnectionMode(this.side) != ConnectionMode.DISABLED && !PowerConduit.this.isRedstoneEnabled(this.side);
        }

        private boolean isExtract() {
            switch (PowerConduit.this.getConnectionMode(this.side)) {
                case OUTPUT: 
                case IN_OUT: {
                    return PowerConduit.this.isRedstoneEnabled(this.side);
                }
            }
            return false;
        }

        private boolean isReceive() {
            switch (PowerConduit.this.getConnectionMode(this.side)) {
                case IN_OUT: 
                case INPUT: {
                    return PowerConduit.this.isRedstoneEnabled(this.side);
                }
            }
            return false;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.isReceive()) {
                int energyFinal = PowerConduit.this.receiveEnergy(maxReceive, simulate);
                if (PowerConduit.this.bundle != null) {
                    if (PowerConduit.this.recievedTicks == null) {
                        PowerConduit.this.recievedTicks = new EnumMap(EnumFacing.class);
                    }
                    PowerConduit.this.recievedTicks.put(this.side, PowerConduit.this.getBundle().getBundleworld().func_82737_E());
                }
                return energyFinal;
            }
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.isExtract()) {
                return PowerConduit.this.extractEnergy(maxExtract, simulate);
            }
            return 0;
        }

        public int getEnergyStored() {
            if (this.isEnabled()) {
                return PowerConduit.this.getEnergyStored();
            }
            return 0;
        }

        public int getMaxEnergyStored() {
            if (this.isEnabled()) {
                return PowerConduit.this.getMaxEnergyStored();
            }
            return 0;
        }

        public boolean canExtract() {
            return this.isExtract() && PowerConduit.this.canExtract() && !this.recievedRfThisTick();
        }

        public boolean canReceive() {
            return this.isReceive() && PowerConduit.this.canReceive();
        }
    }
}

