/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.machine.gui;

import com.enderio.core.api.common.util.IProgressTile;
import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.util.Util;
import crazypants.enderio.base.gui.IconEIO;
import crazypants.enderio.base.machine.baselegacy.AbstractInventoryMachineEntity;
import crazypants.enderio.base.machine.baselegacy.SlotDefinition;
import crazypants.enderio.util.Prep;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMachineContainer<E extends AbstractInventoryMachineEntity>
extends ContainerEnder<AbstractInventoryMachineEntity.InventoryWrapper> {
    protected Slot upgradeSlot;
    @Nonnull
    protected final E te;
    private boolean hasAlreadyJustSuccessfullyTransferedAStack = false;
    private int guiID = -1;

    public AbstractMachineContainer(@Nonnull InventoryPlayer playerInv, @Nonnull E te) {
        super(playerInv, (IInventory)((AbstractInventoryMachineEntity)te).getAsInventory());
        this.te = te;
    }

    @Nonnull
    public E getTe() {
        return this.te;
    }

    protected void addSlots(@Nonnull InventoryPlayer playerInv) {
        this.addMachineSlots(playerInv);
        if (((AbstractInventoryMachineEntity.InventoryWrapper)this.getInv()).getOwner().getSlotDefinition().getNumUpgradeSlots() == 1) {
            this.upgradeSlot = new Slot(this.getInv(), ((AbstractInventoryMachineEntity.InventoryWrapper)this.getInv()).getOwner().getSlotDefinition().getMinUpgradeSlot(), this.getUpgradeOffset().x, this.getUpgradeOffset().y){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                    return ((AbstractInventoryMachineEntity)AbstractMachineContainer.this.te).isItemValidForSlot(((AbstractInventoryMachineEntity)AbstractMachineContainer.this.te).getSlotDefinition().getMinUpgradeSlot(), itemStack);
                }

                @SideOnly(value=Side.CLIENT)
                @Nonnull
                public ResourceLocation getBackgroundLocation() {
                    return IconEIO.CAPACITOR.getMap().getTexture();
                }

                @SideOnly(value=Side.CLIENT)
                @Nonnull
                public TextureAtlasSprite getBackgroundSprite() {
                    return IconEIO.CAPACITOR.getAsTextureAtlasSprite();
                }
            };
            this.func_75146_a(this.upgradeSlot);
        }
    }

    @Nonnull
    public Point getPlayerInventoryOffset() {
        return new Point(8, 84);
    }

    @Nonnull
    public Point getUpgradeOffset() {
        return new Point(12, 60);
    }

    public Slot getUpgradeSlot() {
        return this.upgradeSlot;
    }

    protected abstract void addMachineSlots(@Nonnull InventoryPlayer var1);

    @Nonnull
    public ItemStack func_82846_b(@Nonnull EntityPlayer entityPlayer, int slotNumber) {
        ItemStack origStack;
        this.hasAlreadyJustSuccessfullyTransferedAStack = false;
        SlotDefinition slotDef = ((AbstractInventoryMachineEntity)this.te).getSlotDefinition();
        ItemStack copystack = Prep.getEmpty();
        Slot slot = (Slot)this.field_75151_b.get(slotNumber);
        if (slot != null && slot.func_75216_d() && Prep.isValid(origStack = slot.func_75211_c())) {
            copystack = origStack.func_77946_l();
            boolean merged = false;
            for (SlotRange range : this.getTargetSlotsForTransfer(slotNumber, slot)) {
                if (!this.func_75135_a(origStack, range.getStart(), range.getEnd(), range.reverse)) continue;
                while (this.func_75135_a(origStack, range.getStart(), range.getEnd(), range.reverse)) {
                }
                merged = true;
                break;
            }
            if (!merged) {
                return Prep.getEmpty();
            }
            if (slotDef.isOutputSlot(slot.getSlotIndex())) {
                slot.func_75220_a(origStack, copystack);
            }
            if (Prep.isInvalid(origStack)) {
                slot.func_75215_d(Prep.getEmpty());
            } else {
                slot.func_75218_e();
            }
            if (origStack.func_190916_E() == copystack.func_190916_E()) {
                return Prep.getEmpty();
            }
            slot.func_190901_a(entityPlayer, origStack);
        }
        this.hasAlreadyJustSuccessfullyTransferedAStack = true;
        return copystack;
    }

    protected int getIndexOfFirstPlayerInvSlot(@Nonnull SlotDefinition slotDef) {
        return slotDef.getNumSlots();
    }

    protected SlotRange getPlayerInventorySlotRange(boolean reverse) {
        return new SlotRange(this.startPlayerSlot, this.endHotBarSlot, reverse);
    }

    protected SlotRange getPlayerInventoryWithoutHotbarSlotRange() {
        return new SlotRange(this.startPlayerSlot, this.endPlayerSlot, false);
    }

    protected SlotRange getPlayerHotbarSlotRange() {
        return new SlotRange(this.startHotBarSlot, this.endHotBarSlot, false);
    }

    protected void addInventorySlotRange(@Nonnull List<SlotRange> res, int start, int end) {
        SlotRange range = null;
        for (int i = start; i < end; ++i) {
            Slot slotFromInventory = this.func_75147_a(this.getInv(), i);
            int slotNumber = slotFromInventory.field_75222_d;
            if (range == null) {
                range = new SlotRange(slotNumber, slotNumber + 1, false);
                continue;
            }
            if (range.getEnd() == slotNumber) {
                range = new SlotRange(range.getStart(), slotNumber + 1, false);
                continue;
            }
            res.add(range);
            range = new SlotRange(slotNumber, slotNumber + 1, false);
        }
        if (range != null) {
            res.add(range);
        }
    }

    protected void addInputSlotRanges(@Nonnull List<SlotRange> res) {
        SlotDefinition slotDef = ((AbstractInventoryMachineEntity)this.te).getSlotDefinition();
        if (slotDef.getNumInputSlots() > 0) {
            this.addInventorySlotRange(res, slotDef.getMinInputSlot(), slotDef.getMaxInputSlot() + 1);
        }
    }

    protected void addUpgradeSlotRanges(@Nonnull List<SlotRange> res) {
        SlotDefinition slotDef = ((AbstractInventoryMachineEntity)this.te).getSlotDefinition();
        if (slotDef.getNumUpgradeSlots() > 0) {
            this.addInventorySlotRange(res, slotDef.getMinUpgradeSlot(), slotDef.getMaxUpgradeSlot() + 1);
        }
    }

    protected void addPlayerSlotRanges(@Nonnull List<SlotRange> res, int slotIndex) {
        if (slotIndex < this.endPlayerSlot) {
            res.add(this.getPlayerHotbarSlotRange());
        }
        if (slotIndex >= this.startHotBarSlot && slotIndex < this.endHotBarSlot) {
            res.add(this.getPlayerInventoryWithoutHotbarSlotRange());
        }
    }

    @Nonnull
    protected List<SlotRange> getTargetSlotsForTransfer(int slotNumber, @Nonnull Slot slot) {
        if (slot.field_75224_c == this.getInv()) {
            SlotDefinition slotDef = ((AbstractInventoryMachineEntity)this.te).getSlotDefinition();
            if (slotDef.isInputSlot(slot.getSlotIndex()) || slotDef.isUpgradeSlot(slot.getSlotIndex())) {
                return Collections.singletonList(this.getPlayerInventorySlotRange(false));
            }
            if (slotDef.isOutputSlot(slot.getSlotIndex())) {
                return Collections.singletonList(this.getPlayerInventorySlotRange(true));
            }
        } else if (slotNumber >= this.startPlayerSlot) {
            ArrayList<SlotRange> res = new ArrayList<SlotRange>();
            this.addUpgradeSlotRanges(res);
            this.addInputSlotRanges(res);
            this.addPlayerSlotRanges(res, slotNumber);
            return res;
        }
        return Collections.emptyList();
    }

    protected int getProgressScaled(int scale) {
        if (this.te instanceof IProgressTile) {
            Util.getProgressScaled((int)scale, (IProgressTile)((IProgressTile)this.te));
        }
        return 0;
    }

    public void setGuiID(int id) {
        this.guiID = id;
    }

    public int getGuiID() {
        return this.guiID;
    }

    public void func_75142_b() {
        super.func_75142_b();
        SPacketUpdateTileEntity updatePacket = this.te.func_189518_D_();
        if (updatePacket != null) {
            for (IContainerListener containerListener : this.field_75149_d) {
                if (!(containerListener instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)containerListener).field_71135_a.func_147359_a((Packet)updatePacket);
            }
        }
    }

    public static class SlotRange {
        private final int start;
        private final int end;
        final boolean reverse;

        public SlotRange(int start, int end, boolean reverse) {
            this.start = start;
            this.end = end;
            this.reverse = reverse;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

