/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.AbstractCrafting;
import crazypants.enderio.base.config.recipes.xml.ItemConsumable;
import crazypants.enderio.base.config.recipes.xml.ItemFloatAmount;
import crazypants.enderio.base.integration.tic.TicProxy;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;

public class Casting
extends AbstractCrafting {
    private ItemFloatAmount input;
    private ItemConsumable cast;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        try {
            super.readResolve();
            if (this.input == null) {
                throw new InvalidRecipeConfigException("Missing <input>");
            }
            this.valid = this.valid && this.input.isValid() && (this.cast == null || this.cast.isValid());
        }
        catch (InvalidRecipeConfigException e) {
            throw new InvalidRecipeConfigException(e, "in <casting>");
        }
        return this;
    }

    @Override
    public void enforceValidity() throws InvalidRecipeConfigException {
        super.enforceValidity();
        this.input.enforceValidity();
    }

    @Override
    public boolean isActive() {
        return super.isActive();
    }

    @Override
    public void register(@Nonnull String recipeName) {
        if (this.isValid() && this.isActive()) {
            if (TicProxy.isLoaded()) {
                TicProxy.registerTableCast(this.getOutput().getThing(), this.cast.getThing(), this.input.getThing(), this.input.amount, this.cast.getConsumed());
            } else {
                Log.warn("TiC recipe is active, but TiC integration is not loaded");
            }
        }
    }

    @Override
    public boolean setElement(StaxFactory factory, String name, StartElement startElement) throws InvalidRecipeConfigException, XMLStreamException {
        if ("input".equals(name) && this.input == null) {
            this.input = (ItemFloatAmount)factory.read(new ItemFloatAmount().setAllowDelaying(true), startElement);
            return true;
        }
        if ("cast".equals(name) && this.cast == null) {
            this.cast = (ItemConsumable)factory.read(new ItemConsumable().setAllowDelaying(true), startElement);
            return true;
        }
        return super.setElement(factory, name, startElement);
    }
}

