/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.capacitor;

import com.enderio.core.client.handlers.SpecialTooltipHandler;
import com.enderio.core.common.CompoundCapabilityProvider;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.IModObject;
import crazypants.enderio.api.capacitor.CapabilityCapacitorData;
import crazypants.enderio.api.capacitor.ICapacitorData;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.EnderIOTab;
import crazypants.enderio.base.capacitor.DefaultCapacitorData;
import crazypants.enderio.base.lang.Lang;
import crazypants.enderio.base.render.IHaveRenderers;
import crazypants.enderio.util.NbtValue;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCapacitor
extends Item
implements IHaveRenderers {
    public static ItemCapacitor create(@Nonnull IModObject modObject, @Nullable Block block) {
        return new ItemCapacitor(modObject);
    }

    protected ItemCapacitor(@Nonnull IModObject modObject) {
        this.func_77637_a(EnderIOTab.tabEnderIOMaterials);
        modObject.apply(this);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(64);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerRenderers(final @Nonnull IModObject modObject) {
        NNList.of(DefaultCapacitorData.class).apply((NNList.Callback)new NNList.Callback<DefaultCapacitorData>(){

            public void apply(@Nonnull DefaultCapacitorData alloy) {
                ModelLoader.setCustomModelResourceLocation((Item)ItemCapacitor.this, (int)alloy.ordinal(), (ModelResourceLocation)new ModelResourceLocation(modObject.getRegistryName(), "variant=" + alloy.getUnlocalizedName()));
            }
        });
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        return this.func_77658_a() + "." + ((ICapacitorData)stack.getCapability(CapabilityCapacitorData.getCapNN(), null)).getUnlocalizedName();
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (DefaultCapacitorData dcd : DefaultCapacitorData.values()) {
                if (!dcd.isRegular()) continue;
                list.add((Object)new ItemStack((Item)this, 1, dcd.ordinal()));
            }
        }
    }

    public int getMetadata(@Nonnull ItemStack stack) {
        return MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(DefaultCapacitorData.values().length - 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(Lang.MACHINE_UPGRADE.get());
        if (SpecialTooltipHandler.showAdvancedTooltips()) {
            SpecialTooltipHandler.addDetailedTooltipFromResources(tooltip, (String)Lang.MACHINE_UPGRADE.getKey());
        } else {
            SpecialTooltipHandler.addShowDetailsTooltip(tooltip);
        }
        if (NbtValue.GLINT.hasTag(stack)) {
            tooltip.add(EnderIO.lang.localize("loot.capacitor.entry." + NbtValue.CAPNO.getInt(stack), new Object[]{NbtValue.CAPNAME.getString(stack, "(!%$&\ufffd*&%*???")}));
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final @Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        ICapabilityProvider capProvider = new ICapabilityProvider(){

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return capability == CapabilityCapacitorData.getCapNN();
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                if (capability == CapabilityCapacitorData.getCapNN()) {
                    return (T)CapabilityCapacitorData.getCapNN().cast(NullHelper.notnullJ((Object)DefaultCapacitorData.values()[ItemCapacitor.this.getMetadata(stack)], (String)"Enum.values() has a null"));
                }
                return null;
            }
        };
        return new CompoundCapabilityProvider(new ICapabilityProvider[]{super.initCapabilities(stack, nbt), capProvider});
    }

    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return super.func_77636_d(stack) || NbtValue.GLINT.hasTag(stack);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EnumHand hand) {
        if (world.field_72995_K || System.getProperty("INDEV") == null || !player.func_184812_l_()) {
            return EnumActionResult.PASS;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            chest.func_174888_l();
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)world);
            lootcontext$builder.func_186469_a(player.func_184817_da());
            LootTable loottable = world.func_184146_ak().func_186521_a(LootTableList.field_186422_d);
            loottable.func_186460_a((IInventory)chest, world.field_73012_v, lootcontext$builder.func_186471_a());
            return EnumActionResult.PASS;
        }
        IBlockState blockState = world.func_180495_p(pos);
        int meta = blockState.func_177230_c().func_176201_c(blockState);
        player.func_145747_a((ITextComponent)new TextComponentString(blockState + " (" + meta + ")"));
        return EnumActionResult.PASS;
    }
}

