/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.item;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.armor.ArmorItem;
import com.phylogeny.extrabitmanipulation.armor.DataChiseledArmorPiece;
import com.phylogeny.extrabitmanipulation.armor.GlOperation;
import com.phylogeny.extrabitmanipulation.client.ClientHelper;
import com.phylogeny.extrabitmanipulation.client.CreativeTabExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.helper.BitAreaHelper;
import com.phylogeny.extrabitmanipulation.helper.BitInventoryHelper;
import com.phylogeny.extrabitmanipulation.helper.BitToolSettingsHelper;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.init.BlocksExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.init.KeyBindingsExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.init.ModelRegistration;
import com.phylogeny.extrabitmanipulation.item.ItemBitToolBase;
import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import com.phylogeny.extrabitmanipulation.packet.PacketCreateBodyPartTemplate;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.api.KeyBindingContext;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@KeyBindingContext(value={"menuitem"})
public class ItemChiseledArmor
extends ItemArmor {
    public static final String[] MODE_TITLES = new String[]{"Template Creation", "Block Collection"};
    public static final String[] SCALE_TITLES = new String[]{"1:1", "1:2", "1:4"};
    public final ArmorMovingPart[] MOVING_PARTS;
    public final String[] MOVING_PART_TITLES;
    public final ArmorType field_77881_a;
    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation itemModelLocation;

    public ItemChiseledArmor(String name, ItemArmor.ArmorMaterial material, ArmorType armorType, ArmorMovingPart ... movingParts) {
        super(material, 0, armorType.getEquipmentSlot());
        this.setRegistryName(name);
        this.func_77655_b(this.getRegistryName().toString());
        this.func_77637_a(CreativeTabExtraBitManipulation.CREATIVE_TAB);
        this.field_77881_a = armorType;
        this.MOVING_PARTS = movingParts;
        this.MOVING_PART_TITLES = new String[this.MOVING_PARTS.length];
        for (int i = 0; i < this.MOVING_PARTS.length; ++i) {
            this.MOVING_PART_TITLES[i] = this.MOVING_PARTS[i].getName();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation initItemModelLocation() {
        ResourceLocation loc = new ResourceLocation(this.getRegistryName().func_110624_b(), this.getRegistryName().func_110623_a() + "_default");
        this.itemModelLocation = new ModelResourceLocation(loc, "inventory");
        return loc;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getItemModelLocation() {
        return this.itemModelLocation;
    }

    @SideOnly(value=Side.CLIENT)
    public IBakedModel getItemModel() {
        return ClientHelper.getBlockModelShapes().func_178126_b().func_174953_a(this.itemModelLocation);
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, EntityEquipmentSlot slot, ModelBiped modeldefault) {
        return ModelRegistration.getArmorModel(stack, slot, entity);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return ModelRegistration.getArmorTexture(stack, this.func_82812_d());
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77942_o() != newStack.func_77942_o() || oldStack.func_77942_o() && newStack.func_77942_o() && !ItemStackHelper.getArmorData(oldStack.func_77978_p()).equals((Object)ItemStackHelper.getArmorData(newStack.func_77978_p()));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BitToolSettingsHelper.ArmorBodyPartTemplateData templateData;
        Vec3d hit;
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K && ItemChiseledArmor.createBodyPartTemplate(player, world, pos, facing, hit = new Vec3d((double)hitX, (double)hitY, (double)hitZ), templateData = new BitToolSettingsHelper.ArmorBodyPartTemplateData(ItemStackHelper.getNBTOrNew(stack), this)) == EnumActionResult.SUCCESS) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketCreateBodyPartTemplate(pos, facing, hit, templateData));
        }
        return EnumActionResult.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EnumActionResult createBodyPartTemplate(EntityPlayer player, World world, BlockPos pos, EnumFacing facing, Vec3d hit, BitToolSettingsHelper.ArmorBodyPartTemplateData templateData) {
        int bitsMissing;
        NBTTagCompound nbt = ItemStackHelper.getNBTOrNew(player.func_184614_ca());
        if (templateData.getMode() != 0) {
            return EnumActionResult.PASS;
        }
        IChiselAndBitsAPI api = ChiselsAndBitsAPIAccess.apiInstance;
        IBitBrush bitBodyPartTemplate = null;
        try {
            bitBodyPartTemplate = api.createBrushFromState(BlocksExtraBitManipulation.bodyPartTemplate.func_176223_P());
        }
        catch (APIExceptions.InvalidBitItem e) {
            return EnumActionResult.FAIL;
        }
        ItemStack bitStack = bitBodyPartTemplate.getItemStack(1);
        hit = hit.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        AxisAlignedBB box = ItemChiseledArmor.getBodyPartTemplateBox(player, facing, pos, hit, templateData.getScale(), templateData.getMovingPart());
        boolean creativeMode = player.field_71075_bZ.field_75098_d;
        if (!creativeMode && (bitsMissing = (int)(Math.round((box.field_72336_d - box.field_72340_a) / 0.0625) * Math.round((box.field_72337_e - box.field_72338_b) / 0.0625) * Math.round((box.field_72334_f - box.field_72339_c) / 0.0625)) - BitInventoryHelper.countInventoryBits(api, player, bitStack.func_77946_l()) - BitInventoryHelper.countInventoryBlocks(player, BlocksExtraBitManipulation.bodyPartTemplate) * 4096) > 0) {
            if (world.field_72995_K) {
                ClientHelper.printChatMessageWithDeletion("There are insufficient Bodypart Template blocks/bits in your inventory. Obtain " + bitsMissing + " Bodypart Template bits or blocks worth of bits (1 block = 4096 bits).");
            }
            return EnumActionResult.FAIL;
        }
        int bitsPlaced = 0;
        AxisAlignedBB boxBlocks = new AxisAlignedBB(Math.floor(box.field_72340_a), Math.floor(box.field_72338_b), Math.floor(box.field_72339_c), Math.ceil(box.field_72336_d), Math.ceil(box.field_72337_e), Math.ceil(box.field_72334_f));
        try {
            api.beginUndoGroup(player);
            int i = (int)boxBlocks.field_72340_a;
            while ((double)i <= boxBlocks.field_72336_d) {
                int j = (int)boxBlocks.field_72338_b;
                while ((double)j <= boxBlocks.field_72337_e) {
                    int k = (int)boxBlocks.field_72339_c;
                    while ((double)k <= boxBlocks.field_72334_f) {
                        bitsPlaced = ItemChiseledArmor.placeBodyPartTemplateBits(world, new BlockPos(i, j, k), api, box, bitBodyPartTemplate, bitsPlaced);
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        finally {
            api.endUndoGroup(player);
            if (!world.field_72995_K && !creativeMode) {
                bitsPlaced = BitInventoryHelper.removeOrAddInventoryBits(api, player, bitStack.func_77946_l(), bitsPlaced, false);
                BitInventoryHelper.removeBitsFromBlocks(api, player, bitStack, BlocksExtraBitManipulation.bodyPartTemplate, bitsPlaced);
                player.field_71069_bz.func_75142_b();
            }
            if (bitsPlaced > 0) {
                ItemSculptingTool.playPlacementSound(player, world, pos, 1.0f);
                if (world.field_72995_K) {
                    ClientHelper.printChatMessageWithDeletion("Created a " + ItemChiseledArmor.getPartAndScaleText(templateData.getMovingPart(), templateData.getScale()) + " and set collection reference area");
                }
            }
        }
        if (!world.field_72995_K) {
            ItemChiseledArmor.writeCollectionBoxToNBT(nbt, player.field_70177_z, player.func_70093_af(), player.func_174811_aO().func_176734_d(), pos, facing, hit);
            player.func_184614_ca().func_77982_d(nbt);
        }
        return bitsPlaced > 0 ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
    }

    public static String getPartAndScaleText(ArmorMovingPart part, int scale) {
        return SCALE_TITLES[scale] + " scale " + part.getBodyPartTemplate().getName().toLowerCase() + " template";
    }

    public static void writeCollectionBoxToNBT(NBTTagCompound nbt, float playerYaw, boolean useBitGrid, EnumFacing facingBox, BlockPos pos, EnumFacing facingPlacement, Vec3d hit) {
        BitAreaHelper.writeFacingToNBT(facingBox, nbt, "facingBox");
        BitAreaHelper.writeFacingToNBT(facingPlacement, nbt, "facingPlacement");
        BitAreaHelper.writeBlockPosToNBT(pos, nbt, "pos");
        BitAreaHelper.writeVecToNBT(hit, nbt, "hit");
        nbt.func_74776_a("yaw", playerYaw);
        nbt.func_74757_a("useBitGrid", useBitGrid);
    }

    private static int placeBodyPartTemplateBits(World world, BlockPos pos, IChiselAndBitsAPI api, AxisAlignedBB box, IBitBrush bitBodyPartTemplate, int bitsPlaced) {
        IBitAccess bitAccess;
        try {
            bitAccess = api.getBitAccess(world, pos);
        }
        catch (APIExceptions.CannotBeChiseled e) {
            return bitsPlaced;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    IBitBrush bit = bitAccess.getBitAt(i, j, k);
                    if (!bit.isAir()) continue;
                    double x = (double)pos.func_177958_n() + (double)i * 0.0625 + 0.03125;
                    double y = (double)pos.func_177956_o() + (double)j * 0.0625 + 0.03125;
                    double z = (double)pos.func_177952_p() + (double)k * 0.0625 + 0.03125;
                    if (x < box.field_72340_a || x > box.field_72336_d || y < box.field_72338_b || y > box.field_72337_e || z < box.field_72339_c || z > box.field_72334_f) continue;
                    try {
                        bitAccess.setBitAt(i, j, k, bitBodyPartTemplate);
                        ++bitsPlaced;
                        continue;
                    }
                    catch (APIExceptions.SpaceOccupied spaceOccupied) {
                        // empty catch block
                    }
                }
            }
        }
        bitAccess.commitChanges(true);
        return bitsPlaced;
    }

    public static AxisAlignedBB getBodyPartTemplateBox(EntityPlayer player, EnumFacing facingPlacement, BlockPos pos, Vec3d hit, int scale, ArmorMovingPart part) {
        return ItemChiseledArmor.getBodyPartTemplateBox(player.field_70177_z, player.func_70093_af(), player.func_174811_aO(), facingPlacement, pos, hit, scale, part);
    }

    /*
     * Unable to fully structure code
     */
    public static AxisAlignedBB getBodyPartTemplateBox(float playerYaw, boolean useBitGrid, EnumFacing facingBox, EnumFacing facingPlacement, BlockPos pos, Vec3d hit, int scale, ArmorMovingPart part) {
        block7: {
            block10: {
                block8: {
                    block9: {
                        block6: {
                            scale = (int)Math.pow(2.0, scale);
                            bodyPart = part.getBodyPartTemplate();
                            isHead = bodyPart == BodyPartTemplate.HEAD;
                            semiDiameterX = (double)((bodyPart == BodyPartTemplate.LIMB ? 2 : 4) * scale) * 0.0625;
                            semiDiameterY = (double)((isHead != false ? 4 : 6) * scale) * 0.0625;
                            semiDiameterZ = (double)((isHead != false ? 4 : 2) * scale) * 0.0625;
                            if (facingBox.func_176740_k() == EnumFacing.Axis.X) {
                                tempX = semiDiameterX;
                                semiDiameterX = semiDiameterZ;
                                semiDiameterZ = tempX;
                            }
                            offsetX = facingPlacement.func_82601_c();
                            offsetY = facingPlacement.func_96559_d();
                            offsetZ = facingPlacement.func_82599_e();
                            box = null;
                            if (!useBitGrid) break block6;
                            hitX = (float)hit.field_72450_a - (float)pos.func_177958_n();
                            bitLoc = ChiselsAndBitsAPIAccess.apiInstance.getBitPos(hitX, hitY = (float)hit.field_72448_b - (float)pos.func_177956_o(), hitZ = (float)hit.field_72449_c - (float)pos.func_177952_p(), facingPlacement, pos, false);
                            if (bitLoc != null) {
                                x2 = (double)bitLoc.getBitX() * 0.0625;
                                y2 = (double)bitLoc.getBitY() * 0.0625;
                                z2 = (double)bitLoc.getBitZ() * 0.0625;
                                offset = facingPlacement.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 0.0625 : 0.0;
                                box = new AxisAlignedBB(x2 - semiDiameterX, y2 - semiDiameterY, z2 - semiDiameterZ, x2 + semiDiameterX, y2 + semiDiameterY, z2 + semiDiameterZ).func_72317_d((semiDiameterX + offset) * (double)offsetX, (semiDiameterY + offset) * (double)offsetY, (semiDiameterZ + offset) * (double)offsetZ).func_186670_a(pos);
                            }
                            break block7;
                        }
                        x2 = (double)pos.func_177958_n() + 0.5;
                        y2 = (double)pos.func_177956_o() + 0.5;
                        z2 = (double)pos.func_177952_p() + 0.5;
                        box = new AxisAlignedBB(x2 - semiDiameterX, y2 - semiDiameterY, z2 - semiDiameterZ, x2 + semiDiameterX, y2 + semiDiameterY, z2 + semiDiameterZ).func_72317_d(0.0, (semiDiameterY - 0.5) * (double)(offsetY != 0 ? offsetY : 1), 0.0).func_72317_d((double)offsetX, (double)offsetY, (double)offsetZ);
                        if (scale != 4 || bodyPart == BodyPartTemplate.LIMB) break block7;
                        if (facingBox.func_176740_k() == EnumFacing.Axis.X && !isHead) break block8;
                        if (facingPlacement.func_176740_k() != EnumFacing.Axis.X) break block9;
                        if (facingPlacement.func_176743_c() != EnumFacing.AxisDirection.POSITIVE) ** GOTO lbl-1000
                        ** GOTO lbl-1000
                    }
                    v0 = playerYaw > 0.0f ? 180 : -180;
                    if (playerYaw % 360.0f > (float)v0) lbl-1000:
                    // 2 sources

                    {
                        v1 = 0.5;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = -0.5;
                    }
                    box = box.func_72317_d(v1, 0.0, 0.0);
                }
                if (facingBox.func_176740_k() != EnumFacing.Axis.X && !isHead) break block7;
                if (facingPlacement.func_176740_k() != EnumFacing.Axis.Z) break block10;
                if (facingPlacement.func_176743_c() != EnumFacing.AxisDirection.POSITIVE) ** GOTO lbl-1000
                ** GOTO lbl-1000
            }
            v2 = playerYaw > 90.0f ? 180 : -180;
            if ((playerYaw - 90.0f) % 360.0f > (float)v2) lbl-1000:
            // 2 sources

            {
                v3 = 0.5;
            } else lbl-1000:
            // 2 sources

            {
                v3 = -0.5;
            }
            box = box.func_72317_d(0.0, 0.0, v3);
        }
        return box;
    }

    public static boolean collectArmorBlocks(EntityPlayer player, BitToolSettingsHelper.ArmorCollectionData collectionData) {
        ItemStack stack = player.func_184614_ca();
        NBTTagCompound nbt = ItemStackHelper.getNBTOrNew(stack);
        DataChiseledArmorPiece armorPiece = new DataChiseledArmorPiece(nbt, ((ItemChiseledArmor)stack.func_77973_b()).field_77881_a);
        World world = player.field_70170_p;
        AxisAlignedBB boxCollection = collectionData.getCollectionBox();
        AxisAlignedBB boxBlocks = new AxisAlignedBB(Math.floor(boxCollection.field_72340_a), Math.floor(boxCollection.field_72338_b), Math.floor(boxCollection.field_72339_c), Math.ceil(boxCollection.field_72336_d), Math.ceil(boxCollection.field_72337_e), Math.ceil(boxCollection.field_72334_f));
        IChiselAndBitsAPI api = ChiselsAndBitsAPIAccess.apiInstance;
        ArmorMovingPart movingPart = collectionData.getMovingPart();
        EnumFacing facingBox = collectionData.getFacing();
        Vec3d orginBox = collectionData.getOriginBodyPart();
        float scale = 1.0f / (float)Math.pow(2.0, collectionData.getScale());
        int blocksCollected = 0;
        int i = (int)boxBlocks.field_72340_a;
        while ((double)i <= boxBlocks.field_72336_d) {
            int j = (int)boxBlocks.field_72338_b;
            while ((double)j <= boxBlocks.field_72337_e) {
                int k = (int)boxBlocks.field_72339_c;
                while ((double)k <= boxBlocks.field_72334_f) {
                    blocksCollected = ItemChiseledArmor.collectBits(world, new BlockPos(i, j, k), api, boxCollection, facingBox, orginBox, scale, armorPiece, movingPart, blocksCollected);
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        if (blocksCollected > 0) {
            if (world.field_72995_K) {
                ClientHelper.printChatMessageWithDeletion("Imported " + blocksCollected + " block cop" + (blocksCollected > 1 ? "ies" : "y") + " at " + SCALE_TITLES[collectionData.getScale()] + " scale into the " + collectionData.getMovingPart().getName().toLowerCase());
            } else {
                armorPiece.saveToNBT(nbt);
                stack.func_77982_d(nbt);
                player.field_71069_bz.func_75142_b();
            }
        }
        return blocksCollected > 0;
    }

    private static int collectBits(World world, BlockPos pos, IChiselAndBitsAPI api, AxisAlignedBB boxCollection, EnumFacing facingBox, Vec3d orginBox, float scale, DataChiseledArmorPiece armorPiece, ArmorMovingPart movingPart, int blocksCollected) {
        IBitAccess bitAccess;
        try {
            bitAccess = api.getBitAccess(world, pos);
        }
        catch (APIExceptions.CannotBeChiseled e) {
            return blocksCollected;
        }
        IBitAccess bitAccessNew = api.createBitItem(ItemStack.field_190927_a);
        if (bitAccessNew == null) {
            return blocksCollected;
        }
        boolean bitsCollected = false;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    IBitBrush bit = bitAccess.getBitAt(i, j, k);
                    if (bit.isAir() || bit.getState() == BlocksExtraBitManipulation.bodyPartTemplate.func_176223_P()) continue;
                    double x = (double)pos.func_177958_n() + (double)i * 0.0625 + 0.03125;
                    double y = (double)pos.func_177956_o() + (double)j * 0.0625 + 0.03125;
                    double z = (double)pos.func_177952_p() + (double)k * 0.0625 + 0.03125;
                    if (x < boxCollection.field_72340_a || x > boxCollection.field_72336_d || y < boxCollection.field_72338_b || y > boxCollection.field_72337_e || z < boxCollection.field_72339_c || z > boxCollection.field_72334_f) continue;
                    try {
                        if (!world.field_72995_K) {
                            bitAccessNew.setBitAt(i, j, k, bit);
                        }
                        bitsCollected = true;
                        continue;
                    }
                    catch (APIExceptions.SpaceOccupied spaceOccupied) {
                        // empty catch block
                    }
                }
            }
        }
        if (!world.field_72995_K && bitsCollected) {
            ArmorItem armorItem = new ArmorItem(bitAccessNew.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false));
            if (facingBox != EnumFacing.NORTH) {
                armorItem.addGlOperation(GlOperation.createRotation((facingBox.func_185119_l() + 180.0f) % 360.0f, 0.0f, 1.0f, 0.0f));
            }
            if (scale != 1.0f) {
                armorItem.addGlOperation(GlOperation.createScale(scale, scale, scale));
            }
            AxisAlignedBB box = new AxisAlignedBB(pos);
            float x = (float)(box.field_72340_a - orginBox.field_72450_a);
            float y = (float)(box.field_72338_b - orginBox.field_72448_b);
            float z = (float)(box.field_72339_c - orginBox.field_72449_c);
            if (x != 0.0f || y != 0.0f || z != 0.0f) {
                armorItem.addGlOperation(GlOperation.createTranslation(x, y, z));
            }
            armorPiece.addItemToPart(movingPart.getPartIndex(), armorItem);
        }
        if (bitsCollected) {
            ++blocksCollected;
        }
        return blocksCollected;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        boolean shiftDown = GuiScreen.func_146272_n();
        boolean ctrlDown = GuiScreen.func_146271_m();
        ItemBitToolBase.addColorInformation(tooltip, shiftDown);
        NBTTagCompound nbt = stack.func_77978_p();
        int mode = BitToolSettingsHelper.getArmorMode(nbt);
        boolean targetBits = BitToolSettingsHelper.areArmorBitsTargeted(nbt);
        if (shiftDown) {
            tooltip.add(ItemBitToolBase.colorSettingText(BitToolSettingsHelper.getArmorModeText(mode), Configs.armorMode));
            tooltip.add(ItemBitToolBase.colorSettingText(BitToolSettingsHelper.getArmorScaleText(nbt), Configs.armorScale));
            tooltip.add(ItemBitToolBase.colorSettingText(BitToolSettingsHelper.getArmorBitsTargetedText(targetBits), Configs.armorTargetBits));
        }
        if (!ctrlDown || shiftDown) {
            tooltip.add(ItemBitToolBase.colorSettingText(BitToolSettingsHelper.getArmorMovingPartText(nbt, this), BitToolSettingsHelper.getArmorMovingPartConfig(this.field_77881_a)));
        }
        if (shiftDown) {
            return;
        }
        if (!ctrlDown) {
            ItemBitToolBase.addKeyInformation(tooltip, true);
            return;
        }
        if (mode == 1) {
            String target = targetBits ? "bit" : "block";
            tooltip.add("Left click a " + target + ", drag to another ");
            tooltip.add("    " + target + ", then release to import copies");
            if (targetBits) {
                tooltip.add("    of all intersecting bits into the");
                tooltip.add("    selected moving part as blocks.");
            } else {
                tooltip.add("    of all intersecting blocks into the");
                tooltip.add("    selected moving part.");
            }
        } else {
            tooltip.add("Left click a block to set the collection");
            tooltip.add("    reference area for the bodypart");
            tooltip.add("    template of the selected moving part.");
            tooltip.add("    (sneaking will allow the area to be");
            tooltip.add("    placed outside of the block grid)");
        }
        if (mode == 0) {
            tooltip.add("Right click to do so and fill that area");
            tooltip.add("    with bits of bodypart template blocks.");
        }
        tooltip.add("");
        String controlText = ItemBitToolBase.getColoredKeyBindText(KeyBindingsExtraBitManipulation.CONTROL);
        if (KeyBindingsExtraBitManipulation.OPEN_BIT_MAPPING_GUI.getKeyBinding().isSetToDefaultValue()) {
            tooltip.add(controlText + " right click to toggle mode.");
        } else {
            tooltip.add(controlText + " right click or press " + KeyBindingsExtraBitManipulation.OPEN_BIT_MAPPING_GUI.getText());
            tooltip.add("    to open mapping/preview GUI.");
        }
        tooltip.add(controlText + " mouse wheel to cycle scale.");
        tooltip.add("");
        String altText = ItemBitToolBase.getColoredKeyBindText(KeyBindingsExtraBitManipulation.ALT);
        tooltip.add(altText + " right click to toggle collection");
        tooltip.add("     target between bits & blocks.");
        tooltip.add(altText + " mouse wheel to cycle moving part.");
        ItemBitToolBase.addKeybindReminders(tooltip, KeyBindingsExtraBitManipulation.SHIFT, KeyBindingsExtraBitManipulation.CONTROL);
    }

    public static enum ArmorMovingPart {
        HEAD(ModelMovingPart.HEAD, 0, 1, "Head"),
        TORSO(ModelMovingPart.BODY, 0, 2, "Torso"),
        PELVIS(ModelMovingPart.BODY, 0, 1, "Pelvis"),
        ARM_RIGHT(ModelMovingPart.ARM_RIGHT, 1, 1, "Right Arm"),
        ARM_LEFT(ModelMovingPart.ARM_LEFT, 2, 2, "Left Arm"),
        LEG_RIGHT(ModelMovingPart.LEG_RIGHT, 1, 3, 1, "Right Leg"),
        LEG_LEFT(ModelMovingPart.LEG_LEFT, 2, 2, "Left Leg"),
        FOOT_RIGHT(ModelMovingPart.LEG_RIGHT, 0, 1, "Right Foot"),
        FOOT_LEFT(ModelMovingPart.LEG_LEFT, 1, 2, "Left Foot");

        private ModelMovingPart modelPart;
        private int partIndex;
        private int modelCount;
        private int opaqueIndex;
        private String name;
        @SideOnly(value=Side.CLIENT)
        private ModelResourceLocation[] iconModelLocationsDiamond;
        @SideOnly(value=Side.CLIENT)
        private ModelResourceLocation[] iconModelLocationsIron;

        private ArmorMovingPart(ModelMovingPart modelPart, int partIndex, int modelCount, String name) {
            this(modelPart, partIndex, modelCount, 0, name);
        }

        private ArmorMovingPart(ModelMovingPart modelPart, int partIndex, int modelCount, int opaqueIndex, String name) {
            this.modelPart = modelPart;
            this.partIndex = partIndex;
            this.modelCount = modelCount;
            this.opaqueIndex = opaqueIndex;
            this.name = name;
        }

        public ModelMovingPart getModelMovingPart() {
            return this.modelPart;
        }

        public BodyPartTemplate getBodyPartTemplate() {
            return this.modelPart.getBodyPartTemplate();
        }

        public int getPartIndex() {
            return this.partIndex;
        }

        public String getName() {
            return this.name;
        }

        @SideOnly(value=Side.CLIENT)
        public IBakedModel[] getIconModels(ItemArmor.ArmorMaterial material) {
            ModelResourceLocation[] iconModelLocations = material == ItemArmor.ArmorMaterial.DIAMOND ? this.iconModelLocationsDiamond : this.iconModelLocationsIron;
            IBakedModel[] models = new IBakedModel[iconModelLocations.length];
            for (int i = 0; i < iconModelLocations.length; ++i) {
                models[i] = ClientHelper.getBlockModelShapes().func_178126_b().func_174953_a(iconModelLocations[i]);
            }
            return models;
        }

        @SideOnly(value=Side.CLIENT)
        public static ResourceLocation[] initAndGetIconModelLocations() {
            ArrayList<ModelResourceLocation> modelLocations = new ArrayList<ModelResourceLocation>();
            for (ArmorMovingPart part : ArmorMovingPart.values()) {
                part.iconModelLocationsDiamond = new ModelResourceLocation[part.modelCount];
                part.iconModelLocationsIron = new ModelResourceLocation[part.modelCount];
                for (int i = 0; i < part.modelCount; ++i) {
                    part.iconModelLocationsDiamond[i] = ArmorMovingPart.createIconModelLocation(part, i, ItemArmor.ArmorMaterial.DIAMOND);
                    part.iconModelLocationsIron[i] = ArmorMovingPart.createIconModelLocation(part, i, ItemArmor.ArmorMaterial.IRON);
                    modelLocations.add(part.iconModelLocationsDiamond[i]);
                    modelLocations.add(part.iconModelLocationsIron[i]);
                }
            }
            return modelLocations.toArray(new ResourceLocation[modelLocations.size()]);
        }

        private static ModelResourceLocation createIconModelLocation(ArmorMovingPart part, int index, ItemArmor.ArmorMaterial material) {
            return new ModelResourceLocation(new ResourceLocation("extrabitmanipulation", "moving_part_" + (index == part.opaqueIndex ? material.toString().toLowerCase() + "_" : "") + part.name.toLowerCase().replace(" ", "_") + "_" + index), null);
        }
    }

    public static enum ModelMovingPart {
        HEAD(BodyPartTemplate.HEAD, 6, 12, "Head"),
        BODY(BodyPartTemplate.TORSO, 1, 13, "Body"),
        ARM_RIGHT(BodyPartTemplate.LIMB, 3, 17, "Right Arm"),
        ARM_LEFT(BodyPartTemplate.LIMB, 2, 16, "Left Arm"),
        LEG_RIGHT(BodyPartTemplate.LIMB, 5, 19, "Right Leg"),
        LEG_LEFT(BodyPartTemplate.LIMB, 4, 18, "Left Leg");

        private BodyPartTemplate template;
        private int partIndexOverlay;
        private int partIndexNoppes;
        private String name;

        private ModelMovingPart(BodyPartTemplate template, int partIndexOverlay, int partIndexNoppes, String name) {
            this.template = template;
            this.partIndexOverlay = partIndexOverlay;
            this.partIndexNoppes = partIndexNoppes;
            this.name = name;
        }

        public BodyPartTemplate getBodyPartTemplate() {
            return this.template;
        }

        public int getPartIndexNoppes() {
            return this.partIndexNoppes;
        }

        public String getName() {
            return this.name;
        }

        public String getOverlayName() {
            return EnumPlayerModelParts.values()[this.partIndexOverlay].func_179326_d().func_150254_d();
        }
    }

    public static enum BodyPartTemplate {
        HEAD("Head"),
        TORSO("Torso"),
        LIMB("Limb");

        private String name;

        private BodyPartTemplate(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum ArmorType {
        HELMET("Helmet", EntityEquipmentSlot.HEAD, 1),
        CHESTPLATE("Chestplate", EntityEquipmentSlot.CHEST, 3),
        LEGGINGS("Leggings", EntityEquipmentSlot.LEGS, 3),
        BOOTS("Boots", EntityEquipmentSlot.FEET, 2);

        private String name;
        private int movingpartCount;
        private EntityEquipmentSlot equipmentSlot;
        @SideOnly(value=Side.CLIENT)
        private ItemStack iconStack;

        private ArmorType(String name, int movingpartCount) {
            this(name, null, movingpartCount);
        }

        private ArmorType(String name, EntityEquipmentSlot equipmentSlot, int movingpartCount) {
            this.name = name;
            this.movingpartCount = movingpartCount;
            this.equipmentSlot = equipmentSlot;
        }

        public String getName() {
            return this.name;
        }

        public int getMovingpartCount() {
            return this.movingpartCount;
        }

        @Nullable
        public EntityEquipmentSlot getEquipmentSlot() {
            return this.equipmentSlot;
        }

        @SideOnly(value=Side.CLIENT)
        public void initIconStack(Item item) {
            this.iconStack = new ItemStack(item);
        }

        @SideOnly(value=Side.CLIENT)
        public IBakedModel getIconModel() {
            return ClientHelper.getRenderItem().func_184393_a(this.iconStack, null, (EntityLivingBase)ClientHelper.getPlayer());
        }

        public int getSlotIndex(int indexArmorSet) {
            return this.ordinal() + (indexArmorSet - 1) * 4;
        }
    }
}

