/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.network;

import com.google.common.base.Throwables;
import io.netty.buffer.ByteBuf;
import mcmultipart.MCMultiPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class Packet<T extends Packet<T>>
implements IMessage,
IMessageHandler<T, T> {
    public final T onMessage(T message, MessageContext ctx) {
        MCMultiPart.proxy.scheduleTick(() -> {
            if (ctx.side == Side.CLIENT) {
                message.handleClient(MCMultiPart.proxy.getPlayer());
            } else {
                message.handleServer((EntityPlayer)ctx.getServerHandler().field_147369_b);
            }
        }, ctx.side);
        return null;
    }

    public final void toBytes(ByteBuf buf) {
        try {
            this.toBytes(new PacketBuffer(buf));
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public final void fromBytes(ByteBuf buf) {
        try {
            this.fromBytes(new PacketBuffer(buf));
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public abstract void handleClient(EntityPlayer var1);

    public abstract void handleServer(EntityPlayer var1);

    public abstract void toBytes(PacketBuffer var1) throws Exception;

    public abstract void fromBytes(PacketBuffer var1) throws Exception;
}

