/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config;

import com.bloodnbonesgaming.lib.util.script.ScriptUtil;
import com.bloodnbonesgaming.triumph.Triumph;
import com.bloodnbonesgaming.triumph.config.MainConfig;
import com.bloodnbonesgaming.triumph.config.data.AdvancementData;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class IOHelper {
    public static boolean readAdvancementData(File file, AdvancementData data) {
        return ScriptUtil.readScript((File)file, (Object)data, null);
    }

    public static boolean loadMainConfig(MainConfig config) {
        return ScriptUtil.readScript((File)new File("./config/triumph/Triumph.txt"), (Object)config, null);
    }

    public static boolean readAdvancementData(String advancementID, AdvancementData data) {
        ResourceLocation location = new ResourceLocation(advancementID);
        File file = new File("./config/triumph/script/" + location.func_110624_b() + "/" + location.func_110623_a() + ".txt");
        return ScriptUtil.readScript((File)file, (Object)data, null);
    }

    public static void writeText(File file, String text) {
        file.getParentFile().mkdirs();
        try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            writer.write(text);
        }
        catch (Exception e1) {
            Triumph.instance.getLog().error((Object)("Failed to write file " + file.getName()));
            e1.printStackTrace();
        }
    }

    public static List<String> getAdvancementsInFolder(String folderName, String exclusion) {
        ArrayList<String> advancements = new ArrayList<String>();
        File folder = new File("./config/triumph/script/" + folderName.replaceAll(":", "/"));
        if (folder.exists() && folder.isDirectory()) {
            for (File file : folder.listFiles()) {
                String string;
                String filePath;
                if (!file.isDirectory()) {
                    filePath = file.getPath();
                    string = filePath.substring("./config/triumph/script/".length(), filePath.length() - 4).replace("\\", "/");
                    String[] splitLocation = string.split("/", 2);
                    String location = splitLocation.length == 2 ? splitLocation[0] + ":" + splitLocation[1] : "triumph:" + splitLocation[0];
                    if (location.equals(exclusion)) continue;
                    advancements.add(location);
                    continue;
                }
                filePath = file.getPath();
                string = filePath.substring("./config/triumph/script/".length()).replace("\\", "/");
                advancements.addAll(IOHelper.getAdvancementsInFolder(string, ""));
            }
        }
        return advancements;
    }

    public static String findRootForAdvancement(String advancement) throws Exception {
        block3: {
            ArrayList<String> tested = new ArrayList<String>();
            block0: while (true) {
                List lines;
                if (tested.contains(advancement)) {
                    throw new Exception("Failed to find root. Circular parents detected.");
                }
                ResourceLocation location = new ResourceLocation(advancement);
                File file = new File("./config/triumph/script/" + location.func_110624_b() + "/" + location.func_110623_a() + ".txt");
                if (!file.exists() || (lines = ScriptUtil.getScriptLines((File)file)) == null || lines.isEmpty()) break block3;
                for (String line : lines) {
                    String trim = line.trim();
                    if (!trim.startsWith("addParent") && !trim.startsWith("setParent")) continue;
                    String parent = trim.substring(trim.indexOf("\"") + 1, trim.lastIndexOf("\""));
                    tested.add(advancement);
                    advancement = parent;
                    continue block0;
                }
                break;
            }
            return advancement;
        }
        throw new Exception("Failed to find root. Unable to read script for advancement: " + advancement);
    }
}

