/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import com.bloodnbonesgaming.triumph.config.data.DamageSourceData;
import com.bloodnbonesgaming.triumph.config.data.EntityData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.util.ResourceLocation;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/minecraft/entity_killed_player", classExplaination="These are the functions which can be called on a minecraft:entity_killed_player trigger.")
public class EntityKilledPlayerTriggerData
extends CriterionTriggerData {
    private static final ResourceLocation location = new ResourceLocation("minecraft:entity_killed_player");
    private final DamageSourceData damageSourceData = new DamageSourceData();
    private final EntityData entityData = new EntityData();

    public EntityKilledPlayerTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() {
        return new Criterion((ICriterionInstance)new KilledTrigger.Instance(location, this.entityData.buildPredicate(), this.damageSourceData.buildPredicate()));
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the DamageSourceData object so functions can be called on it.")
    public DamageSourceData getDamageSource() {
        return this.damageSourceData;
    }

    @ScriptMethodDocumentation(usage="", notes="Returns the EntityData object so functions can be called on it.")
    public EntityData getEntityData() {
        return this.entityData;
    }

    @ScriptMethodDocumentation(args="String", usage="entity type", notes="Sets the entity type.")
    public void setEntityType(String type) {
        this.entityData.setType(type);
    }
}

