/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.mputils.network;

import com.gendeathrow.mputils.commands.common.MP_InContainer;
import com.gendeathrow.mputils.core.MPUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.logging.log4j.Level;

public class RequestTEPacket
implements IMessage {
    public int requestID = 0;
    public NBTTagCompound tags = new NBTTagCompound();
    public String[] args;

    public RequestTEPacket() {
    }

    public RequestTEPacket(NBTTagCompound tags, String[] arg) {
        this.requestID = 0;
        this.tags = tags;
        this.args = arg;
    }

    protected RequestTEPacket(int requestID, NBTTagCompound tags, String[] arg) {
        this.requestID = requestID;
        this.tags = tags;
        this.args = arg;
    }

    public static RequestTEPacket requestTEItemDump(BlockPos pos, String[] args) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("bposX", (double)pos.func_177958_n());
        nbt.func_74780_a("bposY", (double)pos.func_177956_o());
        nbt.func_74780_a("bposZ", (double)pos.func_177952_p());
        return new RequestTEPacket(1, nbt, args);
    }

    public void fromBytes(ByteBuf buf) {
        this.requestID = ByteBufUtils.readVarInt((ByteBuf)buf, (int)3);
        this.tags = ByteBufUtils.readTag((ByteBuf)buf);
        int length = buf.readInt();
        this.args = new String[length];
        for (int count = 0; count != length; ++count) {
            this.args[count] = ByteBufUtils.readUTF8String((ByteBuf)buf);
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.requestID, (int)3);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tags);
        buf.writeInt(this.args.length);
        for (String arg : this.args) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)arg);
        }
    }

    public static class ClientHandler
    implements IMessageHandler<RequestTEPacket, IMessage> {
        public IMessage onMessage(final RequestTEPacket message, MessageContext ctx) {
            if (message == null || message.tags == null) {
                MPUtils.logger.log(Level.ERROR, "A critical NPE error occured during while handling a Hatchery packet Client side", (Throwable)new NullPointerException());
                return null;
            }
            Minecraft mainThread = Minecraft.func_71410_x();
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    NBTTagCompound nbt = message.tags;
                    if (message.requestID == 0) {
                        BlockPos pos = new BlockPos(nbt.func_74769_h("bposX"), nbt.func_74769_h("bposY"), nbt.func_74769_h("bposZ"));
                        TileEntity te = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(pos);
                        if (te == null) {
                            return;
                        }
                        te.func_145839_a(nbt);
                        MP_InContainer.copyInventoryClipboard(te, message.args);
                    }
                }
            });
            return null;
        }
    }

    public static class ServerHandler
    implements IMessageHandler<RequestTEPacket, IMessage> {
        public IMessage onMessage(final RequestTEPacket message, final MessageContext ctx) {
            if (message == null || message.tags == null) {
                MPUtils.logger.log(Level.ERROR, "A critical NPE error occured during while handling a Hatchery packet server side", (Throwable)new NullPointerException());
                return null;
            }
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
                    NBTTagCompound nbt = message.tags;
                    if (message.requestID == 1) {
                        TileEntity te = sender.field_70170_p.func_175625_s(new BlockPos(nbt.func_74769_h("bposX"), nbt.func_74769_h("bposY"), nbt.func_74769_h("bposZ")));
                        if (te == null) {
                            return;
                        }
                        NBTTagCompound requestNBT = new NBTTagCompound();
                        requestNBT = te.func_189515_b(requestNBT);
                        requestNBT.func_74780_a("bposX", (double)te.func_174877_v().func_177958_n());
                        requestNBT.func_74780_a("bposY", (double)te.func_174877_v().func_177956_o());
                        requestNBT.func_74780_a("bposZ", (double)te.func_174877_v().func_177952_p());
                        MPUtils.network.sendTo((IMessage)new RequestTEPacket(requestNBT, message.args), sender);
                    }
                }
            });
            return null;
        }
    }
}

