/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.tileentity;

import ipsis.Woot;
import ipsis.woot.farmblocks.ControllerMasterLocator;
import ipsis.woot.farmblocks.FactoryGlue;
import ipsis.woot.farmblocks.IFactoryGlue;
import ipsis.woot.farmblocks.IFactoryGlueProvider;
import ipsis.woot.farmblocks.IFarmBlockController;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.tileentity.ui.ControllerUIInfo;
import ipsis.woot.util.WootMob;
import ipsis.woot.util.WootMobBuilder;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileEntityMobFactoryController
extends TileEntity
implements IFarmBlockController,
IFactoryGlueProvider {
    private IFactoryGlue iFactoryGlue;
    private WootMob wootMob = new WootMob();

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeControllerToNBT(compound);
        return compound;
    }

    public TileEntityMobFactoryController() {
        this.iFactoryGlue = new FactoryGlue(IFactoryGlue.FactoryBlockType.CONTROLLER, new ControllerMasterLocator(), this, this);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readControllerFromNBT(compound);
    }

    @Override
    public void readControllerFromNBT(NBTTagCompound compound) {
        this.wootMob = WootMobBuilder.create(compound);
    }

    public void writeControllerToNBT(NBTTagCompound compound) {
        WootMobBuilder.writeToNBT(this.wootMob, compound);
    }

    @Override
    public boolean isProgrammed() {
        return this.wootMob.isValid();
    }

    @Override
    @Nonnull
    public WootMob getWootMob() {
        return this.wootMob;
    }

    public void onBlockAdded() {
        this.iFactoryGlue.onHello(this.func_145831_w(), this.func_174877_v());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.iFactoryGlue.onGoodbye();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.iFactoryGlue.onGoodbye();
    }

    public ItemStack getDroppedItemStack() {
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)ModBlocks.blockFactoryController), 1);
        if (this.wootMob.isValid()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.writeControllerToNBT(tag);
            itemStack.func_77982_d(tag);
        }
        return itemStack;
    }

    public static ItemStack getProgrammedStack(WootMob wootMob) {
        ItemStack itemStack = new ItemStack(Item.func_150898_a((Block)ModBlocks.blockFactoryController), 1);
        if (wootMob.isValid()) {
            NBTTagCompound tag = new NBTTagCompound();
            WootMobBuilder.writeToNBT(wootMob, tag);
            itemStack.func_77982_d(tag);
        }
        return itemStack;
    }

    public void getUIInfo(ControllerUIInfo info) {
        if (this.isProgrammed()) {
            info.isValid = true;
            info.wootMob = this.wootMob;
            info.requiredTier = Woot.wootConfiguration.getFactoryTier(this.field_145850_b, this.wootMob.getWootMobName());
        }
    }

    @Override
    @Nonnull
    public IFactoryGlue getIFactoryGlue() {
        return this.iFactoryGlue;
    }
}

