/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.multiblock;

import ipsis.woot.multiblock.EnumMobFactoryModule;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.multiblock.MobFactoryModule;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.tileentity.ILayoutBlockInfo;
import ipsis.woot.tileentity.StructureLayoutBlockInfo;
import ipsis.woot.util.BlockPosHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class FactoryPatternRepository {
    private int maxYOffset = 0;
    private int maxXZOffset = 0;
    private HashMap<EnumMobFactoryTier, FactoryTierPattern> tiers = new HashMap();
    public static final String[][] TIER_ONE_PATTERN = new String[][]{{"-rrr-", "rgggr", "rg-gr", "rgggr", "-rrr-"}, {"-----", "-----", "--x--", "-pgp-", "-rgr-"}, {"-----", "-----", "-----", "-----", "-1-1-"}};
    public static final String[][] TIER_TWO_PATTERN = new String[][]{{"--ooo--", "-orrro-", "orgggro", "org-gro", "orgggro", "-orrro-", "--ooo--"}, {"-------", "-------", "-------", "o--x--o", "oppgppo", "-orgro-", "--ooo--"}, {"-------", "-------", "-------", "-------", "o-----o", "-o1-1o-", "--o-o--"}, {"-------", "-------", "-------", "-------", "-------", "-o---o-", "--o-o--"}, {"-------", "-------", "-------", "-------", "-------", "-2---2-", "--2-2--"}};
    public static final String[][] TIER_THREE_PATTERN = new String[][]{{"---hhh---", "--hoooh--", "-horrroh-", "horgggroh", "horg-groh", "horgggroh", "-horrroh-", "--hoooh--", "---hhh---"}, {"---------", "---------", "---------", "h-------h", "ho--x--oh", "hoppgppoh", "-horgroh-", "--hoooh--", "---hhh---"}, {"---------", "---------", "---------", "---------", "h-------h", "ho-----oh", "-ho1-1oh-", "--ho-oh--", "---hhh---"}, {"---------", "---------", "---------", "---------", "---------", "h-------h", "-ho---oh-", "--ho-oh--", "---hhh---"}, {"---------", "---------", "---------", "---------", "---------", "---------", "-h2---2h-", "--h2-2h--", "---hhh---"}, {"---------", "---------", "---------", "---------", "---------", "---------", "-3-----3-", "--3---3--", "----3----"}};
    public static final String[][] TIER_FOUR_PATTERN = new String[][]{{"----www----", "---whhhw---", "--whooohw--", "-whorrrohw-", "whorgggrohw", "whorg-grohw", "whorgggrohw", "-whorrrohw-", "--whooohw--", "---whhhw---", "----www----"}, {"-----------", "-----------", "--w-----w--", "-w-------w-", "wh-------hw", "who--x--ohw", "whoppgppohw", "-whorgrohw-", "--whooohw--", "---whhhw---", "----www----"}, {"-----------", "-----------", "-----------", "-w-------w-", "w---------w", "wh-------hw", "who-----ohw", "-who1-1ohw-", "--who-ohw--", "---whhhw---", "----www----"}, {"-----------", "-----------", "-----------", "-----------", "w---------w", "w---------w", "wh-------hw", "-who---ohw-", "--who-ohw--", "---whhhw---", "----www----"}, {"-----------", "-----------", "-----------", "-----------", "-----------", "w---------w", "w---------w", "-wh2---2hw-", "--wh2-2hw--", "---whhhw---", "----www----"}, {"-----------", "-----------", "-----------", "-----------", "-----------", "-----------", "w---------w", "-w3-----3w-", "---3---3---", "---w-3-w---", "-----w-----"}, {"-----------", "-----------", "-----------", "-----------", "-----------", "-----------", "4---------4", "-4-------4-", "-----------", "---4---4---", "-----4-----"}};

    public FactoryPatternRepository() {
        this.load(EnumMobFactoryTier.TIER_ONE, TIER_ONE_PATTERN);
        this.load(EnumMobFactoryTier.TIER_TWO, TIER_TWO_PATTERN);
        this.load(EnumMobFactoryTier.TIER_THREE, TIER_THREE_PATTERN);
        this.load(EnumMobFactoryTier.TIER_FOUR, TIER_FOUR_PATTERN);
    }

    private void load(EnumMobFactoryTier tier, String[][] pattern) {
        char c;
        int col;
        int row;
        int layer;
        if (pattern.length == 0) {
            LogHelper.info("FactorPatternRepository.load: pattern length is invalid");
            return;
        }
        int height = pattern.length;
        int width = pattern[0].length;
        if (width == 0) {
            LogHelper.info("FactorPatternRepository.load: pattern row count is invalid");
            return;
        }
        int depth = pattern[0][0].length();
        if (depth == 0) {
            LogHelper.info("FactorPatternRepository.load: pattern column count is invalid");
            return;
        }
        FactoryTierPattern tierPattern = new FactoryTierPattern();
        tierPattern.setHeight(height);
        tierPattern.setWidth(width);
        boolean hasOrigin = false;
        for (layer = 0; layer < height; ++layer) {
            for (row = 0; row < width; ++row) {
                for (col = 0; col < depth; ++col) {
                    c = pattern[layer][row].charAt(col);
                    if (!this.isOrigin(c)) continue;
                    tierPattern.setOrigin(layer, row, col);
                    hasOrigin = true;
                }
            }
        }
        if (!hasOrigin) {
            LogHelper.info("FactorPatternRepository.load: pattern has no origin");
            return;
        }
        for (layer = 0; layer < height; ++layer) {
            for (row = 0; row < width; ++row) {
                if (pattern[layer][row].length() != depth) {
                    LogHelper.info("FactorPatternRepository.load: pattern row is too short");
                    return;
                }
                for (col = 0; col < depth; ++col) {
                    c = pattern[layer][row].charAt(col);
                    if (this.isSpace(c) || this.isOrigin(c)) continue;
                    if (EnumMobFactoryModule.isValidChar(c)) {
                        EnumMobFactoryModule m = EnumMobFactoryModule.byChar(c);
                        tierPattern.incBlockCount(m);
                        tierPattern.addModules(new MobFactoryModule(tierPattern.calcBlockPos(layer, row, col), m));
                        continue;
                    }
                    LogHelper.info(String.format("FactoryPatternRepository.load: invalid character (%d,%d,%d) %c", layer, row, col, Character.valueOf(c)));
                    return;
                }
            }
        }
        this.tiers.put(tier, tierPattern);
        if (this.maxYOffset == 0 || this.maxYOffset < height) {
            this.maxYOffset = height;
        }
        if (this.maxXZOffset == 0 || this.maxXZOffset < tierPattern.getOriginCol() / 2) {
            this.maxXZOffset = width;
        }
    }

    private boolean isSpace(char c) {
        return c == '-';
    }

    private boolean isOrigin(char c) {
        return c == 'x';
    }

    @Nullable
    private MobFactoryModule getMobFactoryModule(EnumMobFactoryTier tier, BlockPos offset) {
        if (!this.tiers.containsKey((Object)tier)) {
            return null;
        }
        for (MobFactoryModule m : this.tiers.get((Object)tier).modules) {
            if (!m.offset.equals((Object)offset)) continue;
            return m;
        }
        return null;
    }

    public int getMaxXZOffset() {
        return this.maxXZOffset;
    }

    public int getMaxYOffset() {
        return this.maxYOffset;
    }

    @Nullable
    public EnumMobFactoryModule getModule(EnumMobFactoryTier tier, BlockPos offset) {
        MobFactoryModule module = this.getMobFactoryModule(tier, offset);
        return module != null ? module.moduleType : null;
    }

    public boolean isValid(EnumMobFactoryTier tier, EnumMobFactoryModule m, BlockPos offset) {
        MobFactoryModule module = this.getMobFactoryModule(tier, offset);
        return module != null && module.moduleType == m;
    }

    public List<MobFactoryModule> getAllModules(EnumMobFactoryTier tier) {
        return this.tiers.containsKey((Object)tier) ? this.tiers.get((Object)tier).modules : Collections.emptyList();
    }

    public void getFactoryLayout(EnumMobFactoryTier tier, BlockPos origin, EnumFacing facing, List<ILayoutBlockInfo> layoutBlockInfoList) {
        if (!this.tiers.containsKey((Object)tier)) {
            return;
        }
        for (MobFactoryModule s : this.tiers.get((Object)tier).getModules()) {
            BlockPos p = BlockPosHelper.rotateFromSouth(s.getOffset(), facing.func_176734_d());
            p = origin.func_177971_a((Vec3i)p);
            layoutBlockInfoList.add(new StructureLayoutBlockInfo(p, s.moduleType));
        }
    }

    public int getTierHeight(EnumMobFactoryTier tier) {
        return this.tiers.get((Object)tier).getHeight();
    }

    public int getBlockCount(EnumMobFactoryTier tier, EnumMobFactoryModule m) {
        return this.tiers.get((Object)tier).getBlockCount(m);
    }

    private class FactoryTierPattern {
        private int originLayer;
        private int originRow;
        private int originCol;
        private int width;
        private int height;
        private HashMap<EnumMobFactoryModule, Integer> blockCounts = new HashMap();
        private List<MobFactoryModule> modules = new ArrayList<MobFactoryModule>();

        private FactoryTierPattern() {
        }

        public void setOrigin(int layer, int row, int col) {
            this.originLayer = layer;
            this.originRow = row;
            this.originCol = col;
        }

        public BlockPos calcBlockPos(int layer, int row, int col) {
            int l = (this.originLayer - layer) * -1;
            int r = (this.originRow - row) * -1;
            int c = (this.originCol - col) * -1;
            return new BlockPos(c, l, r);
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getOriginLayer() {
            return this.originLayer;
        }

        public int getOriginRow() {
            return this.originRow;
        }

        public int getOriginCol() {
            return this.originCol;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getBlockCount(EnumMobFactoryModule m) {
            return this.blockCounts.containsKey((Object)m) ? this.blockCounts.get((Object)m) : 0;
        }

        public void incBlockCount(EnumMobFactoryModule m) {
            if (!this.blockCounts.containsKey((Object)m)) {
                this.blockCounts.put(m, 0);
            }
            this.blockCounts.put(m, this.blockCounts.get((Object)m) + 1);
        }

        public void addModules(MobFactoryModule m) {
            this.modules.add(m);
        }

        public List<MobFactoryModule> getModules() {
            return this.modules;
        }
    }
}

