/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.configuration.loaders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.Woot;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.configuration.IWootConfiguration;
import ipsis.woot.oss.FileUtils;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.JsonHelper;
import ipsis.woot.util.WootMobName;
import ipsis.woot.util.WootMobNameBuilder;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;

public class FactoryConfigLoader {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private IWootConfiguration wootConfiguration;

    public void loadConfig(IWootConfiguration wootConfiguration) {
        this.wootConfiguration = wootConfiguration;
        try {
            String configText = FileUtils.copyConfigFileFromJar("factory_config.json", false);
            JsonObject jsonObject = (JsonObject)JsonUtils.func_193837_a((Gson)GSON, (String)configText, JsonObject.class, (boolean)false);
            this.parseConfig(jsonObject);
        }
        catch (Exception e) {
            LogHelper.error("Could not load factory config from " + FileUtils.getConfigFile("factory_config.json").getAbsolutePath());
            e.printStackTrace();
        }
    }

    private void parseConfig(JsonObject json) {
        WootMobName wootMobName;
        String[] mobs;
        String[] entityMods;
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        int version = JsonUtils.func_151208_a((JsonObject)json, (String)"version", (int)-1);
        if (version == -1 || version != 1) {
            throw new JsonSyntaxException("Invalid version");
        }
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"mobconfigs")) {
            this.parseMobConfigs(ele);
        }
        JsonElement ele = json.get("entitymodblacklist");
        if (ele == null || !ele.isJsonArray()) {
            throw new JsonSyntaxException("entitymodblacklist: must a string list");
        }
        for (String mod : entityMods = (String[])GSON.fromJson(ele, String[].class)) {
            Woot.policyRepository.addModToEntityList(mod, false);
        }
        ele = json.get("entityblacklist");
        if (ele == null || !ele.isJsonArray()) {
            throw new JsonSyntaxException("entityblacklist must a string list");
        }
        for (String mob : mobs = (String[])GSON.fromJson(ele, String[].class)) {
            wootMobName = WootMobNameBuilder.createFromConfigString(mob);
            if (wootMobName.isValid()) {
                Woot.policyRepository.addEntityToEntityList(wootMobName, false);
                continue;
            }
            LogHelper.warn("Entity blacklist: invalid mob name " + mob);
        }
        ele = json.get("entitywhitelist");
        if (ele == null || !ele.isJsonArray()) {
            throw new JsonSyntaxException("entitywhitelist must a string list");
        }
        for (String mob : mobs = (String[])GSON.fromJson(ele, String[].class)) {
            wootMobName = WootMobNameBuilder.createFromConfigString(mob);
            if (wootMobName.isValid()) {
                Woot.policyRepository.addEntityToEntityWhitelist(wootMobName);
                continue;
            }
            LogHelper.warn("Entity whitelist: invalid mob name " + mob);
        }
        ele = json.get("itemmodblacklist");
        if (ele == null || !ele.isJsonArray()) {
            throw new JsonSyntaxException("itemmodblacklist: must a string list");
        }
        String[] mods = (String[])GSON.fromJson(ele, String[].class);
        for (int i = 0; i < mods.length; ++i) {
            Woot.policyRepository.addModToDropList(mods[i], false);
        }
        for (JsonElement ele2 : JsonUtils.func_151214_t((JsonObject)json, (String)"itemblacklist")) {
            if (ele2 == null || !ele2.isJsonObject()) {
                throw new JsonSyntaxException("Blacklisted item must be an object");
            }
            JsonObject itemObject = (JsonObject)ele2;
            ItemStack itemStack = JsonHelper.getItemStack(itemObject);
            if (itemStack.func_190926_b()) {
                LogHelper.info("Item blacklist: invalid item");
                continue;
            }
            Woot.policyRepository.addItemToDropList(itemStack, false);
        }
    }

    private void parseMobConfigs(JsonElement ele) {
        if (ele == null || !ele.isJsonObject()) {
            throw new JsonSyntaxException("Mob configs must be object");
        }
        JsonObject json = (JsonObject)ele;
        WootMobName wootMobName = JsonHelper.getWootMobName(json);
        if (wootMobName.isValid()) {
            for (JsonElement ele2 : JsonUtils.func_151214_t((JsonObject)json, (String)"configs")) {
                if (ele2 == null || !ele.isJsonObject()) {
                    throw new JsonSyntaxException("Mob config must be object");
                }
                JsonObject json2 = (JsonObject)ele2;
                String tag = JsonUtils.func_151219_a((JsonObject)json2, (String)"tag", (String)"");
                int value = JsonUtils.func_151208_a((JsonObject)json2, (String)"value", (int)-1);
                if (tag.equals("")) {
                    throw new JsonSyntaxException("Tag cannot be empty");
                }
                if (value >= 0) {
                    EnumConfigKey configKey = EnumConfigKey.get(tag);
                    if (configKey == null) {
                        LogHelper.error(wootMobName + " unknown config key " + tag);
                        continue;
                    }
                    this.wootConfiguration.setInteger(wootMobName, configKey, value);
                    LogHelper.info(wootMobName + "/" + (Object)((Object)configKey) + "/" + value);
                    continue;
                }
                LogHelper.error(wootMobName + " Value must be >= 0");
            }
        }
    }
}

