/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.client.gui.element;

import ipsis.woot.client.gui.GuiContainerWoot;
import ipsis.woot.client.gui.element.DisplayFluidStack;
import ipsis.woot.client.gui.element.DisplayItemStack;
import ipsis.woot.client.gui.element.DisplayStack;
import ipsis.woot.client.gui.element.ElementBase;
import ipsis.woot.client.gui.element.WidgetFluidStack;
import ipsis.woot.client.gui.element.WidgetItemStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ElementStackBox
extends ElementBase {
    private List<DisplayStack> stacks = new ArrayList<DisplayStack>();
    private boolean showFlag = false;
    private int currRow = 0;
    private int currCol = 0;
    private int maxCol = 0;

    public ElementStackBox(GuiContainerWoot guiContainerWoot, FontRenderer fontRenderer, String header, int baseX, int baseY, int sizeX, int sizeY) {
        super(guiContainerWoot, fontRenderer, header, baseX, baseY, sizeX, sizeY);
        this.maxCol = (sizeX - 4) / WidgetItemStack.getWidth();
    }

    public void setShowFlag(boolean showFlag) {
        this.showFlag = showFlag;
    }

    public DisplayItemStack addItemStack(ItemStack itemStack) {
        int x = this.contentX + this.currCol * WidgetItemStack.getWidth();
        int y = this.contentY + this.currRow * WidgetItemStack.getHeight();
        DisplayItemStack displayItemStack = new DisplayItemStack(x, y, itemStack);
        this.stacks.add(displayItemStack);
        ++this.currCol;
        if (this.currCol == this.maxCol) {
            ++this.currRow;
            this.currCol = 0;
        }
        return displayItemStack;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public DisplayFluidStack addFluidStack(FluidStack fluidStack) {
        int x = this.contentX + this.currCol * WidgetFluidStack.getWidth();
        int y = this.contentY + this.currRow * WidgetFluidStack.getHeight();
        DisplayFluidStack displayFluidStack = new DisplayFluidStack(x, y, fluidStack);
        this.stacks.add(displayFluidStack);
        ++this.currCol;
        if (this.currCol == this.maxCol) {
            ++this.currRow;
            this.currCol = 0;
        }
        return displayFluidStack;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        super.drawBackground(mouseX, mouseY);
        for (int n = 0; n < this.stacks.size(); ++n) {
            String s;
            int y;
            int x;
            DisplayStack displayStack;
            DisplayStack stack = this.stacks.get(n);
            if (stack instanceof DisplayItemStack) {
                displayStack = (DisplayItemStack)stack;
                x = this.gui.getGuiLeft() + displayStack.x;
                y = this.gui.getGuiTop() + displayStack.y;
                WidgetItemStack.draw(this.gui, displayStack.itemStack, x, y, null);
                if (!this.showFlag) continue;
                s = "?";
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                this.fontRenderer.func_175063_a(s, (float)(x + 19 - 2 - this.fontRenderer.func_78256_a(s)), (float)(y + 6 + 3 + 8), Color.RED.getRGB());
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
                continue;
            }
            if (!(stack instanceof DisplayFluidStack)) continue;
            displayStack = (DisplayFluidStack)stack;
            x = this.gui.getGuiLeft() + ((DisplayFluidStack)displayStack).x;
            y = this.gui.getGuiTop() + ((DisplayFluidStack)displayStack).y;
            WidgetFluidStack.draw(this.gui, ((DisplayFluidStack)displayStack).fluidStack, x, y);
            if (!this.showFlag) continue;
            s = "?";
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            this.fontRenderer.func_175063_a(s, (float)(x + 19 - 2 - this.fontRenderer.func_78256_a(s)), (float)(y + 6 + 3 + 8), Color.RED.getRGB());
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            GlStateManager.func_179147_l();
        }
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        super.drawForeground(mouseX, mouseY);
        for (DisplayStack stack : this.stacks) {
            if (!stack.isHit(mouseX, mouseY)) continue;
            List<String> tooltip = stack.getTooltip(this.gui);
            this.gui.func_146283_a(tooltip, mouseX, mouseY);
            break;
        }
    }
}

