/*
 * Decompiled with CFR 0.152.
 */
package ipsis;

import ipsis.woot.command.WootCommand;
import ipsis.woot.configuration.ChangeLog;
import ipsis.woot.configuration.IMobCost;
import ipsis.woot.configuration.IWootConfiguration;
import ipsis.woot.configuration.MobHealthManager;
import ipsis.woot.configuration.WootConfigurationManager;
import ipsis.woot.configuration.loaders.ChangelogLoader;
import ipsis.woot.configuration.loaders.CustomDropsLoader;
import ipsis.woot.configuration.loaders.FactoryConfigLoader;
import ipsis.woot.configuration.loaders.FactoryIngredientsLoader;
import ipsis.woot.configuration.loaders.FactoryLootLoader;
import ipsis.woot.crafting.AnvilManager;
import ipsis.woot.crafting.AnvilManagerLoader;
import ipsis.woot.crafting.IAnvilManager;
import ipsis.woot.dimension.WootDimensionManager;
import ipsis.woot.event.HandlerRegistryEvent;
import ipsis.woot.farming.ISpawnRecipeRepository;
import ipsis.woot.farming.SpawnRecipeRepository;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.init.ModFurnace;
import ipsis.woot.init.ModOreDictionary;
import ipsis.woot.loot.ILootGeneration;
import ipsis.woot.loot.LootGeneration;
import ipsis.woot.loot.customdrops.CustomDropsRepository;
import ipsis.woot.loot.repository.LootRepository;
import ipsis.woot.loot.schools.TartarusManager;
import ipsis.woot.multiblock.FactoryPatternRepository;
import ipsis.woot.plugins.bloodmagic.BloodMagic;
import ipsis.woot.plugins.enderio.EnderIO;
import ipsis.woot.plugins.evilcraft.EvilCraft;
import ipsis.woot.plugins.thauncraft.Thaumcraft;
import ipsis.woot.plugins.thermal.Thermal;
import ipsis.woot.policy.IPolicy;
import ipsis.woot.policy.InternalPolicyLoader;
import ipsis.woot.policy.PolicyRepository;
import ipsis.woot.power.calculation.upgrades.CalculatorRepository;
import ipsis.woot.proxy.CommonProxy;
import ipsis.woot.reference.Files;
import ipsis.woot.spawning.EntitySpawner;
import ipsis.woot.spawning.IEntitySpawner;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.SkullHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="woot", name="Woot", version="1.12.2-1.4.10", guiFactory="ipsis.woot.client.GuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class Woot {
    @Mod.Instance(value="woot")
    public static Woot instance;
    public static Random RANDOM;
    public static IWootConfiguration wootConfiguration;
    public static ILootGeneration lootGeneration;
    public static LootRepository lootRepository;
    public static CustomDropsRepository customDropsRepository;
    public static IMobCost mobCosting;
    public static IEntitySpawner entitySpawner;
    public static DebugSetup debugSetup;
    public static IAnvilManager anvilManager;
    public static IPolicy policyRepository;
    public static ISpawnRecipeRepository spawnRecipeRepository;
    public static TartarusManager tartarusManager;
    public static WootDimensionManager wootDimensionManager;
    public static FactoryPatternRepository factoryPatternRepository;
    public static CalculatorRepository calculatorRepository;
    public static ChangeLog changeLog;
    @SidedProxy(clientSide="ipsis.woot.proxy.ClientProxy", serverSide="ipsis.woot.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs tabWoot;

    public Woot() {
        MinecraftForge.EVENT_BUS.register((Object)new HandlerRegistryEvent());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Files.init(event);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init();
        new InternalPolicyLoader().load(policyRepository);
        new ChangelogLoader().load();
        new FactoryConfigLoader().loadConfig(wootConfiguration);
        new FactoryIngredientsLoader().loadConfig();
        new CustomDropsLoader().loadConfig();
        ModFurnace.init();
        lootGeneration.initialise();
        AnvilManagerLoader.load();
        EnderIO.loadRecipes();
        ModOreDictionary.init();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"ipsis.woot.plugins.waila.WailaDataProviderWoot.callbackRegister");
        if (Loader.isModLoaded((String)"bloodmagic")) {
            BloodMagic.init();
        }
        if (Loader.isModLoaded((String)"evilcraft")) {
            EvilCraft.init();
        }
        if (Loader.isModLoaded((String)"thermalexpansion")) {
            Thermal.init();
        }
        if (Loader.isModLoaded((String)"thaumcraft")) {
            Thaumcraft.init();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        SkullHelper.postInit();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        new FactoryLootLoader().loadConfig(lootRepository);
        event.registerServerCommand((ICommand)new WootCommand());
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent event) {
        lootRepository.writeToJsonFile(Files.lootFile);
    }

    static {
        RANDOM = new Random();
        wootConfiguration = new WootConfigurationManager();
        lootGeneration = new LootGeneration();
        lootRepository = new LootRepository();
        customDropsRepository = new CustomDropsRepository();
        mobCosting = new MobHealthManager();
        entitySpawner = new EntitySpawner();
        debugSetup = new DebugSetup();
        anvilManager = new AnvilManager();
        policyRepository = new PolicyRepository();
        spawnRecipeRepository = new SpawnRecipeRepository();
        tartarusManager = new TartarusManager();
        wootDimensionManager = new WootDimensionManager();
        factoryPatternRepository = new FactoryPatternRepository();
        calculatorRepository = new CalculatorRepository();
        changeLog = new ChangeLog();
        tabWoot = new CreativeTabs("woot"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack(Item.func_150898_a((Block)ModBlocks.blockFactoryHeart));
            }
        };
    }
}

