/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries.charger;

import appeng.api.features.IChargerRegistry;
import com.google.common.base.Preconditions;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;

public class ChargerRegistry
implements IChargerRegistry {
    private static final double DEFAULT_CHARGE_RATE = 160.0;
    private static final double CAPPED_CHARGE_RATE = 16000.0;
    private final Map<Item, Double> chargeRates = new IdentityHashMap<Item, Double>();

    @Override
    @Nonnegative
    public double getChargeRate(@Nonnull Item item) {
        Preconditions.checkNotNull((Object)item);
        return this.chargeRates.getOrDefault(item, 160.0);
    }

    @Override
    public void addChargeRate(@Nonnull Item item, @Nonnegative double value) {
        Preconditions.checkNotNull((Object)item);
        Preconditions.checkArgument((value > 0.0 ? 1 : 0) != 0);
        double cappedValue = Math.min(value, 16000.0);
        this.chargeRates.put(item, cappedValue);
    }

    @Override
    public void removeChargeRate(@Nonnull Item item) {
        Preconditions.checkNotNull((Object)item);
        this.chargeRates.remove(item);
    }
}

