/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.coin_miner.client;

import com.feed_the_beast.coin_miner.MoneyUtils;
import com.feed_the_beast.coin_miner.tile.TileBeastCoinMiner;
import java.math.BigInteger;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import reborncore.api.IListInfoProvider;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.StringUtils;

public class GuiBeastCoinMiner
extends GuiBase {
    TileBeastCoinMiner tile;
    private static final BigInteger HUNDREAD = BigInteger.valueOf(100L);

    public GuiBeastCoinMiner(EntityPlayer player, TileBeastCoinMiner tile) {
        super(player, (TileEntity)tile, tile.createContainer(player));
        this.tile = tile;
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;
        if (this.tile.owner.equals(this.field_146297_k.field_71439_g.func_110124_au().toString())) {
            this.builder.drawString((GuiScreen)this, "Current balance:", 30, 20, 1123176);
            this.builder.drawString((GuiScreen)this, MoneyUtils.moneyString(this.tile.getMoney()), 35, 30, 622114);
            this.builder.drawString((GuiScreen)this, "Total mined:", 30, 40, 1123176);
            this.builder.drawString((GuiScreen)this, MoneyUtils.moneyString(this.tile.getTotal_money()), 35, 50, 15240460);
            this.builder.drawString((GuiScreen)this, "Current coin cost:", 30, 60, 1123176);
            this.builder.drawString((GuiScreen)this, String.format("%,d", this.tile.cost) + " FE", 35, 70, 14029844);
            if (this.tile.getClient_energy().compareTo(BigInteger.valueOf(this.tile.cost)) < 0) {
                this.builder.drawString((GuiScreen)this, this.percentage(BigInteger.valueOf(this.tile.cost), this.tile.getClient_energy()) + "%", 150, 80, 13844297);
            }
        } else {
            this.builder.drawString((GuiScreen)this, "You do not own this miner!", 25, 50, 13844297);
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawMultiEnergyBar(this, 9, 19, this.tile.getClient_energy(), mouseX, mouseY, 0, layer);
    }

    public void drawMultiEnergyBar(GuiBase gui, int x, int y, BigInteger energyStored, int mouseX, int mouseY, int buttonID, GuiBase.Layer layer) {
        if (GuiBase.slotConfigType != GuiBase.SlotConfigType.NONE) {
            return;
        }
        if (layer == GuiBase.Layer.BACKGROUND) {
            x += gui.getGuiLeft();
            y += gui.getGuiTop();
        }
        PowerSystem.EnergySystem displayPower = PowerSystem.getDisplayPower();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiBuilder.defaultTextureSheet);
        gui.func_73729_b(x, y, displayPower.xBar - 15, displayPower.yBar - 1, 14, 50);
        int draw = (int)(Minecraft.func_71386_F() / 10L % 96L);
        draw = draw > 48 ? (int)(this.ease((double)(96 - draw) / 48.0) * 48.0) : (int)(this.ease((double)draw / 48.0) * 48.0);
        gui.func_73729_b(x + 1, y + 49 - draw, displayPower.xBar, 48 + displayPower.yBar - draw, 12, draw);
        if (gui.isPointInRect(x + 1, y + 1, 11, 48, mouseX, mouseY)) {
            ArrayList<String> list = new ArrayList<String>();
            TextFormatting powerColour = TextFormatting.GOLD;
            list.add(powerColour + this.split(energyStored.toString()) + " rf / literally infinite");
            list.add(TextFormatting.BLUE + "" + TextFormatting.OBFUSCATED + "100" + TextFormatting.GRAY + "% " + StringUtils.t((String)"reborncore.gui.tooltip.power_charged"));
            if (gui.tile instanceof IListInfoProvider) {
                if (GuiScreen.func_146272_n()) {
                    ((IListInfoProvider)gui.tile).addInfo(list, true);
                    list.add("");
                    list.add(TextFormatting.BLUE + StringUtils.t((String)"reborncore.gui.tooltip.power_click"));
                } else {
                    list.add("");
                    list.add(TextFormatting.BLUE + "Shift" + TextFormatting.GRAY + " " + StringUtils.t((String)"reborncore.gui.tooltip.power_moreinfo"));
                }
            }
            if (layer == GuiBase.Layer.FOREGROUND) {
                mouseX -= gui.getGuiLeft();
                mouseY -= gui.getGuiTop();
            }
            gui.func_146283_a(list, mouseX, mouseY);
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        gui.addPowerButton(x, y, buttonID, layer);
    }

    private double ease(double t) {
        return t < 0.5 ? 4.0 * t * t * t : (t - 1.0) * (2.0 * t - 2.0) * (2.0 * t - 2.0) + 1.0;
    }

    protected BigInteger percentage(BigInteger maxValue, BigInteger currentValue) {
        if (currentValue.equals(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        return currentValue.multiply(HUNDREAD).divide(maxValue);
    }

    private String split(String input) {
        if (input.length() < 5) {
            return input;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            if (i != 0 && i % 3 == 0) {
                builder.append(",");
            }
            builder.append(input.charAt(i));
        }
        return builder.toString();
    }
}

