/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.items.craftingcard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.varia.ItemStackList;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.items.GenericRFToolsItem;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingCardItem
extends GenericRFToolsItem {
    public CraftingCardItem() {
        super("crafting_card");
    }

    public static void testRecipe(World world, ItemStack craftingCard) {
        ItemStackList stacks = CraftingCardItem.getStacksFromItem(craftingCard);
        InventoryCrafting workInventory = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                int idx = y * 3 + x;
                int idxCard = y * 5 + x;
                workInventory.func_70299_a(idx, (ItemStack)stacks.get(idxCard));
            }
        }
        IRecipe recipe = CraftingManager.func_192413_b((InventoryCrafting)workInventory, (World)world);
        if (recipe != null) {
            ItemStack stack = recipe.func_77572_b(workInventory);
            stacks.set(20, (Object)stack);
        } else {
            stacks.set(20, (Object)ItemStack.field_190927_a);
        }
        CraftingCardItem.putStacksInItem(craftingCard, stacks);
    }

    public static ItemStackList getStacksFromItem(ItemStack craftingCard) {
        NBTTagCompound tagCompound = craftingCard.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            craftingCard.func_77982_d(tagCompound);
        }
        ItemStackList stacks = ItemStackList.create((int)21);
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            stacks.set(i, (Object)new ItemStack(nbtTagCompound));
        }
        return stacks;
    }

    public static void putStacksInItem(ItemStack craftingCard, ItemStackList stacks) {
        NBTTagCompound tagCompound = craftingCard.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            craftingCard.func_77982_d(tagCompound);
        }
        NBTTagList bufferTagList = new NBTTagList();
        for (ItemStack stack : stacks) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(nbtTagCompound);
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> list, ITooltipFlag advanced) {
        super.func_77624_a(stack, playerIn, list, advanced);
        list.add("This item can be used for auto");
        list.add("crafting. It stores ingredients");
        list.add("and end result for a recipe");
        boolean strictnbt = CraftingCardItem.isStrictNBT(stack);
        list.add(TextFormatting.GREEN + "Strict NBT: " + TextFormatting.WHITE + (strictnbt ? "yes" : "no"));
        ItemStack result = CraftingCardItem.getResult(stack);
        if (!result.func_190926_b()) {
            if (result.func_190916_E() > 1) {
                list.add(TextFormatting.BLUE + "Item: " + TextFormatting.WHITE + result.func_82833_r() + "(" + result.func_190916_E() + ")");
            } else {
                list.add(TextFormatting.BLUE + "Item: " + TextFormatting.WHITE + result.func_82833_r());
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            player.openGui((Object)RFToolsControl.instance, RFToolsControl.GUI_CRAFTINGCARD, player.func_130014_f_(), (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static ItemStack getResult(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return ItemStack.field_190927_a;
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(20);
        return new ItemStack(nbtTagCompound);
    }

    private static boolean isInGrid(int index) {
        int x = index % 5;
        int y = index / 5;
        return x <= 2 && y <= 2;
    }

    public static boolean fitsGrid(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound;
            ItemStack s;
            if (i >= 20 || (s = new ItemStack(nbtTagCompound = bufferTagList.func_150305_b(i))).func_190926_b() || CraftingCardItem.isInGrid(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean isStrictNBT(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        return tagCompound.func_74767_n("strictnbt");
    }

    public static List<ItemStack> getIngredientsGrid(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            if (i >= 20) continue;
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            ItemStack s = new ItemStack(nbtTagCompound);
            if (!CraftingCardItem.isInGrid(i)) continue;
            stacks.add(s);
        }
        return stacks;
    }

    public static List<ItemStack> getIngredients(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound;
            ItemStack s;
            if (i >= 20 || (s = new ItemStack(nbtTagCompound = bufferTagList.func_150305_b(i))).func_190926_b()) continue;
            stacks.add(s);
        }
        return stacks;
    }
}

