/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.item;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import lumien.randomthings.block.ModBlocks;
import lumien.randomthings.config.Features;
import lumien.randomthings.entitys.EntityArtificialEndPortal;
import lumien.randomthings.entitys.EntityGoldenEgg;
import lumien.randomthings.entitys.EntitySpectreIlluminator;
import lumien.randomthings.handler.spectreilluminator.SpectreIlluminationHandler;
import lumien.randomthings.item.ItemBase;
import lumien.randomthings.item.ModItems;
import lumien.randomthings.lib.IRTItemColor;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemIngredient
extends ItemBase
implements IRTItemColor {
    static int counter = 0;

    public ItemIngredient() {
        super("ingredient");
        this.func_77627_a(true);
        final BehaviorProjectileDispense pro = new BehaviorProjectileDispense(){

            protected IProjectile func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
                return new EntityGoldenEgg(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        };
        final BehaviorDefaultDispenseItem def = new BehaviorDefaultDispenseItem();
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new IBehaviorDispenseItem(){

            public ItemStack func_82482_a(IBlockSource source, ItemStack stack) {
                if (stack.func_77952_i() != INGREDIENT.GOLDEN_EGG.id) {
                    return def.func_82482_a(source, stack);
                }
                return pro.func_82482_a(source, stack);
            }
        });
    }

    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77952_i() == INGREDIENT.PRECIOUS_EMERALD.id;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (INGREDIENT i : INGREDIENT.values()) {
                subItems.add((Object)new ItemStack((Item)this, 1, i.id));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        int id = stack.func_77952_i();
        if (id >= 0 && id < INGREDIENT.values().length) {
            return "item.ingredient." + INGREDIENT.values()[id].name;
        }
        return "item.ingredient.invalid";
    }

    public INGREDIENT getIngredient(ItemStack stack) {
        return INGREDIENT.values()[stack.func_77952_i()];
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        SpectreIlluminationHandler handler;
        ItemStack stack = playerIn.func_184586_b(hand);
        INGREDIENT ingredient = this.getIngredient(stack);
        if (ingredient == INGREDIENT.ECTO_PLASM) {
            IBlockState state = worldIn.func_180495_p(pos);
            int saplingID = OreDictionary.getOreID((String)"treeSapling");
            if (state.func_177230_c() != ModBlocks.spectreSapling) {
                for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(state.func_177230_c()))) {
                    if (id != saplingID) continue;
                    if (!worldIn.field_72995_K) {
                        stack.func_190918_g(1);
                        worldIn.func_175656_a(pos, ModBlocks.spectreSapling.func_176223_P());
                    }
                    return EnumActionResult.SUCCESS;
                }
            }
        } else if (ingredient == INGREDIENT.EVIL_TEAR && Features.ARTIFICIAL_END_PORTAL) {
            IBlockState state = worldIn.func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_185764_cQ && EntityArtificialEndPortal.isValidPosition(worldIn, pos.func_177979_c(3), true)) {
                if (!worldIn.field_72995_K) {
                    BlockPos portalCenter = pos.func_177979_c(3);
                    worldIn.func_72838_d((Entity)new EntityArtificialEndPortal(worldIn, (double)portalCenter.func_177958_n() + 0.5, portalCenter.func_177956_o(), (double)portalCenter.func_177952_p() + 0.5));
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
        } else if (ingredient == INGREDIENT.BLACKOUT_POWDER && !worldIn.field_72995_K && (handler = SpectreIlluminationHandler.get(worldIn)).isIlluminated(pos)) {
            ArrayList list = new ArrayList();
            ChunkPos chunkPos = worldIn.func_175726_f(pos).func_76632_l();
            worldIn.func_175726_f(pos).func_177430_a(EntitySpectreIlluminator.class, new AxisAlignedBB((double)(chunkPos.func_180334_c() - 2), 0.0, (double)(chunkPos.func_180333_d() - 2), (double)(chunkPos.func_180332_e() + 2), 255.0, (double)(chunkPos.func_180330_f() + 2)), list, Predicates.alwaysTrue());
            if (!list.isEmpty()) {
                EntitySpectreIlluminator first = (EntitySpectreIlluminator)((Object)list.get(0));
                first.func_70106_y();
                BlockPos spawnPos = pos.func_177972_a(facing);
                worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5, new ItemStack((Item)ModItems.spectreIlluminator)));
            }
            handler.toggleChunk(worldIn, pos);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (this.getIngredient(stack) == INGREDIENT.LOTUS_BLOSSOM) {
            if (entityLiving instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityLiving;
                if (!worldIn.field_72995_K) {
                    int j;
                    for (int i = 3 + worldIn.field_73012_v.nextInt(5) + worldIn.field_73012_v.nextInt(5); i > 0; i -= j) {
                        j = EntityXPOrb.func_70527_a((int)i);
                        worldIn.func_72838_d((Entity)new EntityXPOrb(worldIn, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, j));
                    }
                }
            }
            stack.func_190918_g(1);
            return stack;
        }
        return super.func_77654_b(stack, worldIn, entityLiving);
    }

    public int func_77626_a(ItemStack stack) {
        if (this.getIngredient(stack) == INGREDIENT.LOTUS_BLOSSOM) {
            return 10;
        }
        return super.func_77626_a(stack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (this.getIngredient(stack) == INGREDIENT.LOTUS_BLOSSOM) {
            return EnumAction.EAT;
        }
        return super.func_77661_b(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        INGREDIENT ingredient = this.getIngredient(itemstack);
        if (ingredient == INGREDIENT.LOTUS_BLOSSOM) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        if (ingredient == INGREDIENT.GOLDEN_EGG) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            worldIn.func_184148_a((EntityPlayer)null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, SoundEvents.field_187511_aA, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 1.0f));
            if (!worldIn.field_72995_K) {
                EntityGoldenEgg entityegg = new EntityGoldenEgg(worldIn, (EntityLivingBase)playerIn);
                entityegg.func_184538_a((Entity)playerIn, playerIn.field_70125_A, playerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
                worldIn.func_72838_d((Entity)entityegg);
            }
            playerIn.func_71029_a(StatList.func_188057_b((Item)this));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack stack, int tintIndex) {
        EntityPlayerSP player;
        if (stack.func_77952_i() == INGREDIENT.BIOME_SENSOR.id && tintIndex == 1 && (player = FMLClientHandler.instance().getClientPlayerEntity()) != null) {
            return ModBlocks.biomeStone.colorMultiplier(null, (IBlockAccess)player.field_70170_p, player.func_180425_c(), 0);
        }
        return -1;
    }

    public static enum INGREDIENT {
        SAKANADE_SPORES("sakanadeSpores"),
        EVIL_TEAR("evilTear"),
        ECTO_PLASM("ectoPlasm"),
        SPECTRE_INGOT("spectreIngot"),
        BIOME_SENSOR("biomeSensor"),
        LUMINOUS_POWDER("luminousPowder"),
        SUPERLUBRICENT_TINCTURE("superLubricentTincture"),
        FLOO_POWDER("flooPowder"),
        PLATE_BASE("plateBase"),
        PRECIOUS_EMERALD("preciousEmerald"),
        LOTUS_BLOSSOM("lotusBlossom"),
        GOLDEN_EGG("goldenEgg"),
        SPECTRE_STRING("spectreString"),
        BLACKOUT_POWDER("blackoutPowder");

        public String name;
        public int id;

        private INGREDIENT(String name) {
            this.name = name;
            this.id = counter++;
        }
    }
}

