/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.money.integration;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.net.MessageDisplayRewardToast;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import com.feed_the_beast.mods.money.FTBMoney;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class MoneyReward
extends QuestReward {
    public static QuestRewardType TYPE;
    public long value = 1L;
    public int randomBonus = 0;

    public MoneyReward(QuestObjectBase parent) {
        super(parent);
    }

    public QuestRewardType getType() {
        return TYPE;
    }

    public void writeData(NBTTagCompound nbt) {
        nbt.func_74772_a("ftb_money", this.value);
        if (this.randomBonus > 0) {
            nbt.func_74768_a("random_bonus", this.randomBonus);
        }
    }

    public void readData(NBTTagCompound nbt) {
        this.value = nbt.func_74763_f("ftb_money");
        this.randomBonus = nbt.func_74762_e("random_bonus");
    }

    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarLong(this.value);
        data.writeVarInt(this.randomBonus);
    }

    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.value = data.readVarLong();
        this.randomBonus = data.readVarInt();
    }

    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", () -> this.value, v -> {
            this.value = v;
        }, 1L, 1L, Long.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbmoney.money", new Object[0]));
        config.addInt("random_bonus", () -> this.randomBonus, v -> {
            this.randomBonus = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.random_bonus", new Object[0]));
    }

    public void claim(EntityPlayerMP player) {
        long added = this.value + (long)player.field_70170_p.field_73012_v.nextInt(this.randomBonus + 1);
        FTBMoney.setMoney((EntityPlayer)player, FTBMoney.getMoney((EntityPlayer)player) + added);
        if (MessageDisplayRewardToast.ENABLED) {
            new MessageDisplayRewardToast(FTBMoney.moneyComponent(added), Icon.getIcon((String)"ftbmoney:textures/beastcoinmini.png")).sendTo(player);
        }
    }

    public ITextComponent getAltDisplayName() {
        if (this.randomBonus > 0) {
            return FTBMoney.moneyComponent(this.value).func_150258_a(" - ").func_150257_a(FTBMoney.moneyComponent(this.value + (long)this.randomBonus));
        }
        return FTBMoney.moneyComponent(this.value);
    }
}

