/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.sensors.flamedetector;

import cassiokf.industrialrenewal.blocks.BlockTileEntity;
import cassiokf.industrialrenewal.tileentity.sensors.flamedetector.TileEntityFlameDetector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFlameDetector
extends BlockTileEntity<TileEntityFlameDetector> {
    public static final IProperty<EnumFacing> FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final IProperty<EnumFacing> BASE = PropertyDirection.func_177714_a((String)"base");

    public BlockFlameDetector(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149711_c(0.8f);
        this.func_180632_j(this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.UP));
    }

    private boolean getActiveness(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityFlameDetector te = (TileEntityFlameDetector)world.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        return te.passRedstone();
    }

    @Nonnull
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityFlameDetector te = (TileEntityFlameDetector)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(this.getActiveness(state, world, pos))).func_177226_a(BASE, (Comparable)te.getBlockFacing());
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return side != state.func_177229_b(FACING);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        boolean active = (Boolean)state.func_185899_b(world, pos).func_177229_b((IProperty)ACTIVE);
        if (!active) {
            return 0;
        }
        return 15;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos neighborPos) {
        IBlockState neighborState = worldIn.func_180495_p(neighborPos);
        Block neighborBlock = neighborState.func_177230_c();
        if (neighborBlock instanceof BlockFire || neighborBlock instanceof BlockAir) {
            worldIn.func_175685_c(pos, (Block)this, true);
        }
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE, BASE});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b(FACING)).func_176745_a();
    }

    @Nonnull
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing theFace = placer.func_70093_af() ? facing : placer.func_174811_aO();
        return this.func_176223_P().func_177226_a(FACING, (Comparable)theFace).func_177226_a(BASE, (Comparable)facing.func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityFlameDetector te = (TileEntityFlameDetector)worldIn.func_175625_s(pos);
        EnumFacing facing = (EnumFacing)state.func_177229_b(BASE);
        te.setBlockFacing(facing);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public Class<TileEntityFlameDetector> getTileEntityClass() {
        return TileEntityFlameDetector.class;
    }

    @Override
    @Nullable
    public TileEntityFlameDetector createTileEntity(World world, IBlockState state) {
        return new TileEntityFlameDetector();
    }
}

