/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.tileentity.recordplayer;

import cassiokf.industrialrenewal.IndustrialRenewal;
import cassiokf.industrialrenewal.blocks.BlockTileEntity;
import cassiokf.industrialrenewal.tileentity.recordplayer.TileEntityRecordPlayer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockNote;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockRecordPlayer
extends BlockTileEntity<TileEntityRecordPlayer> {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool DOWNNOTEBLOCK = PropertyBool.func_177716_a((String)"downnoteblock");
    public static final PropertyBool DISK0 = PropertyBool.func_177716_a((String)"disc0");
    public static final PropertyBool DISK1 = PropertyBool.func_177716_a((String)"disc1");
    public static final PropertyBool DISK2 = PropertyBool.func_177716_a((String)"disc2");
    public static final PropertyBool DISK3 = PropertyBool.func_177716_a((String)"disc3");
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);

    public BlockRecordPlayer(String name, CreativeTabs tab) {
        super(Material.field_151594_q, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)DISK0, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DISK1, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DISK2, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DISK3, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWNNOTEBLOCK, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            this.OpenGUI(world, pos, player);
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityRecordPlayer te = (TileEntityRecordPlayer)world.func_175625_s(pos);
        IItemHandler inventory = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack stack = inventory.getStackInSlot(slot);
            if (stack.func_190926_b()) continue;
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            world.func_72838_d((Entity)item);
        }
        super.func_180663_b(world, pos, state);
    }

    private void OpenGUI(World world, BlockPos pos, EntityPlayer player) {
        player.openGui((Object)IndustrialRenewal.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    private boolean isDownBlockaNoteBlock(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockNote;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityRecordPlayer te = (TileEntityRecordPlayer)world.func_175625_s(pos);
        state = state.func_177226_a((IProperty)DOWNNOTEBLOCK, (Comparable)Boolean.valueOf(this.isDownBlockaNoteBlock(world, pos))).func_177226_a((IProperty)DISK0, (Comparable)Boolean.valueOf(te.hasDiskInSlot(3))).func_177226_a((IProperty)DISK1, (Comparable)Boolean.valueOf(te.hasDiskInSlot(2))).func_177226_a((IProperty)DISK2, (Comparable)Boolean.valueOf(te.hasDiskInSlot(1))).func_177226_a((IProperty)DISK3, (Comparable)Boolean.valueOf(te.hasDiskInSlot(0)));
        return state;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)DOWNNOTEBLOCK, (Comparable)Boolean.valueOf(this.isDownBlockaNoteBlock((IBlockAccess)worldIn, pos)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, DOWNNOTEBLOCK, DISK0, DISK1, DISK2, DISK3});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BASE_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face == EnumFacing.DOWN) {
            return BlockFaceShape.SOLID;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public Class<TileEntityRecordPlayer> getTileEntityClass() {
        return TileEntityRecordPlayer.class;
    }

    @Override
    @Nullable
    public TileEntityRecordPlayer createTileEntity(World world, IBlockState state) {
        return new TileEntityRecordPlayer();
    }
}

