/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.network;

import cassiokf.industrialrenewal.entity.EntitySteamLocomotive;
import cassiokf.industrialrenewal.network.PacketSteamLocomotive;
import io.netty.buffer.ByteBuf;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketReturnSteamLocomotive
implements IMessage {
    private boolean messageValid;
    private int dimension;
    private int id;

    public PacketReturnSteamLocomotive() {
        this.messageValid = false;
    }

    public PacketReturnSteamLocomotive(int dimension, int id) {
        this.dimension = dimension;
        this.id = id;
        this.messageValid = true;
    }

    public PacketReturnSteamLocomotive(EntitySteamLocomotive entity) {
        this(entity.func_130014_f_().field_73011_w.getDimension(), entity.func_145782_y());
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.dimension = buf.readInt();
            this.id = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.out.println(ioe);
            return;
        }
        this.messageValid = true;
    }

    public void toBytes(ByteBuf buf) {
        if (!this.messageValid) {
            return;
        }
        buf.writeInt(this.dimension);
        buf.writeInt(this.id);
    }

    public static class Handler
    implements IMessageHandler<PacketReturnSteamLocomotive, PacketSteamLocomotive> {
        public PacketSteamLocomotive onMessage(PacketReturnSteamLocomotive message, MessageContext ctx) {
            if (!message.messageValid && ctx.side != Side.CLIENT) {
                return null;
            }
            WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimension);
            EntitySteamLocomotive entity = (EntitySteamLocomotive)world.func_73045_a(message.id);
            if (entity != null) {
                return new PacketSteamLocomotive(entity);
            }
            return null;
        }
    }
}

