/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.IRSoundHandler;
import cassiokf.industrialrenewal.blocks.BlockBase;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockElectricGate
extends BlockBase {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyBool INVERTED = PropertyBool.func_177716_a((String)"inverted");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool LEFT = PropertyBool.func_177716_a((String)"left");
    public static final PropertyBool RIGHT = PropertyBool.func_177716_a((String)"right");
    protected static final AxisAlignedBB RNORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB RWEST_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB CNORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.5, 0.625);
    protected static final AxisAlignedBB CWEST_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.5, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(-0.875, 0.0, 0.375, 0.125, 1.5, 0.625);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.875, 0.0, 0.375, 1.875, 1.5, 0.625);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.375, 0.0, 0.875, 0.625, 1.5, 1.875);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.375, 0.0, -0.875, 0.625, 1.5, 0.125);
    protected static final AxisAlignedBB INORTH_AABB = new AxisAlignedBB(0.875, 0.0, 0.375, 1.875, 1.5, 0.625);
    protected static final AxisAlignedBB ISOUTH_AABB = new AxisAlignedBB(-0.875, 0.0, 0.375, 0.125, 1.5, 0.625);
    protected static final AxisAlignedBB IWEST_AABB = new AxisAlignedBB(0.375, 0.0, -0.875, 0.625, 1.5, 0.125);
    protected static final AxisAlignedBB IEAST_AABB = new AxisAlignedBB(0.375, 0.0, 0.875, 0.625, 1.5, 1.875);

    public BlockElectricGate(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149711_c(0.8f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entity, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        IBlockState actualState = state.func_185899_b((IBlockAccess)world, pos);
        boolean active = (Boolean)actualState.func_177229_b((IProperty)ACTIVE) == false;
        this.OpenUpAndDown(world, actualState, pos, active);
        EnumFacing facing = (EnumFacing)actualState.func_177229_b((IProperty)FACING);
        BlockPos rightPos = pos.func_177972_a(facing.func_176746_e());
        BlockPos leftPos = pos.func_177972_a(facing.func_176735_f());
        IBlockState rightState = world.func_180495_p(rightPos);
        IBlockState leftState = world.func_180495_p(leftPos);
        boolean inverted = (Boolean)actualState.func_177229_b((IProperty)INVERTED);
        if (!inverted && rightState.func_177230_c() instanceof BlockElectricGate && ((Boolean)rightState.func_185899_b((IBlockAccess)world, rightPos).func_177229_b((IProperty)INVERTED)).booleanValue()) {
            ((BlockElectricGate)rightState.func_177230_c()).OpenUpAndDown(world, actualState, rightPos, active);
        } else if (inverted && leftState.func_177230_c() instanceof BlockElectricGate && !((Boolean)leftState.func_185899_b((IBlockAccess)world, leftPos).func_177229_b((IProperty)INVERTED)).booleanValue()) {
            ((BlockElectricGate)leftState.func_177230_c()).OpenUpAndDown(world, actualState, leftPos, active);
        }
        Random r = new Random();
        float pitch = r.nextFloat() * 0.20000005f + 0.9f;
        if (active) {
            world.func_184133_a(null, pos, IRSoundHandler.BLOCK_CATWALKGATE_OPEN, SoundCategory.NEUTRAL, 1.0f, pitch);
        } else {
            world.func_184133_a(null, pos, IRSoundHandler.BLOCK_CATWALKGATE_CLOSE, SoundCategory.NEUTRAL, 1.0f, pitch);
        }
        return true;
    }

    public void OpenUpAndDown(World world, IBlockState state, BlockPos pos, boolean active) {
        IBlockState upstate = world.func_180495_p(pos.func_177984_a());
        IBlockState dnstate = world.func_180495_p(pos.func_177977_b());
        Block upb = upstate.func_177230_c();
        Block dnb = dnstate.func_177230_c();
        state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
        world.func_180501_a(pos, state, 3);
        if (upb instanceof BlockElectricGate) {
            upstate = upstate.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
            world.func_180501_a(pos.func_177984_a(), upstate, 3);
        }
        if (dnb instanceof BlockElectricGate) {
            dnstate = dnstate.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
            world.func_180501_a(pos.func_177977_b(), dnstate, 3);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState rightState = world.func_180495_p(pos.func_177972_a(facing.func_176746_e()));
        Block leftBlock = world.func_180495_p(pos.func_177972_a(facing.func_176735_f())).func_177230_c();
        Block rightBlock = rightState.func_177230_c();
        boolean leftIsGate = leftBlock instanceof BlockElectricGate;
        boolean rightIsGate = rightBlock instanceof BlockElectricGate;
        boolean inverted = leftIsGate && !rightIsGate;
        boolean rightInverted = rightIsGate ? (Boolean)rightState.func_185899_b(world, pos.func_177972_a(facing.func_176746_e())).func_177229_b((IProperty)INVERTED) : false;
        Block dnb = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        state = state.func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(dnb instanceof BlockElectricGate)).func_177226_a((IProperty)INVERTED, (Comparable)Boolean.valueOf(inverted)).func_177226_a((IProperty)LEFT, (Comparable)Boolean.valueOf(!inverted)).func_177226_a((IProperty)RIGHT, (Comparable)Boolean.valueOf(!rightInverted));
        return state;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return (Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)ACTIVE);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (face == EnumFacing.NORTH || face == EnumFacing.SOUTH) {
            return RNORTH_AABB;
        }
        return RWEST_AABB;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        boolean active = (Boolean)actualState.func_177229_b((IProperty)ACTIVE);
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean inverted = (Boolean)actualState.func_177229_b((IProperty)INVERTED);
        if (active) {
            if (face == EnumFacing.NORTH) {
                if (inverted) {
                    BlockElectricGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)INORTH_AABB);
                } else {
                    BlockElectricGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
                }
            } else if (face == EnumFacing.SOUTH) {
                if (inverted) {
                    BlockElectricGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)ISOUTH_AABB);
                } else {
                    BlockElectricGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
                }
            } else if (face == EnumFacing.WEST) {
                if (inverted) {
                    BlockElectricGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)IWEST_AABB);
                } else {
                    BlockElectricGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
                }
            } else if (face == EnumFacing.EAST) {
                if (inverted) {
                    BlockElectricGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)IEAST_AABB);
                } else {
                    BlockElectricGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
                }
            }
        } else if (face == EnumFacing.NORTH || face == EnumFacing.SOUTH) {
            BlockElectricGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CNORTH_AABB);
        } else if (face == EnumFacing.WEST || face == EnumFacing.EAST) {
            BlockElectricGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)CWEST_AABB);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE, UP, LEFT, RIGHT, INVERTED});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 4) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

