/*
 * Decompiled with CFR 0.152.
 */
package cassiokf.industrialrenewal.blocks;

import cassiokf.industrialrenewal.blocks.BlockBase;
import cassiokf.industrialrenewal.blocks.ModBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCatwalkStair
extends BlockBase {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool ACTIVE_LEFT = PropertyBool.func_177716_a((String)"active_left");
    public static final PropertyBool ACTIVE_RIGHT = PropertyBool.func_177716_a((String)"active_right");
    protected static final AxisAlignedBB BASE_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.5, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB NC_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 2.0, 0.03125);
    protected static final AxisAlignedBB SC_AABB = new AxisAlignedBB(0.0, 0.0, 0.96875, 1.0, 2.0, 1.0);
    protected static final AxisAlignedBB WC_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.03125, 2.0, 1.0);
    protected static final AxisAlignedBB EC_AABB = new AxisAlignedBB(0.96875, 0.0, 0.0, 1.0, 2.0, 1.0);

    public BlockCatwalkStair(String name, CreativeTabs tab) {
        super(Material.field_151573_f, name, tab);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(0.8f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item playerItem = player.field_71071_by.func_70448_g().func_77973_b();
        if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.catwalkStair)) || playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.catwalkStairSteel))) {
            BlockPos posOffset = pos.func_177972_a(player.func_174811_aO()).func_177984_a();
            IBlockState stateOffset = world.func_180495_p(posOffset);
            if (stateOffset.func_177230_c().isAir(stateOffset, (IBlockAccess)world, posOffset) || stateOffset.func_177230_c().func_176200_f((IBlockAccess)world, posOffset)) {
                world.func_180501_a(posOffset, BlockCatwalkStair.func_149634_a((Item)playerItem).func_176223_P().func_177226_a((IProperty)FACING, (Comparable)player.func_174811_aO()), 3);
                if (!player.func_184812_l_()) {
                    player.field_71071_by.func_174925_a(playerItem, 0, 1, null);
                }
                return true;
            }
            return false;
        }
        if (playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.catWalk)) || playerItem.equals(ItemBlock.func_150898_a((Block)ModBlocks.catWalkSteel))) {
            BlockPos posOffset = pos.func_177972_a(player.func_174811_aO()).func_177984_a();
            IBlockState stateOffset = world.func_180495_p(posOffset);
            if (stateOffset.func_177230_c().isAir(stateOffset, (IBlockAccess)world, posOffset) || stateOffset.func_177230_c().func_176200_f((IBlockAccess)world, posOffset)) {
                world.func_180501_a(posOffset, BlockCatwalkStair.func_149634_a((Item)playerItem).func_176223_P(), 3);
                if (!player.func_184812_l_()) {
                    player.field_71071_by.func_174925_a(playerItem, 0, 1, null);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private Boolean leftConnected(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos posOffset = pos.func_177972_a(face.func_176746_e().func_176734_d());
        IBlockState stateOffset = world.func_180495_p(posOffset);
        Block block = stateOffset.func_177230_c();
        if (block instanceof BlockRail) {
            return !((BlockRailBase.EnumRailDirection)stateOffset.func_177229_b((IProperty)BlockRail.field_176565_b)).toString().equals("ascending_" + face);
        }
        if (block instanceof BlockCatwalkStair) {
            EnumFacing leftFace = (EnumFacing)stateOffset.func_177229_b((IProperty)FACING);
            return leftFace != face;
        }
        return true;
    }

    private Boolean rightConnected(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos posOffset = pos.func_177972_a(face.func_176746_e());
        IBlockState stateOffset = world.func_180495_p(posOffset);
        Block block = stateOffset.func_177230_c();
        if (block instanceof BlockRail) {
            return !((BlockRailBase.EnumRailDirection)stateOffset.func_177229_b((IProperty)BlockRail.field_176565_b)).toString().equals("ascending_" + face);
        }
        if (block instanceof BlockCatwalkStair) {
            EnumFacing rightFace = (EnumFacing)stateOffset.func_177229_b((IProperty)FACING);
            return rightFace != face;
        }
        return true;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_177226_a((IProperty)ACTIVE_LEFT, (Comparable)this.leftConnected(state, world, pos)).func_177226_a((IProperty)ACTIVE_RIGHT, (Comparable)this.rightConnected(state, world, pos));
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE_LEFT, ACTIVE_RIGHT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState actualState = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BASE_AABB);
        EnumFacing face = (EnumFacing)actualState.func_177229_b((IProperty)FACING);
        Boolean left = (Boolean)actualState.func_177229_b((IProperty)ACTIVE_LEFT);
        Boolean right = (Boolean)actualState.func_177229_b((IProperty)ACTIVE_RIGHT);
        if (face == EnumFacing.NORTH) {
            BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_AABB);
            if (left.booleanValue()) {
                BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WC_AABB);
            }
            if (right.booleanValue()) {
                BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EC_AABB);
            }
        }
        if (face == EnumFacing.SOUTH) {
            BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_AABB);
            if (left.booleanValue()) {
                BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EC_AABB);
            }
            if (right.booleanValue()) {
                BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WC_AABB);
            }
        }
        if (face == EnumFacing.WEST) {
            BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_AABB);
            if (left.booleanValue()) {
                BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SC_AABB);
            }
            if (right.booleanValue()) {
                BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NC_AABB);
            }
        }
        if (face == EnumFacing.EAST) {
            BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_AABB);
            if (left.booleanValue()) {
                BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NC_AABB);
            }
            if (right.booleanValue()) {
                BlockCatwalkStair.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SC_AABB);
            }
        }
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

