/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ItemIcon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObject;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.latmod.mods.itemfilters.item.ItemMissing;
import java.io.File;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class QuestObjectBase {
    public static final Predicate<? super QuestObjectBase> PREDICATE_INVALID = o -> o == null || o.invalid;
    public int id = 0;
    public boolean invalid = false;
    public String title = "";
    public ItemStack icon = ItemStack.field_190927_a;
    private Icon cachedIcon = null;
    private ITextComponent cachedDisplayName = null;

    public final String toString() {
        return String.format("#%08x", this.id);
    }

    public final String getCodeString() {
        return String.format("%08x", this.id);
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return this.id;
    }

    public abstract QuestObjectType getObjectType();

    public abstract QuestFile getQuestFile();

    @Nullable
    public QuestChapter getQuestChapter() {
        return null;
    }

    public int getParentID() {
        return 0;
    }

    public void writeData(NBTTagCompound nbt) {
        if (!this.title.isEmpty()) {
            nbt.func_74778_a("title", this.title);
        }
        if (!this.icon.func_190926_b()) {
            nbt.func_74782_a("icon", ItemMissing.write((ItemStack)this.icon, (boolean)false));
        }
    }

    public void readData(NBTTagCompound nbt) {
        this.title = nbt.func_74779_i("title");
        this.icon = ItemMissing.read((NBTBase)nbt.func_74781_a("icon"));
    }

    public void writeNetData(DataOut data) {
        data.writeString(this.title);
        data.writeItemStack(this.icon);
    }

    public void readNetData(DataIn data) {
        this.title = data.readString();
        this.icon = data.readItemStack();
    }

    public void getConfig(ConfigGroup config) {
        config.addString("title", () -> this.title, v -> {
            this.title = v;
        }, "").setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.title", new Object[0])).setOrder(-127);
        config.add("icon", (ConfigValue)new ConfigItemStack.SimpleStack(() -> this.icon, v -> {
            this.icon = v;
        }), (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a)).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.icon", new Object[0])).setOrder(-126);
    }

    public abstract Icon getAltIcon();

    public abstract ITextComponent getAltDisplayName();

    public final Icon getIcon() {
        if (this.cachedIcon == null) {
            this.cachedIcon = !this.icon.func_190926_b() ? ItemIcon.getItemIcon((ItemStack)this.icon) : this.getAltIcon();
        }
        return this.cachedIcon;
    }

    public final ITextComponent getDisplayName() {
        if (this.cachedDisplayName != null) {
            return this.cachedDisplayName;
        }
        this.cachedDisplayName = !this.title.isEmpty() ? (this.title.startsWith("{") && this.title.endsWith("}") ? new TextComponentTranslation(this.title.substring(1, this.title.length() - 1), new Object[0]) : new TextComponentString(this.title)) : this.getAltDisplayName();
        return this.cachedDisplayName;
    }

    public final ITextComponent getYellowDisplayName() {
        ITextComponent component = this.getDisplayName().func_150259_f();
        component.func_150256_b().func_150238_a(TextFormatting.YELLOW);
        return component;
    }

    public void deleteSelf() {
        this.getQuestFile().remove(this.id);
    }

    public void deleteChildren() {
    }

    @SideOnly(value=Side.CLIENT)
    public void editedFromGUI() {
        ClientQuestFile.INSTANCE.refreshGui();
    }

    public void onCreated() {
    }

    @Nullable
    public File getFile(File folder) {
        return null;
    }

    public void clearCachedData() {
        this.cachedIcon = null;
        this.cachedDisplayName = null;
    }

    public ConfigGroup createSubGroup(ConfigGroup group) {
        return group.getGroup(this.getObjectType().func_176610_l());
    }

    @SideOnly(value=Side.CLIENT)
    public void onEditButtonClicked() {
        new MessageEditObject(this.id).sendToServer();
    }

    public int refreshJEI() {
        return 0;
    }
}

