/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class ButtonReward
extends SimpleTextButton {
    public final QuestReward reward;

    public ButtonReward(Panel panel, QuestReward r) {
        super(panel, r.getDisplayName().func_150254_d(), r.getIcon());
        this.reward = r;
    }

    public String getTitle() {
        if (this.reward.isTeamReward()) {
            return TextFormatting.BLUE + super.getTitle();
        }
        return super.getTitle();
    }

    public void addMouseOverText(List<String> list) {
        if (ButtonReward.isShiftKeyDown() && ButtonReward.isCtrlKeyDown()) {
            list.add(TextFormatting.DARK_GRAY + this.reward.toString());
        }
        if (this.reward.isTeamReward()) {
            list.add(TextFormatting.BLUE + "[" + I18n.func_135052_a((String)"ftbquests.reward.team_reward", (Object[])new Object[0]) + "]");
        }
        this.reward.addMouseOverText(list);
    }

    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            if (button.isRight() || this.getWidgetType() != WidgetType.DISABLED) {
                this.onClicked(button);
            }
            return true;
        }
        return false;
    }

    public WidgetType getWidgetType() {
        if (!(ClientQuestFile.existsWithTeam() && this.reward.parent instanceof QuestObject && ((QuestObject)this.reward.parent).isComplete(ClientQuestFile.INSTANCE.self))) {
            return WidgetType.DISABLED;
        }
        return super.getWidgetType();
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (ClientQuestFile.existsWithTeam() && this.reward.parent instanceof QuestObject && ((QuestObject)this.reward.parent).isComplete(ClientQuestFile.INSTANCE.self) && !ClientQuestFile.INSTANCE.isRewardClaimed(this.reward)) {
                GuiHelper.playClickSound();
                this.reward.onButtonClicked();
            }
        } else if (button.isRight() && ClientQuestFile.exists() && ClientQuestFile.INSTANCE.canEdit()) {
            GuiHelper.playClickSound();
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            GuiQuestTree.addObjectMenuItems(contextMenu, (IOpenableGui)this.getGui(), this.reward);
            this.getGui().openContextMenu(contextMenu);
        }
    }

    @Nullable
    public Object getJEIFocus() {
        return this.reward.getJEIFocus();
    }

    public void draw(Theme theme, int x, int y, int w, int h) {
        super.draw(theme, x, y, w, h);
        if (!ClientQuestFile.existsWithTeam()) {
            GuiIcons.CLOSE.draw(x + w - 9, y + 1, 8, 8);
        } else if (ClientQuestFile.INSTANCE.isRewardClaimed(this.reward)) {
            FTBQuestsTheme.COMPLETED.draw(x + w - 9, y + 1, 8, 8);
        } else if (this.reward.parent instanceof QuestObject && ((QuestObject)this.reward.parent).isComplete(ClientQuestFile.INSTANCE.self)) {
            FTBQuestsTheme.ALERT.draw(x + w - 9, y + 1, 8, 8);
        }
    }
}

