/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestVariable;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiSelectQuestObject
extends GuiButtonListBase {
    private final ConfigQuestObject config;
    private final IOpenableGui callbackGui;
    private final Runnable callback;

    public GuiSelectQuestObject(ConfigQuestObject c, IOpenableGui g, Runnable cb) {
        StringBuilder builder = new StringBuilder(I18n.func_135052_a((String)"ftbquests.gui.select_quest_object", (Object[])new Object[0]));
        builder.append(" [");
        boolean first = true;
        for (QuestObjectType type : c.getTypes()) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(I18n.func_135052_a((String)type.getTranslationKey(), (Object[])new Object[0]));
        }
        builder.append(']');
        this.setTitle(builder.toString());
        this.setHasSearchBox(true);
        this.setBorder(1, 1, 1);
        this.config = c;
        this.callbackGui = g;
        this.callback = cb;
    }

    public void addButtons(Panel panel) {
        if (this.config.isValid(QuestObjectType.NULL)) {
            panel.add((Widget)new ButtonQuestObject(panel, null));
        }
        if (this.config.isValid(QuestObjectType.FILE)) {
            panel.add((Widget)new ButtonQuestObject(panel, ClientQuestFile.INSTANCE));
        }
        if (this.config.isValid(QuestObjectType.VARIABLE)) {
            for (QuestVariable variable : ClientQuestFile.INSTANCE.variables) {
                panel.add((Widget)new ButtonQuestObject(panel, variable));
            }
        }
        if (this.config.isValid(QuestObjectType.REWARD_TABLE)) {
            for (RewardTable table : ClientQuestFile.INSTANCE.rewardTables) {
                panel.add((Widget)new ButtonQuestObject(panel, table));
            }
        }
        boolean addChapters = this.config.isValid(QuestObjectType.CHAPTER);
        boolean addQuests = this.config.isValid(QuestObjectType.QUEST);
        boolean addTasks = this.config.isValid(QuestObjectType.TASK);
        boolean addRewards = this.config.isValid(QuestObjectType.REWARD);
        for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
            if (addChapters) {
                panel.add((Widget)new ButtonQuestObject(panel, chapter));
            }
            for (Quest quest : chapter.quests) {
                if (addQuests) {
                    panel.add((Widget)new ButtonQuestObject(panel, quest));
                }
                if (addTasks) {
                    for (QuestTask task : quest.tasks) {
                        panel.add((Widget)new ButtonQuestObject(panel, task));
                    }
                }
                if (!addRewards) continue;
                for (QuestReward reward : quest.rewards) {
                    panel.add((Widget)new ButtonQuestObject(panel, reward));
                }
            }
        }
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public class ButtonQuestObject
    extends SimpleTextButton {
        public final QuestObjectBase object;

        public ButtonQuestObject(@Nullable Panel panel, QuestObjectBase o) {
            super(panel, o == null ? I18n.func_135052_a((String)"ftbquests.null", (Object[])new Object[0]) : o.getObjectType().getColor() + o.getDisplayName().func_150260_c(), (Icon)(o == null ? Icon.EMPTY : o.getIcon()));
            this.object = o;
            this.setSize(200, 14);
        }

        public void addMouseOverText(List<String> list) {
            if (this.object == null) {
                return;
            }
            list.add(this.object.getDisplayName().func_150254_d());
            list.add(TextFormatting.GRAY + "ID: " + TextFormatting.DARK_GRAY + this.object);
            list.add(TextFormatting.GRAY + "Type: " + this.object.getObjectType().getColor() + I18n.func_135052_a((String)this.object.getObjectType().getTranslationKey(), (Object[])new Object[0]));
            if (this.object instanceof Quest) {
                Quest quest = (Quest)this.object;
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.chapter", (Object[])new Object[0]) + ": " + QuestObjectType.CHAPTER.getColor() + quest.chapter.getDisplayName().func_150260_c());
                if (quest.rewards.size() == 1) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.reward", (Object[])new Object[0]) + ": " + QuestObjectType.REWARD.getColor() + quest.rewards.get(0).getDisplayName().func_150260_c());
                } else if (!quest.rewards.isEmpty()) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]));
                    for (QuestReward reward : quest.rewards) {
                        list.add("  " + QuestObjectType.REWARD.getColor() + reward.getDisplayName().func_150260_c());
                    }
                }
            } else if (this.object instanceof QuestTask) {
                Quest quest = ((QuestTask)this.object).quest;
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.chapter", (Object[])new Object[0]) + ": " + QuestObjectType.CHAPTER.getColor() + quest.chapter.getDisplayName().func_150260_c());
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.quest", (Object[])new Object[0]) + ": " + QuestObjectType.QUEST.getColor() + quest.getDisplayName().func_150260_c());
                if (quest.rewards.size() == 1) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.reward", (Object[])new Object[0]) + ": " + QuestObjectType.REWARD.getColor() + quest.rewards.get(0).getDisplayName().func_150260_c());
                } else if (!quest.rewards.isEmpty()) {
                    list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.rewards", (Object[])new Object[0]));
                    for (QuestReward reward : quest.rewards) {
                        list.add("  " + QuestObjectType.REWARD.getColor() + reward.getDisplayName().func_150260_c());
                    }
                }
            } else if (this.object instanceof RewardTable) {
                ((RewardTable)this.object).addMouseOverText(list, true, true);
            }
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            GuiSelectQuestObject.this.callbackGui.openGui();
            GuiSelectQuestObject.this.config.setObject(this.object);
            GuiSelectQuestObject.this.callback.run();
        }
    }
}

