/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.flux.FluxNetworks;
import sonar.flux.api.IFluxItemGui;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.PacketNetworkUpdate;
import sonar.flux.network.PacketUpdateGuiItem;

public class PacketFluxItemNetwork
implements IMessage {
    public int networkID;

    public PacketFluxItemNetwork() {
    }

    public PacketFluxItemNetwork(int networkID) {
        this.networkID = networkID;
    }

    public void fromBytes(ByteBuf buf) {
        this.networkID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.networkID);
    }

    public static class Handler
    implements IMessageHandler<PacketFluxItemNetwork, IMessage> {
        public IMessage onMessage(PacketFluxItemNetwork message, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                IFluxNetwork network;
                EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                ItemStack heldItem = player.func_184586_b(player.func_184600_cs());
                if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof IFluxItemGui && !(network = FluxNetworkCache.instance().getNetwork(message.networkID)).isFakeNetwork()) {
                    ((IFluxItemGui)heldItem.func_77973_b()).setViewingNetworkID(heldItem, message.networkID);
                    FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SAVE, false), (EntityPlayerMP)player);
                    FluxNetworks.network.sendTo((IMessage)new PacketUpdateGuiItem(heldItem), (EntityPlayerMP)player);
                }
            });
            return null;
        }
    }
}

