/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.flux.FluxNetworks;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.PacketConnectionsClientList;

public class PacketConnectionsRefresh
implements IMessage {
    public int networkID;

    public PacketConnectionsRefresh() {
    }

    public PacketConnectionsRefresh(int networkID) {
        this.networkID = networkID;
    }

    public void fromBytes(ByteBuf buf) {
        this.networkID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.networkID);
    }

    public static class Handler
    implements IMessageHandler<PacketConnectionsRefresh, IMessage> {
        public IMessage onMessage(PacketConnectionsRefresh message, MessageContext ctx) {
            IFluxNetwork network = FluxNetworks.getServerCache().getNetwork(message.networkID);
            if (!network.isFakeNetwork()) {
                network.getSyncSetting(NetworkSettings.UNLOADED_CONNECTIONS).setDirty(false);
                return new PacketConnectionsClientList(network);
            }
            return null;
        }
    }
}

