/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.connection.transfer.handlers;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.util.EnumFacing;
import sonar.core.api.energy.EnergyType;
import sonar.core.api.utils.ActionType;
import sonar.flux.api.energy.internal.IEnergyTransfer;
import sonar.flux.api.energy.internal.IFluxTransfer;
import sonar.flux.api.energy.internal.ITransferHandler;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.connection.transfer.handlers.FluxTransferHandler;

public class SingleTransferHandler
extends FluxTransferHandler
implements ITransferHandler {
    public final IEnergyTransfer transfer;

    public SingleTransferHandler(IFlux flux, IEnergyTransfer transfer) {
        super(flux);
        this.transfer = transfer;
    }

    @Override
    public long addToNetwork(long maxTransferRF, EnergyType energyType, ActionType actionType) {
        if (this.flux.isActive() && this.getNetwork().canConvert(energyType, this.getNetwork().getSetting(NetworkSettings.NETWORK_ENERGY_TYPE))) {
            long add = this.transfer.addToNetworkWithConvert(this.getValidAddition(maxTransferRF, energyType), energyType, actionType);
            if (!actionType.shouldSimulate()) {
                this.added += add;
            }
            return add;
        }
        return 0L;
    }

    @Override
    public long removeFromNetwork(long maxTransferRF, EnergyType energyType, ActionType actionType) {
        if (this.flux.isActive() && this.getNetwork().canConvert(energyType, this.getNetwork().getSetting(NetworkSettings.NETWORK_ENERGY_TYPE))) {
            long remove = this.transfer.removeFromNetworkWithConvert(this.getValidRemoval(maxTransferRF, energyType), energyType, actionType);
            if (!actionType.shouldSimulate()) {
                this.removed += remove;
            }
            return remove;
        }
        return 0L;
    }

    @Override
    public boolean hasTransfers() {
        return true;
    }

    @Override
    public void updateTransfers(EnumFacing ... faces) {
    }

    @Override
    public List<IFluxTransfer> getTransfers() {
        return Lists.newArrayList((Object[])new IFluxTransfer[]{this.transfer});
    }
}

