/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api;

import java.util.List;
import sonar.core.helpers.SonarHelper;
import sonar.core.translate.Localisation;
import sonar.core.utils.SortingDirection;
import sonar.flux.FluxTranslate;
import sonar.flux.api.ClientFlux;
import sonar.flux.api.tiles.IFlux;

public enum SortingType {
    PRIORITY(FluxTranslate.PRIORITY),
    TRANSFER(FluxTranslate.SORTING_TRANSFER),
    TRANSFER_LIMIT(FluxTranslate.TRANSFER_LIMIT),
    DIMENSION_NO(FluxTranslate.SORTING_DIMENSION),
    CONNECTION_TYPE(FluxTranslate.SORTING_TYPE),
    CONNECTION_NAME(FluxTranslate.SORTING_NAME);

    Localisation message;

    private SortingType(Localisation message) {
        this.message = message;
    }

    public String getDisplayName() {
        return this.message.t();
    }

    public void sort(List<ClientFlux> list, SortingDirection dir) {
        SortingDirection actual_dir = dir.switchDir();
        switch (this) {
            case CONNECTION_NAME: {
                list.sort((flux1, flux2) -> SonarHelper.compareStringsWithDirection((String)flux1.getCustomName(), (String)flux2.getCustomName(), (SortingDirection)actual_dir));
                break;
            }
            case CONNECTION_TYPE: {
                list.sort((flux1, flux2) -> SonarHelper.compareStringsWithDirection((String)flux1.getConnectionType().getRepresentiveStack().func_82833_r(), (String)flux2.getConnectionType().getRepresentiveStack().func_82833_r(), (SortingDirection)actual_dir));
                break;
            }
            case DIMENSION_NO: {
                list.sort((flux1, flux2) -> SonarHelper.compareWithDirection((long)flux1.getCoords().getDimension(), (long)flux2.getCoords().getDimension(), (SortingDirection)actual_dir));
                break;
            }
            case PRIORITY: {
                list.sort((flux1, flux2) -> SonarHelper.compareWithDirection((long)flux1.getCurrentPriority(), (long)flux2.getCurrentPriority(), (SortingDirection)actual_dir));
                break;
            }
            case TRANSFER: {
                list.sort((flux1, flux2) -> {
                    long transfer1 = flux1.getTransferHandler().getAdded() - flux1.getTransferHandler().getRemoved();
                    long transfer2 = flux2.getTransferHandler().getAdded() - flux2.getTransferHandler().getRemoved();
                    if (flux1.getConnectionType() == IFlux.ConnectionType.STORAGE) {
                        transfer1 = -transfer1;
                    }
                    if (flux2.getConnectionType() == IFlux.ConnectionType.STORAGE) {
                        transfer2 = -transfer2;
                    }
                    return SonarHelper.compareWithDirection((long)transfer1, (long)transfer2, (SortingDirection)actual_dir);
                });
                break;
            }
            case TRANSFER_LIMIT: {
                list.sort((flux1, flux2) -> SonarHelper.compareWithDirection((long)flux1.getCurrentLimit(), (long)flux2.getCurrentLimit(), (SortingDirection)actual_dir));
                break;
            }
        }
    }
}

