/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.mods.projectex.integration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.playerData.Transmutation;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class OfflineKnowledgeProvider
implements IKnowledgeProvider {
    public final UUID playerId;
    private final List<ItemStack> knowledge;
    private final IItemHandlerModifiable inputLocks;
    private double emc;
    private boolean fullKnowledge;
    public boolean shouldSave;

    public static void copy(IKnowledgeProvider from, IKnowledgeProvider to) {
        to.deserializeNBT(from.serializeNBT());
    }

    public OfflineKnowledgeProvider(UUID id) {
        this.playerId = id;
        this.knowledge = new ArrayList<ItemStack>();
        this.inputLocks = new ItemStackHandler(9);
        this.emc = 0.0;
        this.fullKnowledge = false;
        this.shouldSave = false;
    }

    public boolean hasFullKnowledge() {
        return this.fullKnowledge;
    }

    public void setFullKnowledge(boolean b) {
        this.fullKnowledge = b;
        this.shouldSave = true;
    }

    public void clearKnowledge() {
        this.knowledge.clear();
        this.fullKnowledge = false;
        this.shouldSave = true;
    }

    public boolean hasKnowledge(ItemStack stack) {
        ItemStack s;
        if (stack.func_190926_b()) {
            return false;
        }
        if (this.fullKnowledge) {
            return true;
        }
        Iterator<ItemStack> var2 = this.knowledge.iterator();
        do {
            if (var2.hasNext()) continue;
            return false;
        } while (!ItemHelper.basicAreStacksEqual((ItemStack)(s = var2.next()), (ItemStack)stack));
        return true;
    }

    public boolean addKnowledge(ItemStack stack) {
        if (this.fullKnowledge) {
            return false;
        }
        if (stack.func_77973_b() == ObjHandler.tome) {
            if (!this.hasKnowledge(stack)) {
                this.knowledge.add(stack);
            }
            this.fullKnowledge = true;
            this.shouldSave = true;
            return true;
        }
        if (!this.hasKnowledge(stack)) {
            this.knowledge.add(stack);
            this.shouldSave = true;
            return true;
        }
        return false;
    }

    public boolean removeKnowledge(ItemStack stack) {
        boolean removed = false;
        if (stack.func_77973_b() == ObjHandler.tome) {
            this.fullKnowledge = false;
            removed = true;
        }
        if (this.fullKnowledge) {
            return false;
        }
        Iterator<ItemStack> iter = this.knowledge.iterator();
        while (iter.hasNext()) {
            if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)iter.next())) continue;
            iter.remove();
            removed = true;
        }
        if (removed) {
            this.shouldSave = true;
        }
        return removed;
    }

    public List<ItemStack> getKnowledge() {
        return this.fullKnowledge ? Transmutation.getCachedTomeKnowledge() : Collections.unmodifiableList(this.knowledge);
    }

    public IItemHandlerModifiable getInputAndLocks() {
        return this.inputLocks;
    }

    public double getEmc() {
        return this.emc;
    }

    public void setEmc(double e) {
        this.emc = e;
        this.shouldSave = true;
    }

    public void sync(EntityPlayerMP player) {
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74780_a("transmutationEmc", this.emc);
        NBTTagList knowledgeWrite = new NBTTagList();
        for (ItemStack is : this.knowledge) {
            knowledgeWrite.func_74742_a((NBTBase)is.serializeNBT());
        }
        nbt.func_74782_a("knowledge", (NBTBase)knowledgeWrite);
        nbt.func_74782_a("inputlock", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inputLocks, null));
        nbt.func_74757_a("fullknowledge", this.fullKnowledge);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int i;
        this.emc = nbt.func_74769_h("transmutationEmc");
        NBTTagList list = nbt.func_150295_c("knowledge", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = new ItemStack(list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            this.knowledge.add(stack);
        }
        this.pruneStaleKnowledge();
        this.pruneDuplicateKnowledge();
        for (i = 0; i < this.inputLocks.getSlots(); ++i) {
            this.inputLocks.setStackInSlot(i, ItemStack.field_190927_a);
        }
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inputLocks, null, (NBTBase)nbt.func_150295_c("inputlock", 10));
        this.fullKnowledge = nbt.func_74767_n("fullknowledge");
    }

    private void pruneDuplicateKnowledge() {
        ItemHelper.compactItemListNoStacksize(this.knowledge);
        for (ItemStack is : this.knowledge) {
            if (is.func_190916_E() <= 1) continue;
            is.func_190920_e(1);
        }
    }

    private void pruneStaleKnowledge() {
        this.knowledge.removeIf(stack -> !EMCHelper.doesItemHaveEmc((ItemStack)stack));
    }
}

