/*
 * Decompiled with CFR 0.152.
 */
package mod.flatcoloredblocks.block;

import mod.flatcoloredblocks.block.EnumFlatBlockType;
import mod.flatcoloredblocks.config.ModConfig;

public class BlockHSVConfiguration {
    public static final int META_SCALE = 16;
    public int MAX_SHADE_HUE;
    public int MAX_SHADE_SATURATION;
    public int MAX_SHADE_VALUE;
    public int MAX_SHADE_VARIANT;
    public double SATURATION_EXPONENT;
    public double SATURATION_MIN;
    public double SATURATION_MAX;
    public double HUE_EXPONENT;
    public double HUE_MIN;
    public double HUE_MAX;
    public double VALUE_EXPONENT;
    public double VALUE_MIN;
    public double VALUE_MAX;
    public double VARIANT_EXPONENT;
    public double VARIANT_MIN;
    public double VARIANT_MAX;
    public final int MAX_SHADE_HUE_MINUS_ONE;
    public final int MAX_SHADE_SATURATION_MINUS_ONE;
    public final int MAX_SHADE_VALUE_MINUS_ONE;
    public final int MAX_SHADE_VARIANT_MINUS_ONE;
    public final int MAX_SHADES;
    public final int META_SCALE_MINUS_ONE;
    public final int MAX_SHADE_BLOCKS;
    public final int MAX_SHADES_MINUS_ONE;
    public final int finalShades;
    public final int[] shadeConvertHue;
    public final int[] shadeConvertSat;
    public final int[] shadeConvertValue;
    public final int[] shadeConvertVariant;
    public final EnumFlatBlockType type;

    public BlockHSVConfiguration(EnumFlatBlockType type, ModConfig config) {
        double p;
        int x;
        this.type = type;
        this.populateFromConfig(config, type);
        this.MAX_SHADE_HUE_MINUS_ONE = this.MAX_SHADE_HUE - 1;
        this.MAX_SHADE_SATURATION_MINUS_ONE = this.MAX_SHADE_SATURATION - 1;
        this.MAX_SHADE_VALUE_MINUS_ONE = this.MAX_SHADE_VALUE - 1;
        this.MAX_SHADE_VARIANT_MINUS_ONE = this.MAX_SHADE_VARIANT - 1;
        this.MAX_SHADES = this.MAX_SHADE_HUE * this.MAX_SHADE_SATURATION * this.MAX_SHADE_VALUE + this.MAX_SHADE_VALUE;
        this.META_SCALE_MINUS_ONE = 15;
        this.MAX_SHADE_BLOCKS = (this.MAX_SHADES + this.META_SCALE_MINUS_ONE) / 16;
        this.MAX_SHADES_MINUS_ONE = this.MAX_SHADES - 1;
        this.finalShades = this.MAX_SHADES - this.MAX_SHADE_VALUE;
        this.shadeConvertHue = new int[this.MAX_SHADE_HUE];
        this.shadeConvertSat = new int[this.MAX_SHADE_SATURATION];
        this.shadeConvertValue = new int[this.MAX_SHADE_VALUE];
        this.shadeConvertVariant = new int[this.MAX_SHADE_VARIANT];
        for (x = 0; x < this.MAX_SHADE_HUE; ++x) {
            p = (double)x / (double)this.MAX_SHADE_HUE_MINUS_ONE;
            this.shadeConvertHue[x] = BlockHSVConfiguration.adjustRange(p, this.HUE_EXPONENT, this.HUE_MIN, this.HUE_MAX);
        }
        for (x = 0; x < this.MAX_SHADE_VALUE; ++x) {
            p = (double)x / (double)this.MAX_SHADE_VALUE_MINUS_ONE;
            this.shadeConvertValue[x] = BlockHSVConfiguration.adjustRange(p, this.VALUE_EXPONENT, this.VALUE_MIN, this.VALUE_MAX);
        }
        for (x = 0; x < this.MAX_SHADE_SATURATION; ++x) {
            p = (double)x / (double)this.MAX_SHADE_SATURATION_MINUS_ONE;
            this.shadeConvertSat[x] = BlockHSVConfiguration.adjustRange(p, this.SATURATION_EXPONENT, this.SATURATION_MIN, this.SATURATION_MAX);
        }
        for (x = 0; x < this.MAX_SHADE_VARIANT; ++x) {
            p = (double)x / (double)this.MAX_SHADE_VARIANT_MINUS_ONE;
            this.shadeConvertVariant[x] = BlockHSVConfiguration.adjustRange(p, this.VARIANT_EXPONENT, this.VARIANT_MIN, this.VARIANT_MAX);
        }
    }

    private static int adjustRange(double value, double exponent, double min, double max) {
        if (Double.isInfinite(value = Math.min(1.0, Math.max(0.0, value))) || Double.isNaN(value)) {
            value = 0.0;
        }
        value = Math.pow(value, exponent);
        value = value * max + min * (1.0 - value);
        return Math.min(255, Math.max(0, (int)(255.0 * value)));
    }

    protected void populateFromConfig(ModConfig config, EnumFlatBlockType type) {
        switch (type) {
            case NORMAL: {
                this.MAX_SHADE_HUE = config.HUE_SHADES;
                this.MAX_SHADE_SATURATION = config.SATURATION_SHADES;
                this.MAX_SHADE_VALUE = config.VALUE_SHADES;
                this.MAX_SHADE_VARIANT = 1;
                this.SATURATION_EXPONENT = config.SATURATION_RANGE_EXPONENT;
                this.SATURATION_MIN = config.SATURATION_MIN;
                this.SATURATION_MAX = config.SATURATION_MAX;
                this.HUE_EXPONENT = config.HUE_RANGE_EXPONENT;
                this.HUE_MIN = config.HUE_MIN;
                this.HUE_MAX = config.HUE_MAX;
                this.VALUE_EXPONENT = config.VALUE_RANGE_EXPONENT;
                this.VALUE_MIN = config.VALUE_MIN;
                this.VALUE_MAX = config.VALUE_MAX;
                this.VARIANT_EXPONENT = 1.0;
                this.VARIANT_MIN = 1.0;
                this.VARIANT_MAX = 1.0;
                break;
            }
            case GLOWING: {
                this.MAX_SHADE_HUE = config.HUE_SHADES_GLOWING;
                this.MAX_SHADE_SATURATION = config.SATURATION_SHADES_GLOWING;
                this.MAX_SHADE_VALUE = config.VALUE_SHADES_GLOWING;
                this.MAX_SHADE_VARIANT = config.GLOWING_SHADES;
                this.SATURATION_EXPONENT = config.SATURATION_RANGE_EXPONENT_GLOWING;
                this.SATURATION_MIN = config.SATURATION_MIN_GLOWING;
                this.SATURATION_MAX = config.SATURATION_MAX_GLOWING;
                this.HUE_EXPONENT = config.HUE_RANGE_EXPONENT_GLOWING;
                this.HUE_MIN = config.HUE_MIN_GLOWING;
                this.HUE_MAX = config.HUE_MAX_GLOWING;
                this.VALUE_EXPONENT = config.VALUE_RANGE_EXPONENT_GLOWING;
                this.VALUE_MIN = config.VALUE_MIN_GLOWING;
                this.VALUE_MAX = config.VALUE_MAX_GLOWING;
                this.VARIANT_EXPONENT = config.GLOWING_RANGE_EXPONENT;
                this.VARIANT_MIN = config.GLOWING_MIN;
                this.VARIANT_MAX = config.GLOWING_MAX;
                break;
            }
            case TRANSPARENT: {
                this.MAX_SHADE_HUE = config.HUE_SHADES_TRANSPARENT;
                this.MAX_SHADE_SATURATION = config.SATURATION_SHADES_TRANSPARENT;
                this.MAX_SHADE_VALUE = config.VALUE_SHADES_TRANSPARENT;
                this.MAX_SHADE_VARIANT = config.TRANSPARENCY_SHADES;
                this.SATURATION_EXPONENT = config.SATURATION_RANGE_EXPONENT_TRANSPARENT;
                this.SATURATION_MIN = config.SATURATION_MIN_TRANSPARENT;
                this.SATURATION_MAX = config.SATURATION_MAX_TRANSPARENT;
                this.HUE_EXPONENT = config.HUE_RANGE_EXPONENT_TRANSPARENT;
                this.HUE_MIN = config.HUE_MIN_TRANSPARENT;
                this.HUE_MAX = config.HUE_MAX_TRANSPARENT;
                this.VALUE_EXPONENT = config.VALUE_RANGE_EXPONENT_TRANSPARENT;
                this.VALUE_MIN = config.VALUE_MIN_TRANSPARENT;
                this.VALUE_MAX = config.VALUE_MAX_TRANSPARENT;
                this.VARIANT_EXPONENT = config.TRANSPARENCY_RANGE_EXPONENT;
                this.VARIANT_MIN = config.TRANSPARENCY_MIN;
                this.VARIANT_MAX = config.TRANSPARENCY_MAX;
            }
        }
    }

    public int hsvFromNumber(int shadeNum) {
        int v = 0;
        int s = 0;
        int h = 0;
        if (shadeNum >= this.finalShades) {
            v = (shadeNum - this.finalShades) % this.MAX_SHADE_VALUE;
            s = 0;
            h = 0;
        } else {
            v = shadeNum % this.MAX_SHADE_VALUE;
            shadeNum -= v;
            s = (shadeNum /= this.MAX_SHADE_VALUE) % this.MAX_SHADE_SATURATION;
            shadeNum -= s;
            h = (shadeNum /= this.MAX_SHADE_SATURATION) % this.MAX_SHADE_HUE;
        }
        v = this.shadeConvertValue[v];
        s = shadeNum >= this.finalShades ? 0 : this.shadeConvertSat[s];
        h = this.shadeConvertHue[h];
        return BlockHSVConfiguration.combine(h, s, v);
    }

    private static int combine(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }

    public int getNumberOfShades() {
        return this.MAX_SHADES;
    }

    public int getNumberOfBlocks() {
        return this.MAX_SHADE_BLOCKS;
    }

    public String getBlockName(int varientNum) {
        if (this.type == EnumFlatBlockType.NORMAL) {
            return this.type.blockName;
        }
        return this.type.blockName + varientNum + "_";
    }
}

