import crafttweaker.item.IItemStack;
import crafttweaker.item.IIngredient;
import mods.artisanworktables.builder.RecipeBuilder;
import mods.gregtech.recipe.RecipeMap;

print("------------------Misc Start---------------");

	#Books
recipes.remove(<actuallyadditions:item_booklet>);
recipes.remove(<botania:lexicon>);
recipes.remove(<cookingforblockheads:recipe_book>);
furnace.remove(<cookingforblockheads:recipe_book:1>);
furnace.remove(<cookingforblockheads:recipe_book:2>);
recipes.remove(<extrautils2:book>);
recipes.remove(<ftbquests:book>);
recipes.remove(<guideapi:bloodmagic-guide>);
recipes.remove(<guideapi:cyclicmagic-guide>);
recipes.remove(<industrialforegoing:book_manual>);
recipes.remove(<patchouli:guide_book>.withTag({"patchouli:book": "deepmoblearning:book"}));
recipes.remove(<projecte:item.pe_manual>);
recipes.remove(<rftools:rftools_manual>);
recipes.remove(<rftools:rftools_shape_manual>);
recipes.remove(<rustic:book>);
recipes.remove(<openblocks:info_book>);
recipes.remove(<tconstruct:book>);
recipes.remove(<spiceoflife:bookfoodjournal>);
recipes.remove(<wizardry:book>);
recipes.remove(<integrateddynamics:on_the_dynamics_of_integration>);

var books as IItemStack[] = [
	<actuallyadditions:item_booklet>,

	<botania:lexicon>.withTag({"knowledge.minecraft": 1 as byte, "knowledge.alfheim": 1 as byte, "knowledge.relic": 1 as byte}),

	<cookingforblockheads:recipe_book>,
	<cookingforblockheads:recipe_book:1>,
	<cookingforblockheads:recipe_book:2>,

	<extrautils2:book>,
	<ftbquests:book>,
	
	<guideapi:bloodmagic-guide>,
	<guideapi:cyclicmagic-guide>,

	<industrialforegoing:book_manual>,

	<integrateddynamics:on_the_dynamics_of_integration>,

	<minecraft:book>,

	<patchouli:guide_book>.withTag({"patchouli:book": "deepmoblearning:book"}),
	
	<projecte:item.pe_manual>,

	<rftools:rftools_manual>,
	<rftools:rftools_shape_manual>,

	<rustic:book>,

	<tconstruct:book>,
	<spiceoflife:bookfoodjournal>,
	
	<openblocks:info_book>,
	<wizardry:book>
];

mods.chisel.Carving.addGroup("guideBooks");

for book in books {
	mods.chisel.Carving.addVariation("guideBooks", book);
}

mods.jei.JEI.removeAndHide(<pickletweaks:mortar_and_pestle>);

recipes.remove(<sonarcore:reinforcedstoneblock>); //removed, used as surface block on exoplanet
<sonarcore:reinforcedstoneblock>.displayName = "Enriched Stone";
	
	#ArchitectureCraft Sawbench
recipes.remove(<architecturecraft:sawbench>);
recipes.addShaped(<architecturecraft:sawbench>, [
	[<ore:slabStone>, <primal_tech:flint_edged_disc>, <ore:slabStone>],
	[<ore:stickWood>, <architecturecraft:largepulley>, <ore:stickWood>],
	[<ore:stickWood>, <minecraft:wooden_pressure_plate>, <ore:stickWood>]]);

	#Architexturecraft Chisel
recipes.remove(<architecturecraft:chisel>);
recipes.addShapeless(<architecturecraft:chisel>, [<chisel:chisel_iron>]);


	#artifacts
<contenttweaker:overworldessencer>.displayName = "Euclydes Prime Artifact";
<contenttweaker:overworldessencer>.addTooltip(format.darkRed("Used to Discover and Warp to the planet Euclydes Prime."));	
<contenttweaker:overworldessencel>.displayName = "Aurellia Artifact";
<contenttweaker:overworldessencel>.addTooltip(format.darkRed("Used to Discover and Warp to the planet Aurellia."));
	
	
	#portal block from sonarcore
recipes.remove(<sonarcore:stablestoneblackrimmed_lightblue>);
<sonarcore:stablestoneblackrimmed_lightblue>.hardness = 50;
<sonarcore:stablestoneblackrimmed_lightblue>.displayName = "Overworld Portal Block";
<sonarcore:stablestoneblackrimmed_lightblue>.addTooltip(format.darkRed("Used to build a Portal to Overworld. Can be chiseled into an animated version."));

mods.chisel.Carving.addGroup("overworldPortals");
mods.chisel.Carving.addVariation("overworldPortals", <sonarcore:stablestoneblackrimmed_lightblue>);
mods.chisel.Carving.addVariation("overworldPortals", <contenttweaker:portalblockt>);
	
	#apotheosis bookshelf removed to fusion
	recipes.remove(<apotheosis:hellshelf>);
	
	#apotheosis xp bottles from materials
	recipes.remove(<minecraft:experience_bottle>);
	
	#Nether portal
recipes.remove(<sonarcore:stablestonerimmed_black>);
<sonarcore:stablestonerimmed_black>.displayName = "Nether Portal Block";
<sonarcore:stablestonerimmed_black>.addTooltip(format.darkRed("Used to build a Portal to the Nether. Can be chiseled into an animated version."));

RecipeBuilder.get("basic")
	.setShaped([
		[<ore:gemFlawedQuartzite>, <ore:plateThaumium>, <ore:gemFlawedQuartzite>],
		[<ore:plateSteel>, <extrautils2:angelblock>, <ore:plateSteel>],
		[<ore:blockObsidian>, <ore:blockObsidian>, <ore:blockObsidian>]])
	.setFluid(<liquid:liquid_death>*100)
	.addTool(<ore:artisanHammers>, 10)
	.addOutput(<sonarcore:stablestonerimmed_black>)
	.create();	
	
mods.chisel.Carving.addGroup("netherPortals");
mods.chisel.Carving.addVariation("netherPortals", <sonarcore:stablestonerimmed_black>);
mods.chisel.Carving.addVariation("netherPortals", <contenttweaker:portalblockunt>);
	
	#miniature black hole for portal gun
recipes.remove(<portalgun:item_miniature_black_hole>);
recipes.addShaped(<portalgun:item_miniature_black_hole>, 
	[[<ore:dustEnderEye>, <ore:dustAstralStarmetal>, <ore:dustEnderEye>],
	[<ore:dustAstralStarmetal>, <ore:netherStar>, <ore:dustAstralStarmetal>], 
	[<ore:dustEnderEye>, <ore:dustAstralStarmetal>, <ore:dustEnderEye>]]);	

	#building gadgets
recipes.remove(<buildinggadgets:copypastetool>);
recipes.addShaped(<buildinggadgets:copypastetool>, 
	[[<ore:plateSteel>, <metaitem:circuit.good>, <ore:plateSteel>],
	[<minecraft:ender_pearl>, <rftools:builder>, <minecraft:ender_pearl>], 
	[<ore:plateSteel>, <bloodmagic:component:3>, <ore:plateSteel>]]);

recipes.remove(<buildinggadgets:buildingtool>);
recipes.addShaped(<buildinggadgets:buildingtool>, 
	[[<ore:plateSteel>, <ore:alloyAdvanced>, <ore:plateSteel>],
	[<minecraft:ender_pearl>, <thermalfoundation:material:640>, <minecraft:ender_pearl>], 
	[<ore:plateSteel>, <mekanism:energytablet>, <ore:plateSteel>]]);

recipes.remove(<buildinggadgets:exchangertool>);
recipes.addShaped(<buildinggadgets:exchangertool>, 
	[[<ore:plateSteel>, <metaitem:circuit.good>, <ore:plateSteel>],
	[<minecraft:ender_pearl>, <bloodmagic:blood_rune:5>, <minecraft:ender_pearl>], 
	[<ore:plateSteel>, <ore:plateSteel>, <ore:plateSteel>]]);

recipes.remove(<buildinggadgets:destructiontool>);	
recipes.addShaped(<buildinggadgets:destructiontool>, 
	[[<ore:plateSteel>, <metaitem:circuit.good>, <ore:plateSteel>],
	[<minecraft:ender_pearl>, <animus:component:2>, <minecraft:ender_pearl>], 
	[<ore:plateSteel>, <ore:plateSteel>, <ore:plateSteel>]]);

	#remove conflicting overworld portalblock
recipes.removeByRecipeName("sonarcore:tile.stablestone_lightblue43");
	
	#Microblock stone rod (identical oredict and recipe to tinkers)
recipes.removeByRecipeName("microblockcbe:stone_rod");
	
	#translocators
recipes.remove(<translocators:translocator_part>);
recipes.addShaped(<translocators:translocator_part> * 2, 
	[[<enderio:item_alloy_nugget:3>, <minecraft:ender_pearl>, <enderio:item_alloy_nugget:3>],
	[<enderio:item_alloy_nugget:3>, <minecraft:piston>, <enderio:item_alloy_nugget:3>], 
	[<enderio:item_alloy_nugget:3>, <ore:circuitPrimitive>, <enderio:item_alloy_nugget:3>]]);

recipes.remove(<translocators:translocator_part:1>);		
recipes.addShaped(<translocators:translocator_part:1> * 2, 
	[[<enderio:item_alloy_nugget:3>, <minecraft:ender_pearl>, <enderio:item_alloy_nugget:3>],
	[<enderio:item_alloy_nugget:3>, <minecraft:sticky_piston>, <enderio:item_alloy_nugget:3>], 
	[<enderio:item_alloy_nugget:3>, <ore:circuitPrimitive>, <enderio:item_alloy_nugget:3>]]);
	
RecipeBuilder.get("basic")
	.setShaped([
		[<xtones:reed>, <projecte:item.pe_covalence_dust>, <xtones:reed>],
		[<ore:blockSeared>, <chisel:paper>, <ore:blockSeared>],
		[<xtones:reed>, <projecte:item.pe_covalence_dust>, <xtones:reed>]])
	.setFluid(<liquid:lava>*100)
	.addTool(<ore:artisanHammers>, 10)
	.addOutput(<sonarcore:stablestoneblackrimmed_lightblue>)
	.create();

	#nature's compass
recipes.remove(<naturescompass:naturescompass>);
RecipeBuilder.get("basic")
	.setShaped([
		[<ore:plant>, <ore:botaniaPetals>, <ore:plant>],
		[<ore:botaniaPetals>, <minecraft:compass>, <ore:botaniaPetals>],
		[<ore:plant>, <ore:botaniaPetals>, <ore:plant>]])
	.setFluid(<liquid:menrilresin>*1000)
	.addTool(<ore:artisanHammers>, 10)
	.addOutput(<naturescompass:naturescompass>)
	.create();	
	
	#mitts
recipes.remove(<hotornot:mitts>);
recipes.addShaped(<hotornot:mitts>,[
	[<ore:materialCloth>,<harvestcraft:hardenedleatheritem>,<ore:materialCloth>],
	[<ore:materialCloth>,<ore:slimeball>,<ore:materialCloth>],
	[null,null,null]
	]);

	#Simple teleporters
furnace.remove(<lteleporters:endercrystal>);
recipes.remove(<lteleporters:teleporter>);

	#rockwool
furnace.remove(<thermalfoundation:rockwool:7>);
	
	  	#Ender Crystal
RecipeBuilder.get("basic")
	.setShaped([
		[null, <projecte:item.pe_covalence_dust>, null],
		[<projecte:item.pe_covalence_dust>, <extrautils2:endershard>, <projecte:item.pe_covalence_dust>],
		[null, <projecte:item.pe_covalence_dust>, null]])
	.setFluid(<liquid:mana_fluid> * 500)
	.addTool(<ore:artisanHammers>, 10)
	.addOutput(<lteleporters:endercrystal>)
	.create();

	#Teleporter
mods.astralsorcery.Altar.addDiscoveryAltarRecipe("simpleteleporters:teleporter", <lteleporters:teleporter>, 120, 200, [
	null, <ore:plateGold>, null,
	<lteleporters:endercrystal>, <astralsorcery:blockmarble:2>, <lteleporters:endercrystal>, 
	<astralsorcery:blockmarble:6>, <astralsorcery:blockmarble:6>, <astralsorcery:blockmarble:6>]);
		
	#portalGun fuel
furnace.remove(<portalgun:item_dust_ender_pearl>);
mods.jei.JEI.removeAndHide(<portalgun:item_dust_ender_pearl>);
		
	#Quark chute
mods.jei.JEI.removeAndHide(<quark:chute>);

	#remove dinocreeper items
mods.jei.JEI.removeAndHide(<lcrdrfs:jetpack>);
mods.jei.JEI.removeAndHide(<lcrdrfs:jet_control_unit>);
mods.jei.JEI.removeAndHide(<lcrdrfs:jet_stabliser>);
mods.jei.JEI.removeAndHide(<lcrdrfs:jet_thruster>);
mods.jei.JEI.removeAndHide(<lcrdrfs:laser_grip>);
mods.jei.JEI.removeAndHide(<lcrdrfs:laser_lens_unit>);
mods.jei.JEI.removeAndHide(<lcrdrfs:empty_laser_blaster>);
mods.jei.JEI.removeAndHide(<lcrdrfs:laser_grip>);
mods.jei.JEI.removeAndHide(<lcrdrfs:laser_barrel>);
mods.jei.JEI.removeAndHide(<lcrdrfs:laser_blaster>);
mods.jei.JEI.removeAndHide(<lcrdrfs:spider_jetpack>);
	
print("-------------------Misc End----------------");