import mods.artisanworktables.builder.RecipeBuilder;
import mods.gregtech.recipe.RecipeMap;
import crafttweaker.item.IIngredient;
import crafttweaker.data.IData;
import crafttweaker.item.IItemStack;
import crafttweaker.item.IItemTransformer;
import crafttweaker.oredict.IOreDict;


print("---------------Pam's Harvestcraft Start------------------");
val centrifuge = mods.gregtech.recipe.RecipeMap.getByName("centrifuge");

val fruitBait = <harvestcraft:fruitbaititem>;
val grainBait = <harvestcraft:grainbaititem>;
val veggieBait = <harvestcraft:veggiebaititem>;
val cookingOil = <harvestcraft:oliveoilitem>;

	#Bait - Fish
recipes.remove(<harvestcraft:fishtrapbaititem>);
recipes.addShapeless(<harvestcraft:fishtrapbaititem> * 4, 
	[<ore:stringTwine>, <ore:stringTwine>, <ore:stringTwine>, <ore:listAllfishraw>]);

	#Bait - Fruit
recipes.remove(fruitBait);
recipes.addShapeless(fruitBait * 4, 
	[<ore:stringTwine>, <ore:stringTwine>, <ore:stringTwine>, <ore:listAllfruit>]);

	#Bait - Grain
recipes.remove(grainBait);
grainBait.addTooltip("Will provide beef.");
recipes.addShapeless(grainBait * 4, 
	[<ore:stringTwine>, <ore:stringTwine>, <ore:stringTwine>, <ore:listAllgrain>]);
recipes.addShapeless(grainBait * 4, 
	[<ore:stringTwine>, <ore:stringTwine>, <ore:stringTwine>, <ore:cropRice>]);

	#Bait - Veggie
recipes.remove(veggieBait);
veggieBait.addTooltip("Will not provide beef.");
recipes.addShapeless(veggieBait * 4, 
	[<ore:stringTwine>, <ore:stringTwine>, <ore:stringTwine>, <ore:listAllveggie>]);

	#candles
recipes.remove(<harvestcraft:candledeco1>);
recipes.addShapeless(<harvestcraft:candledeco1> *4, [<ore:materialPressedwax>, <ore:string>]);

	#candleberry seed
mods.bloodmagic.AlchemyArray.addRecipe(<harvestcraft:candleberryseeditem>, <actuallyadditions:item_canola_seed>, <rustic:tallow>);

	#fresh milk from clay bucket
recipes.addShapeless(<harvestcraft:freshmilkitem>*4,
	[<ceramics:clay_bucket:1>.giveBack(<ceramics:clay_bucket>)]);

	#Fresh water
recipes.remove(<harvestcraft:freshwateritem>);
RecipeBuilder.get("basic")
	.setShaped([
		[null, null, null],
		[null, <harvestcraft:potitem>.reuse(), null],
		[null, null, null]])
	.setFluid(<liquid:water> * 500)
	.addOutput(<harvestcraft:freshwateritem>)
	.create();


	#Gardens
mods.rustic.Condenser.addRecipe(<harvestcraft:aridgarden>, <cyclicmagic:apple_emerald>, <minecraft:sapling:4>);
mods.rustic.Condenser.addRecipe(<harvestcraft:frostgarden>, <cyclicmagic:apple_emerald>, <minecraft:sapling:1>);
mods.rustic.Condenser.addRecipe(<harvestcraft:shadedgarden>, <cyclicmagic:apple_emerald>, <minecraft:sapling:5>);
mods.rustic.Condenser.addRecipe(<harvestcraft:soggygarden>, <cyclicmagic:apple_emerald>, <minecraft:sapling:2>);
mods.rustic.Condenser.addRecipe(<harvestcraft:tropicalgarden>, <cyclicmagic:apple_emerald>, <minecraft:sapling:3>);
mods.rustic.Condenser.addRecipe(<harvestcraft:windygarden>, <cyclicmagic:apple_emerald>, <minecraft:sapling>);

	#Grinder (removed only purpose is doubling of raw meats)
mods.jei.JEI.removeAndHide(<harvestcraft:grinder>);

	#presser revamp
var presserRecipes as IItemStack[][IItemStack] = {
	<ore:cropCherry>.firstItem : [<harvestcraft:cherryjuiceitem>, fruitBait ],
	<ore:cropPear>.firstItem : [<harvestcraft:pearjuiceitem>, fruitBait],
	<harvestcraft:soybeanitem> : [<harvestcraft:silkentofuitem>, grainBait],
	<minecraft:apple> : [<harvestcraft:applejuiceitem>, fruitBait],
	<harvestcraft:sunflowerseedsitem> : [cookingOil, grainBait],
	<harvestcraft:silkentofuitem> : [<harvestcraft:firmtofuitem>, <harvestcraft:soymilkitem>],
	<harvestcraft:persimmonitem> : [<harvestcraft:persimmonjuiceitem>, fruitBait],
	<harvestcraft:strawberryitem> : [<harvestcraft:strawberryjuiceitem>, fruitBait],
	<minecraft:pumpkin_seeds> : [cookingOil, grainBait],
	<harvestcraft:grapeitem> : [<harvestcraft:grapejuiceitem>, fruitBait],
	<harvestcraft:almonditem> : [<harvestcraft:freshmilkitem>, grainBait],
	<harvestcraft:plumitem> : [<harvestcraft:plumjuiceitem>, fruitBait],
	<harvestcraft:starfruititem> : [<harvestcraft:starfruitjuiceitem>, fruitBait],
	<harvestcraft:blueberryitem> : [<harvestcraft:blueberryjuiceitem>, fruitBait],
	<minecraft:carrot> : [<harvestcraft:carrotjuiceitem>, grainBait],
	<harvestcraft:mustardseedsitem> : [cookingOil, grainBait],
	<harvestcraft:freshwateritem> : [<harvestcraft:bubblywateritem>, <harvestcraft:bubblywateritem>],
	<harvestcraft:papayaitem> : [<harvestcraft:papayajuiceitem>, fruitBait],
	<harvestcraft:apricotitem> : [<harvestcraft:apricotjuiceitem>, fruitBait],
	<harvestcraft:limeitem> : [<harvestcraft:limejuiceitem>, fruitBait],
	<harvestcraft:tealeafitem> : [cookingOil, grainBait],
	<harvestcraft:avocadoitem> : [cookingOil, veggieBait],
	<minecraft:pumpkin> : [cookingOil, veggieBait],
	<harvestcraft:kiwiitem> : [<harvestcraft:kiwijuiceitem>, fruitBait],
	<harvestcraft:oliveitem> : [cookingOil, fruitBait],
	<harvestcraft:blackberryitem> : [<harvestcraft:blackberryjuiceitem>, fruitBait],
	<harvestcraft:orangeitem> : [<harvestcraft:orangejuiceitem>, fruitBait],
	<harvestcraft:grapefruititem> : [<harvestcraft:grapefruitjuiceitem>, fruitBait],
	<harvestcraft:mangoitem> : [<harvestcraft:mangojuiceitem>, fruitBait],
	<harvestcraft:pomegranateitem> : [<harvestcraft:pomegranatejuiceitem>, fruitBait],
	<harvestcraft:cranberryitem> : [<harvestcraft:cranberryjuiceitem>, fruitBait],
	<harvestcraft:coconutitem> : [<harvestcraft:coconutmilkitem>, veggieBait],
	<harvestcraft:raspberryitem> : [<harvestcraft:raspberryjuiceitem>, fruitBait],
	<harvestcraft:sesameseedsseeditem> : [cookingOil, grainBait],
	<harvestcraft:honeycombitem> : [<harvestcraft:honeyitem>, <harvestcraft:beeswaxitem>],	 
	<harvestcraft:cactusfruititem> : [<harvestcraft:cactusfruitjuiceitem>, fruitBait],	 
	<harvestcraft:beetitem> : [<minecraft:sugar>, veggieBait],
	<harvestcraft:figitem> : [<harvestcraft:figjuiceitem>, fruitBait],
	<harvestcraft:waxcombitem> : [<harvestcraft:beeswaxitem>, <harvestcraft:beeswaxitem>],
	<harvestcraft:walnutitem> : [cookingOil, grainBait],
	<harvestcraft:cottonseeditem> : [cookingOil, grainBait],
	<harvestcraft:peachitem> : [<harvestcraft:peachjuiceitem>, fruitBait]
};

	#remove presser
mods.jei.JEI.removeAndHide(<harvestcraft:presser>);

for inputs, product in presserRecipes {
	centrifuge.recipeBuilder()
		.inputs(inputs)
		.outputs([product[0],product[1]])
		.duration(100)
		.EUt(8)
		.buildAndRegister();
}

	#Market
mods.jei.JEI.removeAndHide(<harvestcraft:market>);
	
	#remove hardened leather armor
mods.jei.JEI.removeAndHide(<harvestcraft:hardenedleatherhelmitem>);
mods.jei.JEI.removeAndHide(<harvestcraft:hardenedleatherchestitem>);
mods.jei.JEI.removeAndHide(<harvestcraft:hardenedleatherleggingsitem>);
mods.jei.JEI.removeAndHide(<harvestcraft:hardenedleatherbootsitem>);

	#Salt
<harvestcraft:saltitem>.addTooltip("Woven cloth is not consumed when crafted.");
recipes.remove(<harvestcraft:saltitem>);
RecipeBuilder.get("basic")
	.setShaped([
		[null, null, null],
		[null, <harvestcraft:wovencottonitem>.reuse(), null],
		[null, null, null]])
	.setFluid(<liquid:water> * 500)
	.addOutput(<harvestcraft:saltitem>)
	.create();

	#Shipping Bin
mods.jei.JEI.removeAndHide(<harvestcraft:shippingbin>);

	#Trap - Water
recipes.remove(<harvestcraft:watertrap>);
recipes.addShaped(<harvestcraft:watertrap>, 
	[[<ore:stickWood>, <minecraft:fishing_rod>, <ore:stickWood>],
	[<ore:stringTwine>, <ore:chest>, <ore:stringTwine>], 
	[<ore:stickWood>, <ore:stringTwine>, <ore:stickWood>]]);

	# silken tofu
RecipeBuilder.get("basic")
	.setShapeless([<harvestcraft:silkentofuitem>, <minecraft:bowl>.reuse()])
	.addTool(<ore:artisanHammers>, 2)
	.setFluid(<liquid:water>*500)
	.addOutput(<harvestcraft:firmtofuitem>)
	.create();
	
	#Firm tofu
RecipeBuilder.get("basic")
	.setShapeless([<ore:cropSoybean>, <minecraft:bowl>.reuse()])
	.addTool(<ore:artisanHammers>, 2)
	.setFluid(<liquid:water>*500)
	.addOutput(<harvestcraft:silkentofuitem>)
	.create();
	
	#Trap - Ground
<harvestcraft:groundtrap>.addTooltip(format.darkRed("Requires vanilla grass or dirt on all sides."));
recipes.remove(<harvestcraft:groundtrap>);	
recipes.addShaped(<harvestcraft:groundtrap>, 
	[[<ore:stickWood>, <ore:trapdoorWood>, <ore:stickWood>],
	[<ore:stringTwine>, <ore:chest>, <ore:stringTwine>], 
	[<ore:stickWood>, <ore:stringTwine>, <ore:stickWood>]]);

	#water filter
mods.jei.JEI.removeAndHide(<harvestcraft:waterfilter>);

	#wool
recipes.removeByRecipeName("harvestcraft:wool_0");

print("----------------Pam's Harvestcraft End-------------------");
