/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.gui.GuiHandler;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.configurable.IConfigurableItem;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeAction;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.IModelProviderConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;

public class ItemAction
extends ConfigurableTypeAction<ItemConfig> {
    private static final List<ExtendedConfig<?>> MODEL_ENTRIES = Lists.newArrayList();

    public static void register(Item item, ExtendedConfig<?> config, @Nullable CreativeTabs creativeTabs) {
        ItemAction.register(item, config);
        if (creativeTabs != null) {
            item.func_77637_a(creativeTabs);
        }
    }

    @Override
    public void preRun(ItemConfig eConfig, Configuration config, boolean startup) {
        Property property = config.get(eConfig.getHolderType().getCategory(), eConfig.getNamedId(), eConfig.isEnabled());
        property.setRequiresMcRestart(true);
        property.setComment(eConfig.getComment());
        property.setLanguageKey(eConfig.getFullUnlocalizedName());
        if (startup) {
            eConfig.setEnabled(property.getBoolean(true));
        }
    }

    @Override
    public void postRun(ItemConfig eConfig, Configuration config) {
        eConfig.save();
        Item item = (Item)eConfig.getSubInstance();
        ItemAction.register(item, eConfig, eConfig.getTargetTab());
        if (item instanceof IGuiContainerProvider) {
            IGuiContainerProvider gui = (IGuiContainerProvider)item;
            eConfig.getMod().getGuiHandler().registerGUI(gui, GuiHandler.GuiType.ITEM);
        }
        if (MinecraftHelpers.isClientSide()) {
            ItemAction.handleItemModel(eConfig);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onModelRegistryLoad(ModelRegistryEvent event) {
        for (ExtendedConfig<?> entry : MODEL_ENTRIES) {
            Item item = null;
            Block block = null;
            IModelProviderConfig modelProvider = null;
            if (entry instanceof ItemConfig) {
                item = ((ItemConfig)entry).getItemInstance();
                modelProvider = (IModelProviderConfig)((Object)entry);
            } else if (entry instanceof BlockConfig) {
                block = ((BlockConfig)entry).getBlockInstance();
                item = ((BlockConfig)entry).getItemInstance();
                modelProvider = (IModelProviderConfig)((Object)entry);
            } else {
                throw new IllegalStateException("An unsupported config was registered to the model loader: " + entry.getNamedId());
            }
            String modId = item.getRegistryName().func_110624_b();
            if (item.func_77614_k()) {
                NonNullList itemStacks = NonNullList.func_191196_a();
                item.func_150895_a(item.func_77640_w(), itemStacks);
                for (ItemStack itemStack : itemStacks) {
                    String itemName = modelProvider.getModelName(itemStack);
                    ModelResourceLocation model = new ModelResourceLocation(modId + ":" + itemName, "inventory");
                    ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{model});
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)itemStack.func_77960_j(), (ModelResourceLocation)model);
                }
            } else {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(modId + ":" + item.getRegistryName().func_110623_a(), "inventory"));
            }
            if (!(item instanceof IDynamicModelElement) || !((IDynamicModelElement)item).hasDynamicModel()) continue;
            ItemConfig itemConfig = (ItemConfig)entry;
            itemConfig.dynamicItemVariantLocation = itemConfig.registerDynamicModel();
        }
    }

    public static void handleItemModel(ExtendedConfig<?> extendedConfig) {
        if (MinecraftHelpers.isClientSide()) {
            MODEL_ENTRIES.add(extendedConfig);
        }
    }

    @Override
    public void polish(ItemConfig config) {
        IConfigurableItem configurableItem;
        IItemColor itemColorHandler;
        super.polish(config);
        Item item = config.getItemInstance();
        if (item instanceof IConfigurableItem && MinecraftHelpers.isClientSide() && (itemColorHandler = (configurableItem = (IConfigurableItem)item).getItemColorHandler()) != null) {
            Minecraft.func_71410_x().getItemColors().func_186730_a(itemColorHandler, new Item[]{item});
        }
    }

    static {
        MinecraftForge.EVENT_BUS.register(ItemAction.class);
    }
}

