/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurable;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.config.configurable.IConfigurable;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;
import org.cyclops.cyclopscore.item.DamageIndicatedItemFluidContainer;

public abstract class ConfigurableDamageIndicatedItemFluidContainer
extends DamageIndicatedItemFluidContainer
implements IConfigurable<ItemConfig> {
    protected ItemConfig eConfig = null;
    protected boolean canPickUp = true;
    private boolean placeFluids = false;

    protected ConfigurableDamageIndicatedItemFluidContainer(ExtendedConfig<ItemConfig> eConfig, int capacity, Fluid fluid) {
        super(capacity, fluid);
        this.setConfig((ItemConfig)eConfig);
        this.func_77655_b(eConfig.getUnlocalizedName());
    }

    private void setConfig(ItemConfig eConfig) {
        this.eConfig = eConfig;
    }

    @Override
    public ItemConfig getConfig() {
        return this.eConfig;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        IFluidHandlerItemCapacity fluidHandler = FluidHelpers.getFluidHandlerItemCapacity(itemStack);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack);
        FluidStack drained = fluidHandler.drain(1000, false);
        Block block = this.getFluid().getBlock();
        boolean hasBucket = drained != null && drained.amount == 1000;
        boolean hasSpace = fluidStack == null || fluidStack.amount + 1000 <= fluidHandler.getCapacity();
        RayTraceResult movingobjectpositionDrain = this.func_77621_a(world, player, false);
        RayTraceResult movingobjectpositionFill = this.func_77621_a(world, player, true);
        if (movingobjectpositionDrain != null && movingobjectpositionFill != null) {
            BlockPos blockPos;
            if (this.isPickupFluids() && movingobjectpositionFill.field_72313_a == RayTraceResult.Type.BLOCK) {
                blockPos = movingobjectpositionFill.func_178782_a();
                if (!world.canMineBlockBody(player, blockPos)) {
                    return MinecraftHelpers.successAction(itemStack);
                }
                if (world.func_180495_p(blockPos).func_177230_c() == block && (Integer)world.func_180495_p(blockPos).func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
                    if (hasSpace) {
                        world.func_175698_g(blockPos);
                        fluidHandler.fill(new FluidStack(this.getFluid(), 1000), true);
                    }
                    return MinecraftHelpers.successAction(itemStack);
                }
            }
            if (hasBucket && this.isPlaceFluids() && movingobjectpositionDrain.field_72313_a == RayTraceResult.Type.BLOCK) {
                blockPos = movingobjectpositionFill.func_178782_a();
                if (!world.canMineBlockBody(player, blockPos)) {
                    return MinecraftHelpers.successAction(itemStack);
                }
                EnumFacing direction = movingobjectpositionDrain.field_178784_b;
                if (this.tryPlaceContainedLiquid(world, blockPos = blockPos.func_177971_a(direction.func_176730_m()), block, true)) {
                    fluidHandler.drain(1000, true);
                    return MinecraftHelpers.successAction(itemStack);
                }
            }
        }
        return MinecraftHelpers.successAction(itemStack);
    }

    private boolean tryPlaceContainedLiquid(World world, BlockPos blockPos, Block block, boolean hasBucket) {
        if (!hasBucket) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(blockPos);
        Material material = blockState.func_185904_a();
        if (!world.func_175623_d(blockPos) && material.func_76220_a()) {
            return false;
        }
        if (!(world.field_72995_K || material.func_76220_a() || material.func_76224_d())) {
            world.func_175655_b(blockPos, true);
        }
        world.func_180501_a(blockPos, block.func_176223_P(), 3);
        return true;
    }

    public boolean func_82788_x() {
        return true;
    }

    public boolean isPlaceFluids() {
        return this.placeFluids;
    }

    public boolean isPickupFluids() {
        return this.canPickUp;
    }

    public void setPlaceFluids(boolean placeFluids) {
        this.placeFluids = placeFluids;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.PASS;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
        L10NHelpers.addOptionalInfo(list, this.func_77658_a());
        super.func_77624_a(itemStack, world, list, flag);
    }

    protected FluidStack drainFromOthers(int amount, ItemStack itemStack, Fluid fluid, EntityPlayer player, boolean doDrain) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        FluidStack drained = null;
        while (it.hasNext() && amount > 0) {
            FluidStack thisDrained;
            ItemStack current = it.next();
            if (current == null || current == itemStack || FluidUtil.getFluidHandler((ItemStack)current) == null) continue;
            IFluidHandlerItem containerItem = FluidUtil.getFluidHandler((ItemStack)current);
            FluidStack totalFluid = FluidUtil.getFluidContained((ItemStack)current);
            if (totalFluid == null || totalFluid.getFluid() != fluid || (thisDrained = containerItem.drain(amount, doDrain)) == null || thisDrained.getFluid() != fluid) continue;
            if (drained == null) {
                drained = thisDrained;
            } else {
                drained.amount += drained.amount;
            }
            amount -= drained.amount;
        }
        if (drained != null && drained.amount == 0) {
            drained = null;
        }
        return drained;
    }

    public boolean canConsume(int amount, ItemStack itemStack, @Nullable EntityPlayer player) {
        if (this.canDrain(amount, itemStack)) {
            return true;
        }
        int availableAmount = 0;
        if (FluidUtil.getFluidContained((ItemStack)itemStack) != null) {
            availableAmount = FluidUtil.getFluidContained((ItemStack)itemStack).amount;
        }
        return player != null && this.drainFromOthers(amount - availableAmount, itemStack, this.getFluid(), player, false) != null;
    }

    public FluidStack consume(int amount, ItemStack itemStack, @Nullable EntityPlayer player) {
        FluidStack otherDrained;
        boolean doDrain;
        boolean bl = doDrain = player == null || !player.field_71075_bZ.field_75098_d && !player.field_70170_p.field_72995_K;
        if (amount == 0) {
            return null;
        }
        FluidStack drained = FluidUtil.getFluidHandler((ItemStack)itemStack).drain(amount, doDrain);
        if (drained != null && drained.amount == amount) {
            return drained;
        }
        int drainedAmount = drained == null ? 0 : drained.amount;
        int toDrain = amount - drainedAmount;
        FluidStack fluidStack = otherDrained = player == null ? null : this.drainFromOthers(toDrain, itemStack, this.getFluid(), player, doDrain);
        if (otherDrained == null) {
            return drained;
        }
        otherDrained.amount += drainedAmount;
        return otherDrained;
    }
}

