/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class RomanNumerals {
    private static final String[] ROMAN_NUMERALS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final int[] ROMAN_NUMERAL_VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final Map<Integer, String> cache = new ConcurrentHashMap<Integer, String>();

    private RomanNumerals() {
    }

    public static String get(int number) {
        boolean negative;
        if (number == 0) {
            return "Nulla";
        }
        String cached = cache.get(number);
        if (cached != null) {
            return cached;
        }
        boolean bl = negative = number < 0;
        if (negative) {
            number = -number;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < ROMAN_NUMERALS.length; ++i) {
            while (number >= ROMAN_NUMERAL_VALUES[i]) {
                if (number > 3999) {
                    String string = String.valueOf(number);
                    int nested = Integer.parseInt(string.substring(0, 1 + (string.length() - 4)));
                    builder.append('(').append(RomanNumerals.get(nested)).append(')');
                    number -= nested * 1000;
                    continue;
                }
                builder.append(ROMAN_NUMERALS[i]);
                number -= ROMAN_NUMERAL_VALUES[i];
            }
        }
        String romanNumeral = builder.toString();
        if (negative) {
            romanNumeral = "-" + romanNumeral;
        }
        cache.put(number, romanNumeral);
        return romanNumeral;
    }
}

