/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.util;

public enum Alignment {
    TOPLEFT("topLeft", 2, 2),
    TOPCENTER("topCenter", 0, 2),
    TOPRIGHT("topRight", -2, 2),
    MIDDLELEFT("middleLeft", 2, 0),
    MIDDLECENTER("middleCenter", 0, 0),
    MIDDLERIGHT("middleRight", -2, 0),
    BOTTOMLEFT("bottomLeft", 2, -2),
    BOTTOMCENTER("bottomCenter", 0, -45),
    BOTTOMRIGHT("bottomRight", -2, -2);

    private static final int MASK_X = 12;
    private static final int MASK_Y = 3;
    private static final int TOP = 1;
    private static final int MIDDLE = 3;
    private static final int BOTTOM = 2;
    private static final int LEFT = 4;
    private static final int CENTER = 12;
    private static final int RIGHT = 8;
    private final int defaultX;
    private final int defaultY;
    private final String translationKey;
    private int alignment;

    private Alignment(String translationKey, int x, int y) {
        this.translationKey = "randomtweaks.config.timeOfDay.alignment." + translationKey;
        this.defaultX = x;
        this.defaultY = y;
    }

    public String toString() {
        return this.translationKey;
    }

    public int getX(int x, int screenWidth, int textWidth) {
        x += this.defaultX;
        switch (this.alignment & 0xC) {
            case 4: {
                return x;
            }
            case 12: {
                return x + (screenWidth - textWidth) / 2;
            }
            case 8: {
                return x + screenWidth - textWidth;
            }
        }
        return 0;
    }

    public int getY(int y, int screenHeight, int textHeight) {
        y += this.defaultY;
        switch (this.alignment & 3) {
            case 1: {
                return y;
            }
            case 3: {
                return y + (screenHeight - textHeight) / 2;
            }
            case 2: {
                return y + screenHeight - textHeight;
            }
        }
        return 0;
    }

    public int getDefaultX() {
        return this.defaultX;
    }

    public int getDefaultY() {
        return this.defaultY;
    }

    static {
        Alignment.TOPLEFT.alignment = 5;
        Alignment.TOPCENTER.alignment = 13;
        Alignment.TOPRIGHT.alignment = 9;
        Alignment.MIDDLELEFT.alignment = 7;
        Alignment.MIDDLECENTER.alignment = 15;
        Alignment.MIDDLERIGHT.alignment = 11;
        Alignment.BOTTOMLEFT.alignment = 6;
        Alignment.BOTTOMCENTER.alignment = 14;
        Alignment.BOTTOMRIGHT.alignment = 10;
    }
}

