/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomtweaks.common.world;

import com.therandomlabs.randomtweaks.RTConfig;
import com.therandomlabs.randomtweaks.RandomTweaks;
import com.therandomlabs.randomtweaks.common.world.RTWorldType;
import com.therandomlabs.randomtweaks.common.world.WorldTypeRealistic;
import com.therandomlabs.randomtweaks.common.world.WorldTypeVoid;
import com.therandomlabs.randomtweaks.common.world.WorldTypeVoidIslands;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.WorldType;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomtweaks")
public final class WorldTypeRegistry {
    static final List<RTWorldType> worldTypes = new ArrayList<RTWorldType>();
    public static final WorldTypeRealistic REALISTIC;
    public static final WorldTypeVoid VOID;
    public static final WorldTypeVoidIslands VOID_ISLANDS;

    public static void registerWorldTypes() {
        worldTypes.forEach(RTWorldType::onConfigReload);
    }

    public static boolean shouldRegisterRealisticWorldType() {
        if (!RTConfig.world.realisticWorldType) {
            return false;
        }
        if (!RandomTweaks.QUARK_LOADED) {
            return true;
        }
        try {
            Class<?> moduleLoader = Class.forName("vazkii.quark.base.module.ModuleLoader");
            Method isFeatureEnabled = moduleLoader.getDeclaredMethod("isFeatureEnabled", Class.class);
            Class<?> realisticWorldType = Class.forName("vazkii.quark.world.feature.RealisticWorldType");
            return (Boolean)isFeatureEnabled.invoke(null, realisticWorldType) == false;
        }
        catch (Exception ex) {
            RandomTweaks.LOGGER.error("Failed to check if Quark's realistic world type is enabled", (Throwable)ex);
            return true;
        }
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.PostConfigChangedEvent event) {
        if (event.getModID().equals("randomtweaks")) {
            WorldTypeRegistry.registerWorldTypes();
        }
    }

    static {
        if (WorldType.field_77139_a.getClass() != WorldType[].class) {
            REALISTIC = null;
            VOID = null;
            VOID_ISLANDS = null;
        } else {
            REALISTIC = new WorldTypeRealistic();
            VOID = new WorldTypeVoid();
            VOID_ISLANDS = new WorldTypeVoidIslands();
        }
    }
}

