/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.events;

import ca.wescook.nutrition.capabilities.INutrientManager;
import ca.wescook.nutrition.effects.EffectsManager;
import ca.wescook.nutrition.nutrients.Nutrient;
import ca.wescook.nutrition.nutrients.NutrientUtils;
import ca.wescook.nutrition.proxy.ClientProxy;
import ca.wescook.nutrition.utility.Config;
import java.util.List;
import net.minecraft.block.BlockCake;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventEatFood {
    @CapabilityInject(value=INutrientManager.class)
    private static final Capability<INutrientManager> NUTRITION_CAPABILITY = null;

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = (EntityPlayer)event.getEntity();
        World world = event.getWorld();
        IBlockState blockState = world.func_180495_p(event.getPos());
        if (!(blockState.func_177230_c() instanceof BlockCake)) {
            return;
        }
        if (player.func_71043_e(false) || Config.allowOverEating) {
            Item item = Item.func_111206_d((String)blockState.func_177230_c().getRegistryName().toString());
            ItemStack itemStack = new ItemStack(item);
            List<Nutrient> foundNutrients = NutrientUtils.getFoodNutrients(itemStack);
            float nutritionValue = NutrientUtils.calculateNutrition(itemStack, foundNutrients);
            if (!player.func_130014_f_().field_72995_K) {
                ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).add(foundNutrients, nutritionValue);
            } else {
                ClientProxy.localNutrition.add(foundNutrients, nutritionValue);
            }
            if (!player.func_130014_f_().field_72995_K && !player.func_71043_e(false) && Config.allowOverEating) {
                int cakeBites = (Integer)blockState.func_177229_b((IProperty)BlockCake.field_176589_a);
                if (cakeBites < 6) {
                    world.func_180501_a(event.getPos(), blockState.func_177226_a((IProperty)BlockCake.field_176589_a, (Comparable)Integer.valueOf(cakeBites + 1)), 3);
                } else {
                    world.func_175698_g(event.getPos());
                }
            }
        }
    }

    @SubscribeEvent
    public void startUsingItem(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        ItemStack itemStack = event.getItemStack();
        if (itemStack == null) {
            return;
        }
        Item item = itemStack.func_77973_b();
        if (!(item instanceof ItemFood)) {
            return;
        }
        if (Config.allowOverEating) {
            ((ItemFood)item).func_77848_i();
        }
    }

    @SubscribeEvent
    public void finishUsingItem(LivingEntityUseItemEvent.Finish event) {
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        ItemStack itemStack = event.getItem();
        int stackSize = itemStack.func_190916_E();
        itemStack.func_190920_e(1);
        ItemStack dummyStack = itemStack.func_77946_l();
        itemStack.func_190920_e(stackSize);
        EntityPlayer player = (EntityPlayer)event.getEntity();
        this.applyNutrition(player, dummyStack);
        this.reapplyEffectsFromMilk(player, dummyStack);
    }

    private void applyNutrition(EntityPlayer player, ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemFood) && !(itemStack.func_77973_b() instanceof ItemBucketMilk)) {
            return;
        }
        List<Nutrient> foundNutrients = NutrientUtils.getFoodNutrients(itemStack);
        float nutritionValue = NutrientUtils.calculateNutrition(itemStack, foundNutrients);
        if (!player.func_130014_f_().field_72995_K) {
            ((INutrientManager)player.getCapability(NUTRITION_CAPABILITY, null)).add(foundNutrients, nutritionValue);
        } else {
            ClientProxy.localNutrition.add(foundNutrients, nutritionValue);
        }
    }

    private void reapplyEffectsFromMilk(EntityPlayer player, ItemStack itemStack) {
        if (player.func_130014_f_().field_72995_K) {
            return;
        }
        if (!(itemStack.func_77973_b() instanceof ItemBucketMilk)) {
            return;
        }
        EffectsManager.reapplyEffects(player);
    }
}

