/*
 * Decompiled with CFR 0.152.
 */
package com.github.atomicblom.weirdinggadget.client.opengex;

import com.github.atomicblom.weirdinggadget.client.opengex.OpenGEXModel;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.Axis;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexMatrixTransform;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexNode;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexParser;
import com.github.atomicblom.weirdinggadget.client.opengex.ogex.OgexScene;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public enum OpenGEXModelLoader implements ICustomModelLoader
{
    INSTANCE;

    private IResourceManager manager;
    private final Map<ResourceLocation, OgexScene> cache = Maps.newHashMap();
    private Set<String> enabledDomains = Sets.newHashSet();

    private OpenGEXModelLoader() {
        this.enabledDomains.add("steamnsteel_opengex");
    }

    public void addDomain(String domain) {
        this.enabledDomains.add(domain.toLowerCase());
    }

    public boolean accepts(ResourceLocation modelLocation) {
        return this.enabledDomains.contains(modelLocation.func_110624_b().toLowerCase()) && modelLocation.func_110623_a().toLowerCase().endsWith(".ogex");
    }

    public void func_110549_a(IResourceManager manager) {
        this.manager = manager;
        this.cache.clear();
    }

    public IModel loadModel(ResourceLocation modelLocation) throws IOException {
        OgexScene scene;
        ResourceLocation file = new ResourceLocation(modelLocation.func_110624_b(), modelLocation.func_110623_a());
        if (!this.cache.containsKey(file)) {
            try {
                IResource resource;
                try {
                    resource = this.manager.func_110536_a(file);
                }
                catch (FileNotFoundException e) {
                    if (modelLocation.func_110623_a().startsWith("models/block/")) {
                        resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/item/" + file.func_110623_a().substring("models/block/".length())));
                    }
                    if (modelLocation.func_110623_a().startsWith("models/item/")) {
                        resource = this.manager.func_110536_a(new ResourceLocation(file.func_110624_b(), "models/block/" + file.func_110623_a().substring("models/item/".length())));
                    }
                    throw e;
                }
                OgexParser ogexParser = new OgexParser();
                InputStreamReader reader = new InputStreamReader(resource.func_110527_b());
                OgexScene ogexScene = ogexParser.parseScene(reader);
                this.cache.put(file, ogexScene);
            }
            catch (IOException e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Exception loading model %s with OGEX loader, skipping", (Object[])new Object[]{modelLocation});
                this.cache.put(file, null);
                throw e;
            }
        }
        if ((scene = this.cache.get(file)) == null) {
            return ModelLoaderRegistry.getMissingModel();
        }
        if (scene.getMetrics().getUp() == Axis.Z) {
            float[] cycleMatrix = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
            for (OgexNode ogexNode : scene) {
                OgexMatrixTransform matrixTransform = new OgexMatrixTransform();
                matrixTransform.setMatrix(cycleMatrix);
                ogexNode.getTransforms().add(0, matrixTransform);
            }
        }
        return new OpenGEXModel(file, scene);
    }
}

