/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.tank;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.block.core.BlockBase;
import com.lothrazar.cyclicmagic.block.core.IBlockHasTESR;
import com.lothrazar.cyclicmagic.block.tank.FluidTESR;
import com.lothrazar.cyclicmagic.block.tank.ItemBlockFluidTank;
import com.lothrazar.cyclicmagic.block.tank.TileEntityFluidTank;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.guide.GuideRegistry;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFluidTank
extends BlockBase
implements ITileEntityProvider,
IHasRecipe,
IBlockHasTESR,
IContent {
    public static final PropertyBool TANK_ABOVE = PropertyBool.func_177716_a((String)"above");
    public static final PropertyBool TANK_BELOW = PropertyBool.func_177716_a((String)"below");
    public static final int heightCheckMax = 16;
    private boolean enabled;

    public BlockFluidTank() {
        super(Material.field_151592_s);
        this.func_149711_c(7.0f);
        this.func_149752_b(7.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.setHarvestLevel("pickaxe", 1);
        this.setTranslucent();
    }

    @Override
    public void register() {
        BlockRegistry.registerBlock((Block)this, new ItemBlockFluidTank(this), "block_storeempty", null);
        GameRegistry.registerTileEntity(TileEntityFluidTank.class, (String)"bucketstorage");
        GuideRegistry.register(GuideCategory.BLOCK, this, null, null);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("BucketBlocks", "cyclicmagic.content", true, "Set false to delete - requires restart");
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean tileAbove = world.func_175625_s(pos.func_177984_a()) instanceof TileEntityFluidTank;
        boolean tileBelow = world.func_175625_s(pos.func_177977_b()) instanceof TileEntityFluidTank;
        return super.func_176221_a(state, world, pos).func_177226_a((IProperty)TANK_ABOVE, (Comparable)Boolean.valueOf(tileAbove)).func_177226_a((IProperty)TANK_BELOW, (Comparable)Boolean.valueOf(tileBelow));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TANK_ABOVE, TANK_BELOW});
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityFluidTank te;
        FluidStack fs;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Item item = Item.func_150898_a((Block)this);
        TileEntity ent = world.func_175625_s(pos);
        ItemStack stack = new ItemStack(item);
        if (ent != null && ent instanceof TileEntityFluidTank && (fs = (te = (TileEntityFluidTank)ent).getCurrentFluidStack()) != null) {
            UtilNBT.setItemStackNBTVal(stack, "FluidName", fs.amount);
            String resourceStr = FluidRegistry.getFluidName((Fluid)fs.getFluid());
            UtilNBT.setItemStackNBTVal(stack, "Amount", resourceStr);
        }
        ret.add(stack);
        return ret;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        FluidStack fluid = ItemBlockFluidTank.copyFluidFromStack(stack);
        if (fluid != null) {
            TileEntityFluidTank container = (TileEntityFluidTank)worldIn.func_175625_s(pos);
            container.fill(fluid, true);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFluidTank();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this), "igi", "gog", "igi", Character.valueOf('o'), "obsidian", Character.valueOf('i'), "ingotIron", Character.valueOf('g'), "blockGlass");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean success = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)pos, (EnumFacing)side);
        int heightCheck = 0;
        BlockPos posLoop = new BlockPos((Vec3i)pos);
        while (!success && heightCheck < 16) {
            ++heightCheck;
            posLoop = posLoop.func_177984_a();
            success = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (World)world, (BlockPos)posLoop, (EnumFacing)side);
        }
        TileEntityFluidTank te = (TileEntityFluidTank)world.func_175625_s(pos);
        if (te != null && !world.field_72995_K) {
            FluidStack fs = te.getCurrentFluidStack();
            if (fs != null) {
                String amtStr = fs.amount + " / " + te.getCapacity() + " ";
                UtilChat.sendStatusMessage(player, UtilChat.lang("cyclic.fluid.amount") + amtStr + fs.getLocalizedName());
            } else {
                UtilChat.sendStatusMessage(player, UtilChat.lang("cyclic.fluid.empty"));
            }
        }
        return success || FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)) != null || super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFluidTank.class, (TileEntitySpecialRenderer)new FluidTESR());
    }
}

